/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.ctrlview.bidim;

import fr.ove.openmath.jome.ctrlview.bidim.BidimDisplay;
import fr.ove.openmath.jome.ctrlview.bidim.Display;
import fr.ove.openmath.jome.ctrlview.bidim.GraphicContext;
import fr.ove.openmath.jome.model.FormulaTreeStructure;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class AbstractStringDisplay
extends BidimDisplay {
    private String string;

    public AbstractStringDisplay(GraphicContext graphicContext, String string) {
        super(graphicContext);
        this.string = string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    @Override
    public void scaleDisplay() {
        this.setTheFont(this.getGraphicContext().scaleFont(this.getLevel()));
        this.setComputeAttributes(true);
        this.invalidate();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        Rectangle rectangle = this.getBounds();
        if (this.isSelected()) {
            graphics.setColor(this.getSelectionColor());
        } else {
            graphics.setColor(this.getBackgroundColor());
        }
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(this.getForegroundColor());
        graphics.setFont(this.getFont());
        if (this.weDrawBounds()) {
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        }
        if (this.string.equals("*")) {
            graphics.drawString(this.string, 1, this.getHeight());
        } else if (this.string.equals("-")) {
            graphics.drawString(this.string, 1, this.getAscent() - Math.round((float)this.getDescent() * 0.4f));
        } else {
            graphics.drawString(this.string, 1, this.getAscent());
        }
        graphics.setColor(color);
        graphics.setFont(font);
    }

    @Override
    public int computeInsertionPosition(int n) {
        int n2;
        if (this.isSymbolOperatorDisplay()) {
            Display display = (Display)this.getParent();
            display = (Display)display.getComponent(this.getRank() + 1);
            n2 = ((FormulaTreeStructure)display.getListener()).getRank();
        } else {
            n2 = n <= this.getWidth() / 2 ? ((FormulaTreeStructure)this.getListener()).getRank() : ((FormulaTreeStructure)this.getListener()).getRank() + 1;
        }
        return n2;
    }

    @Override
    public void ToString() {
        super.ToString();
        System.out.println(" string = " + this.string);
    }

    @Override
    public void whoAmI() {
        System.out.println("I am the StringDisplay : " + this.string);
        System.out.println("My level is " + this.getLevel());
    }
}

