---
myst:
  html_meta:
    keywords: LaTeX, informatique, langages de programmation, mise en forme de code, 
              coloration syntaxique, formater un programme, formater du code, verbatim, 
              insérer du code-source, listing informatique, listing
---

# Comment mettre en forme du code informatique ?

Les logiciels qui affichent du code informatique utilisent des couleurs pour rendre les
programmes plus lisibles. Ceci permet de repérer visuellement les mots-clefs du langage,
les noms de variables, etc. Il est possible de faire la même chose avec LaTeX, pour que la
structure du code soit soulignée par la mise en forme. C'est très utile pour les livres
sur la programmation, mais aussi pour les travaux des étudiants en informatique.

Notez que l'inclusion de code [verbatim](/4_domaines_specialises/sciences/informatique/verbatim/start)
est traitée ailleurs, de même que le problème de 
[mise en forme des algorithmes](/4_domaines_specialises/sciences/informatique/ecrire_du_pseudocode).


## Avec l'extension <ctanpkg:listings>

L'extension <ctanpkg:listings> est l’une des plus abouties pour une sortie 
mise en forme (il se charge d'analyser les sources des programmes et d'utiliser 
différentes polices de caractères pour en mettre la structure en évidence).

Il est moins puissant mais plus immédiat dans son utilisation que <ctanpkg:minted> 
par exemple.

On peut utiliser <ctanpkg:listings> pour mettre en page des extraits de code inclus 
dans le source :

```
\documentclass{article}
  \usepackage{lmodern}
  \usepackage{listings}
  \pagestyle{empty}

  \lstset{language=C}

\begin{document}
\begin{lstlisting}
#include <stdio.h>

int main(int argc, char ** argv)
{
  printf("Bonjour tout le monde !\n");
  return 0;
}
\end{lstlisting}
\end{document}
```

Mais vous pouvez aussi traiter des fichiers entiers de code :

```{noedit}
\usepackage{listings}
\lstset{language=C}
...
\begin{document}
\lstinputlisting{main.c}
\end{document}
```

Ces exemples très simples peuvent être présentés d'une grande variété de façons, 
et, bien sûr, il y a d'autres langages dans l'extension en plus du `C`...

:::{seealso}
Pour plus de détails sur l’utilisation de ce package, consultez
"[](/4_domaines_specialises/sciences/informatique/inserer_du_code_source_informatique_listings)"
:::


## Avec l'extension <ctanpkg:minted>

L'extension <ctanpkg:minted> est une alternative. Elle nécessite quelques réglages 
pour être utilisé mais est ensuite d’une utilisation très simple.

:::{important}
L’utilisation de cette extension nécessite de compiler avec l’option
`shell-escape`, permettant que 
[l'appel aux programmes externes](/2_programmation/compilation/write18) 
soit autorisé.

Ici c’est la biliothèque python [`Pygments`](https://pygments.org/) qui est appelée 
lors de la compilation et nécessite donc d’être installée séparément sur la machine.
:::

L'usage de <ctanpkg:minted> peut être aussi simple que ceci :

```{noedit}
\begin{minted}{⟨language⟩}
...
\end{minted}
```

Pour les plus curieux d'entre vous, `Pygments`, à son tour, a besoin 
d'un analyseur lexical (*lexer*) qui connaît le langage que vous voulez utiliser ; 
il en existe de nombreux, pour les langages les plus utilisés, et il y a aussi 
des conseils pour écrire le vôtre sur le 
[site de Pygments](https://pygments.org/docs/lexerdevelopment/). 

:::{seealso}
Pour plus de détails sur l’utilisation de cette extension, consultez 
"[](/4_domaines_specialises/sciences/informatique/inserer_du_code_source_informatique_minted)"
:::


## Avec l’extension <ctanpkg:tcolorbox>

<ctanpkg:tcolorbox> permet d’utiliser <ctanpkg:minted> ou <ctanpkg:listings> pour en
améliorant encore la mise en forme.

:::{seealso}
Pour plus de détails sur l’utilisation de cette extension, consultez 
"[](/4_domaines_specialises/sciences/informatique/inserer_du_code_source_informatique_tcolorbox)"
:::


## Avec l'extension <ctanpkg:highlight>

<ctanpkg:highlight> est intéressante si vous avez besoin de plus d'un format de
sortie pour votre programme. En effet, en plus de la sortie (La)TeX, <ctanpkg:highlight>
pourra produire des représentations (X)HTML, RTF et XSL-FO de votre code-source. 
[Le manuel (en anglais)](http://www.andre-simon.de/doku/highlight/en/highlight.php) 
vous sera d'une grande aide si vous devez écrire le fichier de paramètres 
pour un nouveau langage, ou modifier la mise en forme d'un langage déjà défini.


## Avec l'extension <ctanpkg:showexpl>

Dans un autre ordre d'idées, l'extension <ctanpkg:showexpl> prend en charge la
mise en forme de code (La)TeX et de sa sortie compilée, dans des "volets"
situés en regard l'un de l'autre. C'est notamment utile pour les manuels
(La)TeX, ou pour les articles sur (La)TeX. L'extension utilise
<ctanpkg:listings> pour le volet (La)TeX et, pour l'autre volet, insère le
résultat de la compilation dans une simple boîte.

:::{note}
L'extension <ctanpkg:tcolorbox> permet de faire la même chose, mais avec toute sa
puissance. Cela semble être une meilleure solution.
:::

## Autres solutions

### L'extension <ctanpkg:lgrind> 

L'extension <ctanpkg:lgrind> (qui fournit un exécutable et un fichier de style,
`lgrind.sty`) permet, entre autres, de formater du code source d'un langage donné en
LaTeX. Parmi les langages reconnus, on trouve : `Ada`, `assembleur`, `BASIC`, `Batch`,
`C`, `C++`, `FORTRAN`, `GnuPlot`, `Icon`, `IDL`, `ISP`, `Java`, `Kimwitu++`, `ABAP`,
`LaTeX`, `LDL`, `Lex`, `Linda`, `Lisp`, `MATLAB`, `ML`, `Mercury`, `model`, `Modula-2`,
`Pascal`, `Perl`, scripts shell, `PostScript`, `Prolog`, `RATFOR`, `RLaB`, `Russell`,
`SAS`, `Scheme`, `SICStus`, `src`, `SQL`, `Tcl/Tk`, `VisualBasic`, `yacc`. Il trouve 
son origine dans `tgrind` qui génrait un travail similaire pour Plain TeX.

Le programme `lgrind` permet à partir du code source de générer du code LaTeX respectant
l'indentation. Il transforme le source en question, par exemple `monfichier.c`, en
`monfichier.tex`, que l'on inclut directement dans son fichier LaTeX, à l'aide d'une
commande appropriée (voir
"[](/3_composition/document/document_inclusion/decouper_un_document_en_plusieurs_fichiers)"). 
L'inconvénient est qu'évidemment, il y a un fichier `.tex` qui est généré en plus.

L'exemple ci-dessous présente le code LaTeX produit par `lgrind` pour le même code souce
Pascal que dans l'exemple précédent (aux changements de ligne près).

:::{note}
- Pour des raisons de licence, <ctanpkg:lgrind> est absent des distributions TeX
  Live et MiKTeX.
- Il faut utiliser au-moins la version 3.6.
- On peut paramétrer <ctanpkg:lgrind> avec le fichier `lgrindef`.
- Par défaut, l'auteur a jugé utile de transformer la lettre « à » en $\alpha$. Il suffit
  donc de commenter cette option à la fin de ce fichier pour éviter cela.
:::

Résultat produit par <ctanpkg:lgrind> :

```{noedit}
\documentclass{article}
  \usepackage[T1]{fontenc}
  \usepackage[procnames,noindent]{lgrind}
  \usepackage{makeidx}
  \pagestyle{fancy}

  \makeindex

\begin{document}
\thispagestyle{empty}

\renewcommand{\footrulewidth}{0.4pt}
\fancyhead[C]{\lgrindhead}
\fancyhead[LO,RE]{\lgrindfilesize~Bytes\\%
\lgrindmodtime}
\fancyhead[RO,LE]{\bfseries \lgrindfilename\\%
\lgrindmodday.\lgrindmodmonth.\lgrindmodyear}
\fancyfoot[C]{\bfseries\thepage}
\setlength{\headheight}{24pt}
\begin{lgrind}
\BGfont
\File{toto.p}{2004}{2}{18}{16:08}{119}
\L{\LB{\K{program}_\V{Toto};}}
\L{\LB{}\Tab{2}{\K{var}_\V{i}_:_\V{integer};}}
\L{\LB{\K{begin}}}
\L{\LB{}\Tab{2}%
{\K{if}_(\V{i}\<=\N{0})_\K{then}_\V{i}_:=_\N{1};}}
\L{\LB{}\Tab{2}%
{\K{if}_(\V{i}\>=\N{0})_\K{then}_\V{i}_:=_\N{0};}}
\L{\LB{}\Tab{2}%
{\K{if}_(\V{i}\<\>\N{0})_\K{then}_\V{i}_:=_\N{0};}}
\L{\LB{\K{end.}}}
\end{lgrind}
\printindex
\end{document}
```

### L'extension <ctanpkg:lgrind> 

L'extension <ctanpkg:tinyc2l> est un convertisseur de code `C`, `C++` ou `Java` en
LaTeX. Il numérote les lignes, traduit `!=` en $\neq$, gère les commentaires, les
en-têtes de procédures, etc. Il supporte plusieurs fichiers d'entrée et gère
automatiquement les changements de section et la génération d'index.


### Des solutions plus anciennes 

Voici quelques autres solutions un peu plus datées :

- l'extension `c++2latex`, sous licence GPL, est capable de convertir des fichiers C, C++
  ou JAVA en LaTeX. Les lignes peuvent être numérotées. Une ancienne version est
  disponible sur le CTAN : <https://tug.ctan.org/support/C++2LaTeX-1_1pl1/>, et ses mises
  à jour sont [sur le site web de l'auteur](http://www.arnoldarts.de/cpp2latex/) ;

- `cvt2ltx`, disponible sur <ftp://axp3.sv.fh-mannheim.de/cvt2latex/cvt2ltx.zip> est une
  famille de convertisseurs code source vers LaTeX pour les langages C, C++, IDL et Perl ;
  :::{todo}
  Est-il intéressant de parler de `cvt2ltx` ? Je n'ai même pas réussi à le
  compiler.
  :::

- Le système <ctanpkg:tinyc2l> est un peu plus récent : les utilisateurs sont encore
  encouragés à écrire leurs propres pilotes pour les langages qu'il ne supporte pas
  encore, mais le "*tiny*" dans son nom indique à juste titre qu'il ne s'agit pas d'un
  système spécialement élaboré ;

- [C++2LaTeX](http://www.arnoldarts.de/cpp2latex/) est clairement orienté vers une
  utilisation avec `C` et `C++` ;

- Un système extrêmement simple est <ctanpkg:c2latex>, avec lequel vous écrivez votre
  source LaTeX dans les commentaires de votre programme `C` (un peu dans la logique du
  [literate programming](/5_fichiers/formats/web/literate_programming)). Le programme convertit
  ensuite votre programme en un fichier LaTeX prêt à être compilé. Le programme est censé
  être "auto-documenté".


:::{sources}
- [Code listings in LaTeX](faquk:FAQ-codelist)
- [Conférence 4 - MT2E Dunkerque](https://mt2e.univ-littoral.fr/Members/denis-bitouze/pub/latex/diapositives-cours-d)
:::
