% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition_call_linter.R
\name{condition_call_linter}
\alias{condition_call_linter}
\title{Recommend usage of \code{call. = FALSE} in conditions}
\usage{
condition_call_linter(display_call = FALSE)
}
\arguments{
\item{display_call}{Logical specifying expected behavior regarding \code{call.}
argument in conditions.
\itemize{
\item \code{NA} forces providing \verb{call. =} but ignores its value (this can be used in
cases where you expect a mix of \code{call. = FALSE} and \code{call. = TRUE})
\item \code{TRUE} lints \code{call. = FALSE}
\item \code{FALSE} forces \code{call. = FALSE} (lints \code{call. = TRUE} or missing \verb{call. =} value)
}}
}
\description{
This linter, with the default \code{display_call = FALSE}, enforces the
recommendation of the tidyverse design guide regarding displaying error
calls.
}
\examples{
# will produce lints
lint(
  text = "stop('test')",
  linters = condition_call_linter()
)

lint(
  text = "stop('test', call. = TRUE)",
  linters = condition_call_linter()
)

lint(
  text = "stop('test', call. = FALSE)",
  linters = condition_call_linter(display_call = TRUE)
)

lint(
  text = "stop('this is a', 'test', call. = FALSE)",
  linters = condition_call_linter(display_call = TRUE)
)

# okay
lint(
  text = "stop('test', call. = FALSE)",
  linters = condition_call_linter()
)

lint(
  text = "stop('this is a', 'test', call. = FALSE)",
  linters = condition_call_linter()
)

lint(
  text = "stop('test', call. = TRUE)",
  linters = condition_call_linter(display_call = TRUE)
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://design.tidyverse.org/err-call.html}>
}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=style_linters]{style}, \link[=tidy_design_linters]{tidy_design}
}
