# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_request(
    resource_group_name: str,
    test_base_account_name: str,
    package_name: str,
    subscription_id: str,
    *,
    os_update_type: Union[str, _models.OsUpdateType],
    filter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop(
        "api_version", _params.pop("api-version", "2022-04-01-preview")
    )  # type: Literal["2022-04-01-preview"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "testBaseAccountName": _SERIALIZER.url("test_base_account_name", test_base_account_name, "str"),
        "packageName": _SERIALIZER.url("package_name", package_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["osUpdateType"] = _SERIALIZER.query("os_update_type", os_update_type, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(
    resource_group_name: str,
    test_base_account_name: str,
    package_name: str,
    test_result_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop(
        "api_version", _params.pop("api-version", "2022-04-01-preview")
    )  # type: Literal["2022-04-01-preview"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "testBaseAccountName": _SERIALIZER.url("test_base_account_name", test_base_account_name, "str"),
        "packageName": _SERIALIZER.url("package_name", package_name, "str"),
        "testResultName": _SERIALIZER.url("test_result_name", test_result_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_download_url_request(
    resource_group_name: str,
    test_base_account_name: str,
    package_name: str,
    test_result_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop(
        "api_version", _params.pop("api-version", "2022-04-01-preview")
    )  # type: Literal["2022-04-01-preview"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}/getDownloadUrl",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "testBaseAccountName": _SERIALIZER.url("test_base_account_name", test_base_account_name, "str"),
        "packageName": _SERIALIZER.url("package_name", package_name, "str"),
        "testResultName": _SERIALIZER.url("test_result_name", test_result_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_video_download_url_request(
    resource_group_name: str,
    test_base_account_name: str,
    package_name: str,
    test_result_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop(
        "api_version", _params.pop("api-version", "2022-04-01-preview")
    )  # type: Literal["2022-04-01-preview"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}/getVideoDownloadUrl",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "testBaseAccountName": _SERIALIZER.url("test_base_account_name", test_base_account_name, "str"),
        "packageName": _SERIALIZER.url("package_name", package_name, "str"),
        "testResultName": _SERIALIZER.url("test_result_name", test_result_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_console_log_download_url_request(
    resource_group_name: str,
    test_base_account_name: str,
    package_name: str,
    test_result_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop(
        "api_version", _params.pop("api-version", "2022-04-01-preview")
    )  # type: Literal["2022-04-01-preview"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}/getConsoleLogDownloadUrl",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "testBaseAccountName": _SERIALIZER.url("test_base_account_name", test_base_account_name, "str"),
        "packageName": _SERIALIZER.url("package_name", package_name, "str"),
        "testResultName": _SERIALIZER.url("test_result_name", test_result_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class TestResultsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.testbase.TestBase`'s
        :attr:`test_results` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self,
        resource_group_name: str,
        test_base_account_name: str,
        package_name: str,
        os_update_type: Union[str, _models.OsUpdateType],
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.TestResultResource"]:
        """Lists all the Test Results with specified OS Update type for a Test Base Package. Can be
        filtered by osName, releaseName, flightingRing, buildVersion, buildRevision.

        :param resource_group_name: The name of the resource group that contains the resource.
         Required.
        :type resource_group_name: str
        :param test_base_account_name: The resource name of the Test Base Account. Required.
        :type test_base_account_name: str
        :param package_name: The resource name of the Test Base Package. Required.
        :type package_name: str
        :param os_update_type: The type of the OS Update. Known values are: "SecurityUpdate" and
         "FeatureUpdate". Required.
        :type os_update_type: str or ~azure.mgmt.testbase.models.OsUpdateType
        :param filter: Odata filter. Default value is None.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either TestResultResource or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.testbase.models.TestResultResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-04-01-preview"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.TestResultListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    resource_group_name=resource_group_name,
                    test_base_account_name=test_base_account_name,
                    package_name=package_name,
                    subscription_id=self._config.subscription_id,
                    os_update_type=os_update_type,
                    filter=filter,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("TestResultListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults"}  # type: ignore

    @distributed_trace
    def get(
        self,
        resource_group_name: str,
        test_base_account_name: str,
        package_name: str,
        test_result_name: str,
        **kwargs: Any
    ) -> _models.TestResultResource:
        """Get the Test Result by Id with specified OS Update type for a Test Base Package.

        :param resource_group_name: The name of the resource group that contains the resource.
         Required.
        :type resource_group_name: str
        :param test_base_account_name: The resource name of the Test Base Account. Required.
        :type test_base_account_name: str
        :param package_name: The resource name of the Test Base Package. Required.
        :type package_name: str
        :param test_result_name: The Test Result Name. It equals to TestResult-{TestResultId} string.
         Required.
        :type test_result_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TestResultResource or the result of cls(response)
        :rtype: ~azure.mgmt.testbase.models.TestResultResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-04-01-preview"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.TestResultResource]

        request = build_get_request(
            resource_group_name=resource_group_name,
            test_base_account_name=test_base_account_name,
            package_name=package_name,
            test_result_name=test_result_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("TestResultResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}"}  # type: ignore

    @distributed_trace
    def get_download_url(
        self,
        resource_group_name: str,
        test_base_account_name: str,
        package_name: str,
        test_result_name: str,
        **kwargs: Any
    ) -> _models.DownloadURLResponse:
        """Gets the download URL of the test result.

        :param resource_group_name: The name of the resource group that contains the resource.
         Required.
        :type resource_group_name: str
        :param test_base_account_name: The resource name of the Test Base Account. Required.
        :type test_base_account_name: str
        :param package_name: The resource name of the Test Base Package. Required.
        :type package_name: str
        :param test_result_name: The Test Result Name. It equals to TestResult-{TestResultId} string.
         Required.
        :type test_result_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DownloadURLResponse or the result of cls(response)
        :rtype: ~azure.mgmt.testbase.models.DownloadURLResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-04-01-preview"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DownloadURLResponse]

        request = build_get_download_url_request(
            resource_group_name=resource_group_name,
            test_base_account_name=test_base_account_name,
            package_name=package_name,
            test_result_name=test_result_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_download_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DownloadURLResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_download_url.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}/getDownloadUrl"}  # type: ignore

    @distributed_trace
    def get_video_download_url(
        self,
        resource_group_name: str,
        test_base_account_name: str,
        package_name: str,
        test_result_name: str,
        **kwargs: Any
    ) -> _models.DownloadURLResponse:
        """Gets the download URL of the test execution screen recording.

        :param resource_group_name: The name of the resource group that contains the resource.
         Required.
        :type resource_group_name: str
        :param test_base_account_name: The resource name of the Test Base Account. Required.
        :type test_base_account_name: str
        :param package_name: The resource name of the Test Base Package. Required.
        :type package_name: str
        :param test_result_name: The Test Result Name. It equals to TestResult-{TestResultId} string.
         Required.
        :type test_result_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DownloadURLResponse or the result of cls(response)
        :rtype: ~azure.mgmt.testbase.models.DownloadURLResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-04-01-preview"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DownloadURLResponse]

        request = build_get_video_download_url_request(
            resource_group_name=resource_group_name,
            test_base_account_name=test_base_account_name,
            package_name=package_name,
            test_result_name=test_result_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_video_download_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DownloadURLResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_video_download_url.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}/getVideoDownloadUrl"}  # type: ignore

    @overload
    def get_console_log_download_url(
        self,
        resource_group_name: str,
        test_base_account_name: str,
        package_name: str,
        test_result_name: str,
        parameters: _models.TestResultConsoleLogDownloadURLParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DownloadURLResponse:
        """Gets the download URL of the test execution console log file.

        :param resource_group_name: The name of the resource group that contains the resource.
         Required.
        :type resource_group_name: str
        :param test_base_account_name: The resource name of the Test Base Account. Required.
        :type test_base_account_name: str
        :param package_name: The resource name of the Test Base Package. Required.
        :type package_name: str
        :param test_result_name: The Test Result Name. It equals to TestResult-{TestResultId} string.
         Required.
        :type test_result_name: str
        :param parameters: Parameters supplied to the Test Result GetConsoleLogDownloadUrl operation.
         Required.
        :type parameters: ~azure.mgmt.testbase.models.TestResultConsoleLogDownloadURLParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DownloadURLResponse or the result of cls(response)
        :rtype: ~azure.mgmt.testbase.models.DownloadURLResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def get_console_log_download_url(
        self,
        resource_group_name: str,
        test_base_account_name: str,
        package_name: str,
        test_result_name: str,
        parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DownloadURLResponse:
        """Gets the download URL of the test execution console log file.

        :param resource_group_name: The name of the resource group that contains the resource.
         Required.
        :type resource_group_name: str
        :param test_base_account_name: The resource name of the Test Base Account. Required.
        :type test_base_account_name: str
        :param package_name: The resource name of the Test Base Package. Required.
        :type package_name: str
        :param test_result_name: The Test Result Name. It equals to TestResult-{TestResultId} string.
         Required.
        :type test_result_name: str
        :param parameters: Parameters supplied to the Test Result GetConsoleLogDownloadUrl operation.
         Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DownloadURLResponse or the result of cls(response)
        :rtype: ~azure.mgmt.testbase.models.DownloadURLResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def get_console_log_download_url(
        self,
        resource_group_name: str,
        test_base_account_name: str,
        package_name: str,
        test_result_name: str,
        parameters: Union[_models.TestResultConsoleLogDownloadURLParameters, IO],
        **kwargs: Any
    ) -> _models.DownloadURLResponse:
        """Gets the download URL of the test execution console log file.

        :param resource_group_name: The name of the resource group that contains the resource.
         Required.
        :type resource_group_name: str
        :param test_base_account_name: The resource name of the Test Base Account. Required.
        :type test_base_account_name: str
        :param package_name: The resource name of the Test Base Package. Required.
        :type package_name: str
        :param test_result_name: The Test Result Name. It equals to TestResult-{TestResultId} string.
         Required.
        :type test_result_name: str
        :param parameters: Parameters supplied to the Test Result GetConsoleLogDownloadUrl operation.
         Is either a model type or a IO type. Required.
        :type parameters: ~azure.mgmt.testbase.models.TestResultConsoleLogDownloadURLParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DownloadURLResponse or the result of cls(response)
        :rtype: ~azure.mgmt.testbase.models.DownloadURLResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-04-01-preview"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DownloadURLResponse]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TestResultConsoleLogDownloadURLParameters")

        request = build_get_console_log_download_url_request(
            resource_group_name=resource_group_name,
            test_base_account_name=test_base_account_name,
            package_name=package_name,
            test_result_name=test_result_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.get_console_log_download_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DownloadURLResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_console_log_download_url.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}/getConsoleLogDownloadUrl"}  # type: ignore
