# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventhub.aio import EventHubManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventHubManagementConsumerGroupsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventHubManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_consumer_groups_create_or_update(self, resource_group):
        response = await self.client.consumer_groups.create_or_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            consumer_group_name="str",
            parameters={
                "createdAt": "2020-02-20 00:00:00",
                "id": "str",
                "location": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "updatedAt": "2020-02-20 00:00:00",
                "userMetadata": "str",
            },
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_consumer_groups_delete(self, resource_group):
        response = await self.client.consumer_groups.delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            consumer_group_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_consumer_groups_get(self, resource_group):
        response = await self.client.consumer_groups.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            consumer_group_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_consumer_groups_list_by_event_hub(self, resource_group):
        response = self.client.consumer_groups.list_by_event_hub(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            api_version="2022-01-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
