#pragma once
/*
 *  $Id: serialize.h 28232 2025-07-16 10:46:35Z yeti-dn $
 *  Copyright (C) 2009-2025 David Nečas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_DESERIALIZE_H__
#define __GWY_DESERIALIZE_H__

#include <glib-object.h>
#include <gio/gio.h>
#include <libgwyddion/serializable.h>

G_BEGIN_DECLS

GObject*              gwy_deserialize_memory      (const guchar *buffer,
                                                   gsize size,
                                                   gsize *bytes_consumed,
                                                   GwyErrorList **error_list)     G_GNUC_MALLOC;
GwySerializableGroup* gwy_deserialize_group_memory(const guchar *buffer,
                                                   gsize size,
                                                   GwySerializeSizeType sizetype,
                                                   GwyErrorList **error_list)     G_GNUC_MALLOC;
GObject*              gwy_deserialize_construct   (GwySerializableGroup *group,
                                                   GwyErrorList **error_list)     G_GNUC_MALLOC;

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
