//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// RestorableDroppedSQLPoolsServer is a fake server for instances of the armsynapse.RestorableDroppedSQLPoolsClient type.
type RestorableDroppedSQLPoolsServer struct {
	// Get is the fake for method RestorableDroppedSQLPoolsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, restorableDroppedSQLPoolID string, options *armsynapse.RestorableDroppedSQLPoolsClientGetOptions) (resp azfake.Responder[armsynapse.RestorableDroppedSQLPoolsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByWorkspacePager is the fake for method RestorableDroppedSQLPoolsClient.NewListByWorkspacePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByWorkspacePager func(resourceGroupName string, workspaceName string, options *armsynapse.RestorableDroppedSQLPoolsClientListByWorkspaceOptions) (resp azfake.PagerResponder[armsynapse.RestorableDroppedSQLPoolsClientListByWorkspaceResponse])
}

// NewRestorableDroppedSQLPoolsServerTransport creates a new instance of RestorableDroppedSQLPoolsServerTransport with the provided implementation.
// The returned RestorableDroppedSQLPoolsServerTransport instance is connected to an instance of armsynapse.RestorableDroppedSQLPoolsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRestorableDroppedSQLPoolsServerTransport(srv *RestorableDroppedSQLPoolsServer) *RestorableDroppedSQLPoolsServerTransport {
	return &RestorableDroppedSQLPoolsServerTransport{
		srv:                     srv,
		newListByWorkspacePager: newTracker[azfake.PagerResponder[armsynapse.RestorableDroppedSQLPoolsClientListByWorkspaceResponse]](),
	}
}

// RestorableDroppedSQLPoolsServerTransport connects instances of armsynapse.RestorableDroppedSQLPoolsClient to instances of RestorableDroppedSQLPoolsServer.
// Don't use this type directly, use NewRestorableDroppedSQLPoolsServerTransport instead.
type RestorableDroppedSQLPoolsServerTransport struct {
	srv                     *RestorableDroppedSQLPoolsServer
	newListByWorkspacePager *tracker[azfake.PagerResponder[armsynapse.RestorableDroppedSQLPoolsClientListByWorkspaceResponse]]
}

// Do implements the policy.Transporter interface for RestorableDroppedSQLPoolsServerTransport.
func (r *RestorableDroppedSQLPoolsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RestorableDroppedSQLPoolsClient.Get":
		resp, err = r.dispatchGet(req)
	case "RestorableDroppedSQLPoolsClient.NewListByWorkspacePager":
		resp, err = r.dispatchNewListByWorkspacePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RestorableDroppedSQLPoolsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restorableDroppedSqlPools/(?P<restorableDroppedSqlPoolId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	restorableDroppedSQLPoolIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("restorableDroppedSqlPoolId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, restorableDroppedSQLPoolIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RestorableDroppedSQLPool, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RestorableDroppedSQLPoolsServerTransport) dispatchNewListByWorkspacePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByWorkspacePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByWorkspacePager not implemented")}
	}
	newListByWorkspacePager := r.newListByWorkspacePager.get(req)
	if newListByWorkspacePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restorableDroppedSqlPools`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByWorkspacePager(resourceGroupNameParam, workspaceNameParam, nil)
		newListByWorkspacePager = &resp
		r.newListByWorkspacePager.add(req, newListByWorkspacePager)
	}
	resp, err := server.PagerResponderNext(newListByWorkspacePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByWorkspacePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByWorkspacePager) {
		r.newListByWorkspacePager.remove(req)
	}
	return resp, nil
}
