//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlogz

import "time"

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// FilteringTag - The definition of a filtering tag. Filtering tags are used for capturing resources and include/exclude them
// from being monitored.
type FilteringTag struct {
	// Valid actions for a filtering tag. Exclusion takes priority over inclusion.
	Action *TagAction

	// The name (also known as the key) of the tag.
	Name *string

	// The value of the tag.
	Value *string
}

type IdentityProperties struct {
	Type *ManagedIdentityTypes

	// READ-ONLY; The identity ID.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// LogRules - Set of rules for sending logs for the Monitor resource.
type LogRules struct {
	// List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty,
	// all resources will be captured. If only Exclude action is specified, the
	// rules will apply to the list of all available resources. If Include actions are specified, the rules will only include
	// resources with the associated tags.
	FilteringTags []*FilteringTag

	// Flag specifying if AAD logs should be sent for the Monitor resource.
	SendAADLogs *bool

	// Flag specifying if activity logs from Azure resources should be sent for the Monitor resource.
	SendActivityLogs *bool

	// Flag specifying if subscription logs should be sent for the Monitor resource.
	SendSubscriptionLogs *bool
}

// MonitorProperties - Properties specific to the monitor resource.
type MonitorProperties struct {
	LogzOrganizationProperties *OrganizationProperties

	// Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will
	// go in Suspended state.
	MarketplaceSubscriptionStatus *MarketplaceSubscriptionStatus

	// Flag specifying if the resource monitoring is enabled or disabled.
	MonitoringStatus *MonitoringStatus
	PlanData         *PlanData
	UserInfo         *UserInfo

	// READ-ONLY
	LiftrResourceCategory *LiftrResourceCategories

	// READ-ONLY; The priority of the resource.
	LiftrResourcePreference *int32

	// READ-ONLY; Flag specifying if the resource provisioning state as tracked by ARM.
	ProvisioningState *ProvisioningState
}

type MonitorResource struct {
	// REQUIRED
	Location *string
	Identity *IdentityProperties

	// Properties specific to the monitor resource.
	Properties *MonitorProperties

	// Dictionary of
	Tags map[string]*string

	// READ-ONLY; ARM id of the monitor resource.
	ID *string

	// READ-ONLY; Name of the monitor resource.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; The type of the monitor resource.
	Type *string
}

// MonitorResourceListResponse - Response of a list operation.
type MonitorResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Results of a list operation.
	Value []*MonitorResource
}

// MonitorResourceUpdateParameters - The parameters for a PATCH request to a monitor resource.
type MonitorResourceUpdateParameters struct {
	// The set of properties that can be update in a PATCH request to a monitor resource.
	Properties *MonitorUpdateProperties

	// The new tags of the monitor resource.
	Tags map[string]*string
}

// MonitorUpdateProperties - The set of properties that can be update in a PATCH request to a monitor resource.
type MonitorUpdateProperties struct {
	// Flag specifying if the resource monitoring is enabled or disabled.
	MonitoringStatus *MonitoringStatus
}

// MonitoredResource - The properties of a resource currently being monitored by the Logz monitor resource.
type MonitoredResource struct {
	// The ARM id of the resource.
	ID *string

	// Reason for why the resource is sending logs (or why it is not sending).
	ReasonForLogsStatus *string

	// Reason for why the resource is sending metrics (or why it is not sending).
	ReasonForMetricsStatus *string

	// Flag indicating if resource is sending logs to Logz.
	SendingLogs *bool

	// Flag indicating if resource is sending metrics to Logz.
	SendingMetrics *bool

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData
}

// MonitoredResourceListResponse - Response of a list operation.
type MonitoredResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Results of a list operation.
	Value []*MonitoredResource
}

// MonitoringTagRules - Capture logs and metrics of Azure resources based on ARM tags.
type MonitoringTagRules struct {
	// Definition of the properties for a TagRules resource.
	Properties *MonitoringTagRulesProperties

	// READ-ONLY; The id of the rule set.
	ID *string

	// READ-ONLY; Name of the rule set.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; The type of the rule set.
	Type *string
}

// MonitoringTagRulesListResponse - Response of a list operation.
type MonitoringTagRulesListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Results of a list operation.
	Value []*MonitoringTagRules
}

// MonitoringTagRulesProperties - Definition of the properties for a TagRules resource.
type MonitoringTagRulesProperties struct {
	// Set of rules for sending logs for the Monitor resource.
	LogRules *LogRules

	// READ-ONLY; Flag specifying if the resource provisioning state as tracked by ARM.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation, e.g., 'Write monitors'.
	Description *string

	// Operation type, e.g., read, write, delete, etc.
	Operation *string

	// Service provider, i.e., Microsoft.Logz.
	Provider *string

	// Type on which the operation is performed, e.g., 'monitors'.
	Resource *string
}

// OperationListResult - Result of GET request to list the Microsoft.Logz operations.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of operations supported by the Microsoft.Logz provider.
	Value []*OperationResult
}

// OperationResult - A Microsoft.Logz REST API operation.
type OperationResult struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Operation name, i.e., {provider}/{resource}/{operation}.
	Name *string

	// Origin of the operation
	Origin *string
}

type OrganizationProperties struct {
	// Name of the Logz organization.
	CompanyName *string

	// The Id of the Enterprise App used for Single sign on.
	EnterpriseAppID *string

	// The login URL specific to this Logz Organization.
	SingleSignOnURL *string

	// READ-ONLY; Id of the Logz organization.
	ID *string
}

type PlanData struct {
	// different billing cycles like MONTHLY/WEEKLY. this could be enum
	BillingCycle *string

	// date when plan was applied
	EffectiveDate *time.Time

	// plan id as published by Logz
	PlanDetails *string

	// different usage type like PAYG/COMMITTED. this could be enum
	UsageType *string
}

type SingleSignOnProperties struct {
	// The Id of the Enterprise App used for Single sign-on.
	EnterpriseAppID *string

	// Various states of the SSO resource
	SingleSignOnState *SingleSignOnStates

	// The login URL specific to this Logz Organization.
	SingleSignOnURL *string

	// READ-ONLY; Flag specifying if the resource provisioning state as tracked by ARM.
	ProvisioningState *ProvisioningState
}

type SingleSignOnResource struct {
	Properties *SingleSignOnProperties

	// READ-ONLY; ARM id of the resource.
	ID *string

	// READ-ONLY; Name of the configuration.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// SingleSignOnResourceListResponse - Response of a list operation.
type SingleSignOnResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Results of a list operation.
	Value []*SingleSignOnResource
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

type UserInfo struct {
	// Email of the user used by Logz for contacting them if needed
	EmailAddress *string

	// First Name of the user
	FirstName *string

	// Last Name of the user
	LastName *string

	// Phone number of the user used by Logz for contacting them if needed
	PhoneNumber *string
}

// UserRoleListResponse - Response for list of user's role for Logz.io account.
type UserRoleListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// List of user roles for Logz.io account.
	Value []*UserRoleResponse
}

// UserRoleRequest - Request for checking user's role for Logz.io account.
type UserRoleRequest struct {
	// Email of the user used by Logz for contacting them if needed
	EmailAddress *string
}

// UserRoleResponse - Response for checking user's role for Logz.io account.
type UserRoleResponse struct {
	// User roles on configured in Logz.io account.
	Role *UserRole
}

// VMExtensionPayload - Response of payload to be passed while installing VM agent.
type VMExtensionPayload struct {
	// API Key corresponding to the resource.
	APIKey *string

	// Logz.io region where the resource has been created.
	Region *string
}

// VMHostUpdateRequest - Request of a list VM Host Update Operation.
type VMHostUpdateRequest struct {
	// Specifies the state of the operation - install/ delete.
	State *VMHostUpdateStates

	// Request of a list vm host update operation.
	VMResourceIDs []*VMResources
}

// VMResources - VM Resource Ids
type VMResources struct {
	// Version of the Logz agent installed on the VM.
	AgentVersion *string

	// Request of a list vm host update operation.
	ID *string
}

// VMResourcesListResponse - Response of a list VM Host Update Operation.
type VMResourcesListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Response of a list vm host update operation.
	Value []*VMResources
}
