//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dnsresolver/armdnsresolver"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// InboundEndpointsServer is a fake server for instances of the armdnsresolver.InboundEndpointsClient type.
type InboundEndpointsServer struct {
	// BeginCreateOrUpdate is the fake for method InboundEndpointsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, dnsResolverName string, inboundEndpointName string, parameters armdnsresolver.InboundEndpoint, options *armdnsresolver.InboundEndpointsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdnsresolver.InboundEndpointsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method InboundEndpointsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, dnsResolverName string, inboundEndpointName string, options *armdnsresolver.InboundEndpointsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdnsresolver.InboundEndpointsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method InboundEndpointsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, dnsResolverName string, inboundEndpointName string, options *armdnsresolver.InboundEndpointsClientGetOptions) (resp azfake.Responder[armdnsresolver.InboundEndpointsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method InboundEndpointsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, dnsResolverName string, options *armdnsresolver.InboundEndpointsClientListOptions) (resp azfake.PagerResponder[armdnsresolver.InboundEndpointsClientListResponse])

	// BeginUpdate is the fake for method InboundEndpointsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, dnsResolverName string, inboundEndpointName string, parameters armdnsresolver.InboundEndpointPatch, options *armdnsresolver.InboundEndpointsClientBeginUpdateOptions) (resp azfake.PollerResponder[armdnsresolver.InboundEndpointsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewInboundEndpointsServerTransport creates a new instance of InboundEndpointsServerTransport with the provided implementation.
// The returned InboundEndpointsServerTransport instance is connected to an instance of armdnsresolver.InboundEndpointsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewInboundEndpointsServerTransport(srv *InboundEndpointsServer) *InboundEndpointsServerTransport {
	return &InboundEndpointsServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armdnsresolver.InboundEndpointsClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armdnsresolver.InboundEndpointsClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armdnsresolver.InboundEndpointsClientListResponse]](),
		beginUpdate:         newTracker[azfake.PollerResponder[armdnsresolver.InboundEndpointsClientUpdateResponse]](),
	}
}

// InboundEndpointsServerTransport connects instances of armdnsresolver.InboundEndpointsClient to instances of InboundEndpointsServer.
// Don't use this type directly, use NewInboundEndpointsServerTransport instead.
type InboundEndpointsServerTransport struct {
	srv                 *InboundEndpointsServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armdnsresolver.InboundEndpointsClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armdnsresolver.InboundEndpointsClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armdnsresolver.InboundEndpointsClientListResponse]]
	beginUpdate         *tracker[azfake.PollerResponder[armdnsresolver.InboundEndpointsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for InboundEndpointsServerTransport.
func (i *InboundEndpointsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "InboundEndpointsClient.BeginCreateOrUpdate":
		resp, err = i.dispatchBeginCreateOrUpdate(req)
	case "InboundEndpointsClient.BeginDelete":
		resp, err = i.dispatchBeginDelete(req)
	case "InboundEndpointsClient.Get":
		resp, err = i.dispatchGet(req)
	case "InboundEndpointsClient.NewListPager":
		resp, err = i.dispatchNewListPager(req)
	case "InboundEndpointsClient.BeginUpdate":
		resp, err = i.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *InboundEndpointsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := i.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsResolvers/(?P<dnsResolverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inboundEndpoints/(?P<inboundEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdnsresolver.InboundEndpoint](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsResolverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsResolverName")])
		if err != nil {
			return nil, err
		}
		inboundEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inboundEndpointName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
		var options *armdnsresolver.InboundEndpointsClientBeginCreateOrUpdateOptions
		if ifMatchParam != nil || ifNoneMatchParam != nil {
			options = &armdnsresolver.InboundEndpointsClientBeginCreateOrUpdateOptions{
				IfMatch:     ifMatchParam,
				IfNoneMatch: ifNoneMatchParam,
			}
		}
		respr, errRespr := i.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, dnsResolverNameParam, inboundEndpointNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		i.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		i.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		i.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (i *InboundEndpointsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if i.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := i.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsResolvers/(?P<dnsResolverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inboundEndpoints/(?P<inboundEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsResolverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsResolverName")])
		if err != nil {
			return nil, err
		}
		inboundEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inboundEndpointName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armdnsresolver.InboundEndpointsClientBeginDeleteOptions
		if ifMatchParam != nil {
			options = &armdnsresolver.InboundEndpointsClientBeginDeleteOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := i.srv.BeginDelete(req.Context(), resourceGroupNameParam, dnsResolverNameParam, inboundEndpointNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		i.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		i.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		i.beginDelete.remove(req)
	}

	return resp, nil
}

func (i *InboundEndpointsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsResolvers/(?P<dnsResolverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inboundEndpoints/(?P<inboundEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dnsResolverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsResolverName")])
	if err != nil {
		return nil, err
	}
	inboundEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inboundEndpointName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, dnsResolverNameParam, inboundEndpointNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).InboundEndpoint, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *InboundEndpointsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := i.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsResolvers/(?P<dnsResolverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inboundEndpoints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsResolverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsResolverName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdnsresolver.InboundEndpointsClientListOptions
		if topParam != nil {
			options = &armdnsresolver.InboundEndpointsClientListOptions{
				Top: topParam,
			}
		}
		resp := i.srv.NewListPager(resourceGroupNameParam, dnsResolverNameParam, options)
		newListPager = &resp
		i.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdnsresolver.InboundEndpointsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		i.newListPager.remove(req)
	}
	return resp, nil
}

func (i *InboundEndpointsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if i.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := i.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsResolvers/(?P<dnsResolverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inboundEndpoints/(?P<inboundEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdnsresolver.InboundEndpointPatch](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsResolverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsResolverName")])
		if err != nil {
			return nil, err
		}
		inboundEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("inboundEndpointName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armdnsresolver.InboundEndpointsClientBeginUpdateOptions
		if ifMatchParam != nil {
			options = &armdnsresolver.InboundEndpointsClientBeginUpdateOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := i.srv.BeginUpdate(req.Context(), resourceGroupNameParam, dnsResolverNameParam, inboundEndpointNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		i.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		i.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		i.beginUpdate.remove(req)
	}

	return resp, nil
}
