//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dns/armdns"
	"net/http"
	"regexp"
)

// ResourceReferenceServer is a fake server for instances of the armdns.ResourceReferenceClient type.
type ResourceReferenceServer struct {
	// GetByTargetResources is the fake for method ResourceReferenceClient.GetByTargetResources
	// HTTP status codes to indicate success: http.StatusOK
	GetByTargetResources func(ctx context.Context, parameters armdns.ResourceReferenceRequest, options *armdns.ResourceReferenceClientGetByTargetResourcesOptions) (resp azfake.Responder[armdns.ResourceReferenceClientGetByTargetResourcesResponse], errResp azfake.ErrorResponder)
}

// NewResourceReferenceServerTransport creates a new instance of ResourceReferenceServerTransport with the provided implementation.
// The returned ResourceReferenceServerTransport instance is connected to an instance of armdns.ResourceReferenceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewResourceReferenceServerTransport(srv *ResourceReferenceServer) *ResourceReferenceServerTransport {
	return &ResourceReferenceServerTransport{srv: srv}
}

// ResourceReferenceServerTransport connects instances of armdns.ResourceReferenceClient to instances of ResourceReferenceServer.
// Don't use this type directly, use NewResourceReferenceServerTransport instead.
type ResourceReferenceServerTransport struct {
	srv *ResourceReferenceServer
}

// Do implements the policy.Transporter interface for ResourceReferenceServerTransport.
func (r *ResourceReferenceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ResourceReferenceClient.GetByTargetResources":
		resp, err = r.dispatchGetByTargetResources(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ResourceReferenceServerTransport) dispatchGetByTargetResources(req *http.Request) (*http.Response, error) {
	if r.srv.GetByTargetResources == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByTargetResources not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/getDnsResourceReference`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdns.ResourceReferenceRequest](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetByTargetResources(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourceReferenceResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
