//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdesktopvirtualization

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AgentUpdatePatchProperties.
func (a AgentUpdatePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maintenanceWindowTimeZone", a.MaintenanceWindowTimeZone)
	populate(objectMap, "maintenanceWindows", a.MaintenanceWindows)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "useSessionHostLocalTime", a.UseSessionHostLocalTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentUpdatePatchProperties.
func (a *AgentUpdatePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maintenanceWindowTimeZone":
			err = unpopulate(val, "MaintenanceWindowTimeZone", &a.MaintenanceWindowTimeZone)
			delete(rawMsg, key)
		case "maintenanceWindows":
			err = unpopulate(val, "MaintenanceWindows", &a.MaintenanceWindows)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "useSessionHostLocalTime":
			err = unpopulate(val, "UseSessionHostLocalTime", &a.UseSessionHostLocalTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentUpdateProperties.
func (a AgentUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maintenanceWindowTimeZone", a.MaintenanceWindowTimeZone)
	populate(objectMap, "maintenanceWindows", a.MaintenanceWindows)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "useSessionHostLocalTime", a.UseSessionHostLocalTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentUpdateProperties.
func (a *AgentUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maintenanceWindowTimeZone":
			err = unpopulate(val, "MaintenanceWindowTimeZone", &a.MaintenanceWindowTimeZone)
			delete(rawMsg, key)
		case "maintenanceWindows":
			err = unpopulate(val, "MaintenanceWindows", &a.MaintenanceWindows)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "useSessionHostLocalTime":
			err = unpopulate(val, "UseSessionHostLocalTime", &a.UseSessionHostLocalTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Application.
func (a *Application) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGroup.
func (a ApplicationGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "managedBy", a.ManagedBy)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "plan", a.Plan)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGroup.
func (a *ApplicationGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &a.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &a.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &a.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGroupList.
func (a ApplicationGroupList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGroupList.
func (a *ApplicationGroupList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGroupPatch.
func (a ApplicationGroupPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGroupPatch.
func (a *ApplicationGroupPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGroupPatchProperties.
func (a ApplicationGroupPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "showInFeed", a.ShowInFeed)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGroupPatchProperties.
func (a *ApplicationGroupPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "showInFeed":
			err = unpopulate(val, "ShowInFeed", &a.ShowInFeed)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGroupProperties.
func (a ApplicationGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationGroupType", a.ApplicationGroupType)
	populate(objectMap, "cloudPcResource", a.CloudPcResource)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "hostPoolArmPath", a.HostPoolArmPath)
	populate(objectMap, "objectId", a.ObjectID)
	populate(objectMap, "showInFeed", a.ShowInFeed)
	populate(objectMap, "workspaceArmPath", a.WorkspaceArmPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGroupProperties.
func (a *ApplicationGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationGroupType":
			err = unpopulate(val, "ApplicationGroupType", &a.ApplicationGroupType)
			delete(rawMsg, key)
		case "cloudPcResource":
			err = unpopulate(val, "CloudPcResource", &a.CloudPcResource)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "hostPoolArmPath":
			err = unpopulate(val, "HostPoolArmPath", &a.HostPoolArmPath)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &a.ObjectID)
			delete(rawMsg, key)
		case "showInFeed":
			err = unpopulate(val, "ShowInFeed", &a.ShowInFeed)
			delete(rawMsg, key)
		case "workspaceArmPath":
			err = unpopulate(val, "WorkspaceArmPath", &a.WorkspaceArmPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationList.
func (a ApplicationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationList.
func (a *ApplicationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationPatch.
func (a ApplicationPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationPatch.
func (a *ApplicationPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationPatchProperties.
func (a ApplicationPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationType", a.ApplicationType)
	populate(objectMap, "commandLineArguments", a.CommandLineArguments)
	populate(objectMap, "commandLineSetting", a.CommandLineSetting)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "filePath", a.FilePath)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "iconIndex", a.IconIndex)
	populate(objectMap, "iconPath", a.IconPath)
	populate(objectMap, "msixPackageApplicationId", a.MsixPackageApplicationID)
	populate(objectMap, "msixPackageFamilyName", a.MsixPackageFamilyName)
	populate(objectMap, "showInPortal", a.ShowInPortal)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationPatchProperties.
func (a *ApplicationPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationType":
			err = unpopulate(val, "ApplicationType", &a.ApplicationType)
			delete(rawMsg, key)
		case "commandLineArguments":
			err = unpopulate(val, "CommandLineArguments", &a.CommandLineArguments)
			delete(rawMsg, key)
		case "commandLineSetting":
			err = unpopulate(val, "CommandLineSetting", &a.CommandLineSetting)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "filePath":
			err = unpopulate(val, "FilePath", &a.FilePath)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "iconIndex":
			err = unpopulate(val, "IconIndex", &a.IconIndex)
			delete(rawMsg, key)
		case "iconPath":
			err = unpopulate(val, "IconPath", &a.IconPath)
			delete(rawMsg, key)
		case "msixPackageApplicationId":
			err = unpopulate(val, "MsixPackageApplicationID", &a.MsixPackageApplicationID)
			delete(rawMsg, key)
		case "msixPackageFamilyName":
			err = unpopulate(val, "MsixPackageFamilyName", &a.MsixPackageFamilyName)
			delete(rawMsg, key)
		case "showInPortal":
			err = unpopulate(val, "ShowInPortal", &a.ShowInPortal)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationProperties.
func (a ApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationType", a.ApplicationType)
	populate(objectMap, "commandLineArguments", a.CommandLineArguments)
	populate(objectMap, "commandLineSetting", a.CommandLineSetting)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "filePath", a.FilePath)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populateByteArray(objectMap, "iconContent", a.IconContent, runtime.Base64StdFormat)
	populate(objectMap, "iconHash", a.IconHash)
	populate(objectMap, "iconIndex", a.IconIndex)
	populate(objectMap, "iconPath", a.IconPath)
	populate(objectMap, "msixPackageApplicationId", a.MsixPackageApplicationID)
	populate(objectMap, "msixPackageFamilyName", a.MsixPackageFamilyName)
	populate(objectMap, "objectId", a.ObjectID)
	populate(objectMap, "showInPortal", a.ShowInPortal)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationProperties.
func (a *ApplicationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationType":
			err = unpopulate(val, "ApplicationType", &a.ApplicationType)
			delete(rawMsg, key)
		case "commandLineArguments":
			err = unpopulate(val, "CommandLineArguments", &a.CommandLineArguments)
			delete(rawMsg, key)
		case "commandLineSetting":
			err = unpopulate(val, "CommandLineSetting", &a.CommandLineSetting)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "filePath":
			err = unpopulate(val, "FilePath", &a.FilePath)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "iconContent":
			err = runtime.DecodeByteArray(string(val), &a.IconContent, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "iconHash":
			err = unpopulate(val, "IconHash", &a.IconHash)
			delete(rawMsg, key)
		case "iconIndex":
			err = unpopulate(val, "IconIndex", &a.IconIndex)
			delete(rawMsg, key)
		case "iconPath":
			err = unpopulate(val, "IconPath", &a.IconPath)
			delete(rawMsg, key)
		case "msixPackageApplicationId":
			err = unpopulate(val, "MsixPackageApplicationID", &a.MsixPackageApplicationID)
			delete(rawMsg, key)
		case "msixPackageFamilyName":
			err = unpopulate(val, "MsixPackageFamilyName", &a.MsixPackageFamilyName)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &a.ObjectID)
			delete(rawMsg, key)
		case "showInPortal":
			err = unpopulate(val, "ShowInPortal", &a.ShowInPortal)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Desktop.
func (d Desktop) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Desktop.
func (d *Desktop) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DesktopList.
func (d DesktopList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DesktopList.
func (d *DesktopList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DesktopPatch.
func (d DesktopPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DesktopPatch.
func (d *DesktopPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DesktopPatchProperties.
func (d DesktopPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "friendlyName", d.FriendlyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DesktopPatchProperties.
func (d *DesktopPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &d.FriendlyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DesktopProperties.
func (d DesktopProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "friendlyName", d.FriendlyName)
	populateByteArray(objectMap, "iconContent", d.IconContent, runtime.Base64StdFormat)
	populate(objectMap, "iconHash", d.IconHash)
	populate(objectMap, "objectId", d.ObjectID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DesktopProperties.
func (d *DesktopProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &d.FriendlyName)
			delete(rawMsg, key)
		case "iconContent":
			err = runtime.DecodeByteArray(string(val), &d.IconContent, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "iconHash":
			err = unpopulate(val, "IconHash", &d.IconHash)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &d.ObjectID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpandMsixImage.
func (e ExpandMsixImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpandMsixImage.
func (e *ExpandMsixImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpandMsixImageList.
func (e ExpandMsixImageList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpandMsixImageList.
func (e *ExpandMsixImageList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExpandMsixImageProperties.
func (e ExpandMsixImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", e.DisplayName)
	populate(objectMap, "imagePath", e.ImagePath)
	populate(objectMap, "isActive", e.IsActive)
	populate(objectMap, "isRegularRegistration", e.IsRegularRegistration)
	populateDateTimeRFC3339(objectMap, "lastUpdated", e.LastUpdated)
	populate(objectMap, "packageAlias", e.PackageAlias)
	populate(objectMap, "packageApplications", e.PackageApplications)
	populate(objectMap, "packageDependencies", e.PackageDependencies)
	populate(objectMap, "packageFamilyName", e.PackageFamilyName)
	populate(objectMap, "packageFullName", e.PackageFullName)
	populate(objectMap, "packageName", e.PackageName)
	populate(objectMap, "packageRelativePath", e.PackageRelativePath)
	populate(objectMap, "version", e.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExpandMsixImageProperties.
func (e *ExpandMsixImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &e.DisplayName)
			delete(rawMsg, key)
		case "imagePath":
			err = unpopulate(val, "ImagePath", &e.ImagePath)
			delete(rawMsg, key)
		case "isActive":
			err = unpopulate(val, "IsActive", &e.IsActive)
			delete(rawMsg, key)
		case "isRegularRegistration":
			err = unpopulate(val, "IsRegularRegistration", &e.IsRegularRegistration)
			delete(rawMsg, key)
		case "lastUpdated":
			err = unpopulateDateTimeRFC3339(val, "LastUpdated", &e.LastUpdated)
			delete(rawMsg, key)
		case "packageAlias":
			err = unpopulate(val, "PackageAlias", &e.PackageAlias)
			delete(rawMsg, key)
		case "packageApplications":
			err = unpopulate(val, "PackageApplications", &e.PackageApplications)
			delete(rawMsg, key)
		case "packageDependencies":
			err = unpopulate(val, "PackageDependencies", &e.PackageDependencies)
			delete(rawMsg, key)
		case "packageFamilyName":
			err = unpopulate(val, "PackageFamilyName", &e.PackageFamilyName)
			delete(rawMsg, key)
		case "packageFullName":
			err = unpopulate(val, "PackageFullName", &e.PackageFullName)
			delete(rawMsg, key)
		case "packageName":
			err = unpopulate(val, "PackageName", &e.PackageName)
			delete(rawMsg, key)
		case "packageRelativePath":
			err = unpopulate(val, "PackageRelativePath", &e.PackageRelativePath)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &e.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostPool.
func (h HostPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", h.Etag)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "identity", h.Identity)
	populate(objectMap, "kind", h.Kind)
	populate(objectMap, "location", h.Location)
	populate(objectMap, "managedBy", h.ManagedBy)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "plan", h.Plan)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "sku", h.SKU)
	populate(objectMap, "systemData", h.SystemData)
	populate(objectMap, "tags", h.Tags)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostPool.
func (h *HostPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &h.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &h.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &h.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &h.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &h.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &h.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &h.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &h.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostPoolList.
func (h HostPoolList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostPoolList.
func (h *HostPoolList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostPoolPatch.
func (h HostPoolPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "tags", h.Tags)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostPoolPatch.
func (h *HostPoolPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &h.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostPoolPatchProperties.
func (h HostPoolPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentUpdate", h.AgentUpdate)
	populate(objectMap, "customRdpProperty", h.CustomRdpProperty)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "friendlyName", h.FriendlyName)
	populate(objectMap, "loadBalancerType", h.LoadBalancerType)
	populate(objectMap, "maxSessionLimit", h.MaxSessionLimit)
	populate(objectMap, "personalDesktopAssignmentType", h.PersonalDesktopAssignmentType)
	populate(objectMap, "preferredAppGroupType", h.PreferredAppGroupType)
	populate(objectMap, "publicNetworkAccess", h.PublicNetworkAccess)
	populate(objectMap, "registrationInfo", h.RegistrationInfo)
	populate(objectMap, "ring", h.Ring)
	populate(objectMap, "ssoClientId", h.SsoClientID)
	populate(objectMap, "ssoClientSecretKeyVaultPath", h.SsoClientSecretKeyVaultPath)
	populate(objectMap, "ssoSecretType", h.SsoSecretType)
	populate(objectMap, "ssoadfsAuthority", h.SsoadfsAuthority)
	populate(objectMap, "startVMOnConnect", h.StartVMOnConnect)
	populate(objectMap, "vmTemplate", h.VMTemplate)
	populate(objectMap, "validationEnvironment", h.ValidationEnvironment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostPoolPatchProperties.
func (h *HostPoolPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentUpdate":
			err = unpopulate(val, "AgentUpdate", &h.AgentUpdate)
			delete(rawMsg, key)
		case "customRdpProperty":
			err = unpopulate(val, "CustomRdpProperty", &h.CustomRdpProperty)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &h.FriendlyName)
			delete(rawMsg, key)
		case "loadBalancerType":
			err = unpopulate(val, "LoadBalancerType", &h.LoadBalancerType)
			delete(rawMsg, key)
		case "maxSessionLimit":
			err = unpopulate(val, "MaxSessionLimit", &h.MaxSessionLimit)
			delete(rawMsg, key)
		case "personalDesktopAssignmentType":
			err = unpopulate(val, "PersonalDesktopAssignmentType", &h.PersonalDesktopAssignmentType)
			delete(rawMsg, key)
		case "preferredAppGroupType":
			err = unpopulate(val, "PreferredAppGroupType", &h.PreferredAppGroupType)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &h.PublicNetworkAccess)
			delete(rawMsg, key)
		case "registrationInfo":
			err = unpopulate(val, "RegistrationInfo", &h.RegistrationInfo)
			delete(rawMsg, key)
		case "ring":
			err = unpopulate(val, "Ring", &h.Ring)
			delete(rawMsg, key)
		case "ssoClientId":
			err = unpopulate(val, "SsoClientID", &h.SsoClientID)
			delete(rawMsg, key)
		case "ssoClientSecretKeyVaultPath":
			err = unpopulate(val, "SsoClientSecretKeyVaultPath", &h.SsoClientSecretKeyVaultPath)
			delete(rawMsg, key)
		case "ssoSecretType":
			err = unpopulate(val, "SsoSecretType", &h.SsoSecretType)
			delete(rawMsg, key)
		case "ssoadfsAuthority":
			err = unpopulate(val, "SsoadfsAuthority", &h.SsoadfsAuthority)
			delete(rawMsg, key)
		case "startVMOnConnect":
			err = unpopulate(val, "StartVMOnConnect", &h.StartVMOnConnect)
			delete(rawMsg, key)
		case "vmTemplate":
			err = unpopulate(val, "VMTemplate", &h.VMTemplate)
			delete(rawMsg, key)
		case "validationEnvironment":
			err = unpopulate(val, "ValidationEnvironment", &h.ValidationEnvironment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostPoolProperties.
func (h HostPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentUpdate", h.AgentUpdate)
	populate(objectMap, "applicationGroupReferences", h.ApplicationGroupReferences)
	populate(objectMap, "cloudPcResource", h.CloudPcResource)
	populate(objectMap, "customRdpProperty", h.CustomRdpProperty)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "friendlyName", h.FriendlyName)
	populate(objectMap, "hostPoolType", h.HostPoolType)
	populate(objectMap, "loadBalancerType", h.LoadBalancerType)
	populate(objectMap, "maxSessionLimit", h.MaxSessionLimit)
	populate(objectMap, "objectId", h.ObjectID)
	populate(objectMap, "personalDesktopAssignmentType", h.PersonalDesktopAssignmentType)
	populate(objectMap, "preferredAppGroupType", h.PreferredAppGroupType)
	populate(objectMap, "privateEndpointConnections", h.PrivateEndpointConnections)
	populate(objectMap, "publicNetworkAccess", h.PublicNetworkAccess)
	populate(objectMap, "registrationInfo", h.RegistrationInfo)
	populate(objectMap, "ring", h.Ring)
	populate(objectMap, "ssoClientId", h.SsoClientID)
	populate(objectMap, "ssoClientSecretKeyVaultPath", h.SsoClientSecretKeyVaultPath)
	populate(objectMap, "ssoSecretType", h.SsoSecretType)
	populate(objectMap, "ssoadfsAuthority", h.SsoadfsAuthority)
	populate(objectMap, "startVMOnConnect", h.StartVMOnConnect)
	populate(objectMap, "vmTemplate", h.VMTemplate)
	populate(objectMap, "validationEnvironment", h.ValidationEnvironment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostPoolProperties.
func (h *HostPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentUpdate":
			err = unpopulate(val, "AgentUpdate", &h.AgentUpdate)
			delete(rawMsg, key)
		case "applicationGroupReferences":
			err = unpopulate(val, "ApplicationGroupReferences", &h.ApplicationGroupReferences)
			delete(rawMsg, key)
		case "cloudPcResource":
			err = unpopulate(val, "CloudPcResource", &h.CloudPcResource)
			delete(rawMsg, key)
		case "customRdpProperty":
			err = unpopulate(val, "CustomRdpProperty", &h.CustomRdpProperty)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &h.FriendlyName)
			delete(rawMsg, key)
		case "hostPoolType":
			err = unpopulate(val, "HostPoolType", &h.HostPoolType)
			delete(rawMsg, key)
		case "loadBalancerType":
			err = unpopulate(val, "LoadBalancerType", &h.LoadBalancerType)
			delete(rawMsg, key)
		case "maxSessionLimit":
			err = unpopulate(val, "MaxSessionLimit", &h.MaxSessionLimit)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &h.ObjectID)
			delete(rawMsg, key)
		case "personalDesktopAssignmentType":
			err = unpopulate(val, "PersonalDesktopAssignmentType", &h.PersonalDesktopAssignmentType)
			delete(rawMsg, key)
		case "preferredAppGroupType":
			err = unpopulate(val, "PreferredAppGroupType", &h.PreferredAppGroupType)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &h.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &h.PublicNetworkAccess)
			delete(rawMsg, key)
		case "registrationInfo":
			err = unpopulate(val, "RegistrationInfo", &h.RegistrationInfo)
			delete(rawMsg, key)
		case "ring":
			err = unpopulate(val, "Ring", &h.Ring)
			delete(rawMsg, key)
		case "ssoClientId":
			err = unpopulate(val, "SsoClientID", &h.SsoClientID)
			delete(rawMsg, key)
		case "ssoClientSecretKeyVaultPath":
			err = unpopulate(val, "SsoClientSecretKeyVaultPath", &h.SsoClientSecretKeyVaultPath)
			delete(rawMsg, key)
		case "ssoSecretType":
			err = unpopulate(val, "SsoSecretType", &h.SsoSecretType)
			delete(rawMsg, key)
		case "ssoadfsAuthority":
			err = unpopulate(val, "SsoadfsAuthority", &h.SsoadfsAuthority)
			delete(rawMsg, key)
		case "startVMOnConnect":
			err = unpopulate(val, "StartVMOnConnect", &h.StartVMOnConnect)
			delete(rawMsg, key)
		case "vmTemplate":
			err = unpopulate(val, "VMTemplate", &h.VMTemplate)
			delete(rawMsg, key)
		case "validationEnvironment":
			err = unpopulate(val, "ValidationEnvironment", &h.ValidationEnvironment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSpecification.
func (l LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", l.BlobDuration)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSpecification.
func (l *LogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &l.BlobDuration)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSIXImageURI.
func (m MSIXImageURI) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "uri", m.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSIXImageURI.
func (m *MSIXImageURI) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "uri":
			err = unpopulate(val, "URI", &m.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSIXPackage.
func (m MSIXPackage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSIXPackage.
func (m *MSIXPackage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSIXPackageList.
func (m MSIXPackageList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSIXPackageList.
func (m *MSIXPackageList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSIXPackagePatch.
func (m MSIXPackagePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSIXPackagePatch.
func (m *MSIXPackagePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSIXPackagePatchProperties.
func (m MSIXPackagePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "isActive", m.IsActive)
	populate(objectMap, "isRegularRegistration", m.IsRegularRegistration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSIXPackagePatchProperties.
func (m *MSIXPackagePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "isActive":
			err = unpopulate(val, "IsActive", &m.IsActive)
			delete(rawMsg, key)
		case "isRegularRegistration":
			err = unpopulate(val, "IsRegularRegistration", &m.IsRegularRegistration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MSIXPackageProperties.
func (m MSIXPackageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "imagePath", m.ImagePath)
	populate(objectMap, "isActive", m.IsActive)
	populate(objectMap, "isRegularRegistration", m.IsRegularRegistration)
	populateDateTimeRFC3339(objectMap, "lastUpdated", m.LastUpdated)
	populate(objectMap, "packageApplications", m.PackageApplications)
	populate(objectMap, "packageDependencies", m.PackageDependencies)
	populate(objectMap, "packageFamilyName", m.PackageFamilyName)
	populate(objectMap, "packageName", m.PackageName)
	populate(objectMap, "packageRelativePath", m.PackageRelativePath)
	populate(objectMap, "version", m.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MSIXPackageProperties.
func (m *MSIXPackageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "imagePath":
			err = unpopulate(val, "ImagePath", &m.ImagePath)
			delete(rawMsg, key)
		case "isActive":
			err = unpopulate(val, "IsActive", &m.IsActive)
			delete(rawMsg, key)
		case "isRegularRegistration":
			err = unpopulate(val, "IsRegularRegistration", &m.IsRegularRegistration)
			delete(rawMsg, key)
		case "lastUpdated":
			err = unpopulateDateTimeRFC3339(val, "LastUpdated", &m.LastUpdated)
			delete(rawMsg, key)
		case "packageApplications":
			err = unpopulate(val, "PackageApplications", &m.PackageApplications)
			delete(rawMsg, key)
		case "packageDependencies":
			err = unpopulate(val, "PackageDependencies", &m.PackageDependencies)
			delete(rawMsg, key)
		case "packageFamilyName":
			err = unpopulate(val, "PackageFamilyName", &m.PackageFamilyName)
			delete(rawMsg, key)
		case "packageName":
			err = unpopulate(val, "PackageName", &m.PackageName)
			delete(rawMsg, key)
		case "packageRelativePath":
			err = unpopulate(val, "PackageRelativePath", &m.PackageRelativePath)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &m.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindowPatchProperties.
func (m MaintenanceWindowPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dayOfWeek", m.DayOfWeek)
	populate(objectMap, "hour", m.Hour)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceWindowPatchProperties.
func (m *MaintenanceWindowPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfWeek":
			err = unpopulate(val, "DayOfWeek", &m.DayOfWeek)
			delete(rawMsg, key)
		case "hour":
			err = unpopulate(val, "Hour", &m.Hour)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindowProperties.
func (m MaintenanceWindowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dayOfWeek", m.DayOfWeek)
	populate(objectMap, "hour", m.Hour)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceWindowProperties.
func (m *MaintenanceWindowProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfWeek":
			err = unpopulate(val, "DayOfWeek", &m.DayOfWeek)
			delete(rawMsg, key)
		case "hour":
			err = unpopulate(val, "Hour", &m.Hour)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MsixPackageApplications.
func (m MsixPackageApplications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", m.AppID)
	populate(objectMap, "appUserModelID", m.AppUserModelID)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "friendlyName", m.FriendlyName)
	populate(objectMap, "iconImageName", m.IconImageName)
	populateByteArray(objectMap, "rawIcon", m.RawIcon, runtime.Base64StdFormat)
	populateByteArray(objectMap, "rawPng", m.RawPNG, runtime.Base64StdFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MsixPackageApplications.
func (m *MsixPackageApplications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &m.AppID)
			delete(rawMsg, key)
		case "appUserModelID":
			err = unpopulate(val, "AppUserModelID", &m.AppUserModelID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &m.FriendlyName)
			delete(rawMsg, key)
		case "iconImageName":
			err = unpopulate(val, "IconImageName", &m.IconImageName)
			delete(rawMsg, key)
		case "rawIcon":
			err = runtime.DecodeByteArray(string(val), &m.RawIcon, runtime.Base64StdFormat)
			delete(rawMsg, key)
		case "rawPng":
			err = runtime.DecodeByteArray(string(val), &m.RawPNG, runtime.Base64StdFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MsixPackageDependencies.
func (m MsixPackageDependencies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependencyName", m.DependencyName)
	populate(objectMap, "minVersion", m.MinVersion)
	populate(objectMap, "publisher", m.Publisher)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MsixPackageDependencies.
func (m *MsixPackageDependencies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependencyName":
			err = unpopulate(val, "DependencyName", &m.DependencyName)
			delete(rawMsg, key)
		case "minVersion":
			err = unpopulate(val, "MinVersion", &m.MinVersion)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &m.Publisher)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationProperties.
func (o OperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", o.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationProperties.
func (o *OperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &o.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResultWithSystemData.
func (p PrivateEndpointConnectionListResultWithSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResultWithSystemData.
func (p *PrivateEndpointConnectionListResultWithSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionWithSystemData.
func (p PrivateEndpointConnectionWithSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionWithSystemData.
func (p *PrivateEndpointConnectionWithSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistrationInfo.
func (r RegistrationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expirationTime", r.ExpirationTime)
	populate(objectMap, "registrationTokenOperation", r.RegistrationTokenOperation)
	populate(objectMap, "token", r.Token)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistrationInfo.
func (r *RegistrationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &r.ExpirationTime)
			delete(rawMsg, key)
		case "registrationTokenOperation":
			err = unpopulate(val, "RegistrationTokenOperation", &r.RegistrationTokenOperation)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &r.Token)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistrationInfoPatch.
func (r RegistrationInfoPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expirationTime", r.ExpirationTime)
	populate(objectMap, "registrationTokenOperation", r.RegistrationTokenOperation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistrationInfoPatch.
func (r *RegistrationInfoPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &r.ExpirationTime)
			delete(rawMsg, key)
		case "registrationTokenOperation":
			err = unpopulate(val, "RegistrationTokenOperation", &r.RegistrationTokenOperation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceModelWithAllowedPropertySetIdentity.
func (r ResourceModelWithAllowedPropertySetIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "tenantId", r.TenantID)
	objectMap["type"] = "SystemAssigned"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceModelWithAllowedPropertySetIdentity.
func (r *ResourceModelWithAllowedPropertySetIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceModelWithAllowedPropertySetPlan.
func (r ResourceModelWithAllowedPropertySetPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "product", r.Product)
	populate(objectMap, "promotionCode", r.PromotionCode)
	populate(objectMap, "publisher", r.Publisher)
	populate(objectMap, "version", r.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceModelWithAllowedPropertySetPlan.
func (r *ResourceModelWithAllowedPropertySetPlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &r.Product)
			delete(rawMsg, key)
		case "promotionCode":
			err = unpopulate(val, "PromotionCode", &r.PromotionCode)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &r.Publisher)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &r.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceModelWithAllowedPropertySetSKU.
func (r ResourceModelWithAllowedPropertySetSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", r.Capacity)
	populate(objectMap, "family", r.Family)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "size", r.Size)
	populate(objectMap, "tier", r.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceModelWithAllowedPropertySetSKU.
func (r *ResourceModelWithAllowedPropertySetSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &r.Capacity)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &r.Family)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &r.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &r.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperation.
func (r ResourceProviderOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", r.Display)
	populate(objectMap, "isDataAction", r.IsDataAction)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperation.
func (r *ResourceProviderOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &r.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &r.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperationDisplay.
func (r ResourceProviderOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "operation", r.Operation)
	populate(objectMap, "provider", r.Provider)
	populate(objectMap, "resource", r.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperationDisplay.
func (r *ResourceProviderOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &r.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &r.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &r.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperationList.
func (r ResourceProviderOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperationList.
func (r *ResourceProviderOperationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingHostPoolReference.
func (s ScalingHostPoolReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostPoolArmPath", s.HostPoolArmPath)
	populate(objectMap, "scalingPlanEnabled", s.ScalingPlanEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingHostPoolReference.
func (s *ScalingHostPoolReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostPoolArmPath":
			err = unpopulate(val, "HostPoolArmPath", &s.HostPoolArmPath)
			delete(rawMsg, key)
		case "scalingPlanEnabled":
			err = unpopulate(val, "ScalingPlanEnabled", &s.ScalingPlanEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlan.
func (s ScalingPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "managedBy", s.ManagedBy)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "plan", s.Plan)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlan.
func (s *ScalingPlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &s.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &s.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanList.
func (s ScalingPlanList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanList.
func (s *ScalingPlanList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanPatch.
func (s ScalingPlanPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanPatch.
func (s *ScalingPlanPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanPatchProperties.
func (s ScalingPlanPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "exclusionTag", s.ExclusionTag)
	populate(objectMap, "friendlyName", s.FriendlyName)
	populate(objectMap, "hostPoolReferences", s.HostPoolReferences)
	populate(objectMap, "schedules", s.Schedules)
	populate(objectMap, "timeZone", s.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanPatchProperties.
func (s *ScalingPlanPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "exclusionTag":
			err = unpopulate(val, "ExclusionTag", &s.ExclusionTag)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		case "hostPoolReferences":
			err = unpopulate(val, "HostPoolReferences", &s.HostPoolReferences)
			delete(rawMsg, key)
		case "schedules":
			err = unpopulate(val, "Schedules", &s.Schedules)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &s.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanPersonalSchedule.
func (s ScalingPlanPersonalSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanPersonalSchedule.
func (s *ScalingPlanPersonalSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanPersonalScheduleList.
func (s ScalingPlanPersonalScheduleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanPersonalScheduleList.
func (s *ScalingPlanPersonalScheduleList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanPersonalSchedulePatch.
func (s ScalingPlanPersonalSchedulePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanPersonalSchedulePatch.
func (s *ScalingPlanPersonalSchedulePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanPersonalScheduleProperties.
func (s ScalingPlanPersonalScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "daysOfWeek", s.DaysOfWeek)
	populate(objectMap, "offPeakActionOnDisconnect", s.OffPeakActionOnDisconnect)
	populate(objectMap, "offPeakActionOnLogoff", s.OffPeakActionOnLogoff)
	populate(objectMap, "offPeakMinutesToWaitOnDisconnect", s.OffPeakMinutesToWaitOnDisconnect)
	populate(objectMap, "offPeakMinutesToWaitOnLogoff", s.OffPeakMinutesToWaitOnLogoff)
	populate(objectMap, "offPeakStartTime", s.OffPeakStartTime)
	populate(objectMap, "offPeakStartVMOnConnect", s.OffPeakStartVMOnConnect)
	populate(objectMap, "peakActionOnDisconnect", s.PeakActionOnDisconnect)
	populate(objectMap, "peakActionOnLogoff", s.PeakActionOnLogoff)
	populate(objectMap, "peakMinutesToWaitOnDisconnect", s.PeakMinutesToWaitOnDisconnect)
	populate(objectMap, "peakMinutesToWaitOnLogoff", s.PeakMinutesToWaitOnLogoff)
	populate(objectMap, "peakStartTime", s.PeakStartTime)
	populate(objectMap, "peakStartVMOnConnect", s.PeakStartVMOnConnect)
	populate(objectMap, "rampDownActionOnDisconnect", s.RampDownActionOnDisconnect)
	populate(objectMap, "rampDownActionOnLogoff", s.RampDownActionOnLogoff)
	populate(objectMap, "rampDownMinutesToWaitOnDisconnect", s.RampDownMinutesToWaitOnDisconnect)
	populate(objectMap, "rampDownMinutesToWaitOnLogoff", s.RampDownMinutesToWaitOnLogoff)
	populate(objectMap, "rampDownStartTime", s.RampDownStartTime)
	populate(objectMap, "rampDownStartVMOnConnect", s.RampDownStartVMOnConnect)
	populate(objectMap, "rampUpActionOnDisconnect", s.RampUpActionOnDisconnect)
	populate(objectMap, "rampUpActionOnLogoff", s.RampUpActionOnLogoff)
	populate(objectMap, "rampUpAutoStartHosts", s.RampUpAutoStartHosts)
	populate(objectMap, "rampUpMinutesToWaitOnDisconnect", s.RampUpMinutesToWaitOnDisconnect)
	populate(objectMap, "rampUpMinutesToWaitOnLogoff", s.RampUpMinutesToWaitOnLogoff)
	populate(objectMap, "rampUpStartTime", s.RampUpStartTime)
	populate(objectMap, "rampUpStartVMOnConnect", s.RampUpStartVMOnConnect)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanPersonalScheduleProperties.
func (s *ScalingPlanPersonalScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "daysOfWeek":
			err = unpopulate(val, "DaysOfWeek", &s.DaysOfWeek)
			delete(rawMsg, key)
		case "offPeakActionOnDisconnect":
			err = unpopulate(val, "OffPeakActionOnDisconnect", &s.OffPeakActionOnDisconnect)
			delete(rawMsg, key)
		case "offPeakActionOnLogoff":
			err = unpopulate(val, "OffPeakActionOnLogoff", &s.OffPeakActionOnLogoff)
			delete(rawMsg, key)
		case "offPeakMinutesToWaitOnDisconnect":
			err = unpopulate(val, "OffPeakMinutesToWaitOnDisconnect", &s.OffPeakMinutesToWaitOnDisconnect)
			delete(rawMsg, key)
		case "offPeakMinutesToWaitOnLogoff":
			err = unpopulate(val, "OffPeakMinutesToWaitOnLogoff", &s.OffPeakMinutesToWaitOnLogoff)
			delete(rawMsg, key)
		case "offPeakStartTime":
			err = unpopulate(val, "OffPeakStartTime", &s.OffPeakStartTime)
			delete(rawMsg, key)
		case "offPeakStartVMOnConnect":
			err = unpopulate(val, "OffPeakStartVMOnConnect", &s.OffPeakStartVMOnConnect)
			delete(rawMsg, key)
		case "peakActionOnDisconnect":
			err = unpopulate(val, "PeakActionOnDisconnect", &s.PeakActionOnDisconnect)
			delete(rawMsg, key)
		case "peakActionOnLogoff":
			err = unpopulate(val, "PeakActionOnLogoff", &s.PeakActionOnLogoff)
			delete(rawMsg, key)
		case "peakMinutesToWaitOnDisconnect":
			err = unpopulate(val, "PeakMinutesToWaitOnDisconnect", &s.PeakMinutesToWaitOnDisconnect)
			delete(rawMsg, key)
		case "peakMinutesToWaitOnLogoff":
			err = unpopulate(val, "PeakMinutesToWaitOnLogoff", &s.PeakMinutesToWaitOnLogoff)
			delete(rawMsg, key)
		case "peakStartTime":
			err = unpopulate(val, "PeakStartTime", &s.PeakStartTime)
			delete(rawMsg, key)
		case "peakStartVMOnConnect":
			err = unpopulate(val, "PeakStartVMOnConnect", &s.PeakStartVMOnConnect)
			delete(rawMsg, key)
		case "rampDownActionOnDisconnect":
			err = unpopulate(val, "RampDownActionOnDisconnect", &s.RampDownActionOnDisconnect)
			delete(rawMsg, key)
		case "rampDownActionOnLogoff":
			err = unpopulate(val, "RampDownActionOnLogoff", &s.RampDownActionOnLogoff)
			delete(rawMsg, key)
		case "rampDownMinutesToWaitOnDisconnect":
			err = unpopulate(val, "RampDownMinutesToWaitOnDisconnect", &s.RampDownMinutesToWaitOnDisconnect)
			delete(rawMsg, key)
		case "rampDownMinutesToWaitOnLogoff":
			err = unpopulate(val, "RampDownMinutesToWaitOnLogoff", &s.RampDownMinutesToWaitOnLogoff)
			delete(rawMsg, key)
		case "rampDownStartTime":
			err = unpopulate(val, "RampDownStartTime", &s.RampDownStartTime)
			delete(rawMsg, key)
		case "rampDownStartVMOnConnect":
			err = unpopulate(val, "RampDownStartVMOnConnect", &s.RampDownStartVMOnConnect)
			delete(rawMsg, key)
		case "rampUpActionOnDisconnect":
			err = unpopulate(val, "RampUpActionOnDisconnect", &s.RampUpActionOnDisconnect)
			delete(rawMsg, key)
		case "rampUpActionOnLogoff":
			err = unpopulate(val, "RampUpActionOnLogoff", &s.RampUpActionOnLogoff)
			delete(rawMsg, key)
		case "rampUpAutoStartHosts":
			err = unpopulate(val, "RampUpAutoStartHosts", &s.RampUpAutoStartHosts)
			delete(rawMsg, key)
		case "rampUpMinutesToWaitOnDisconnect":
			err = unpopulate(val, "RampUpMinutesToWaitOnDisconnect", &s.RampUpMinutesToWaitOnDisconnect)
			delete(rawMsg, key)
		case "rampUpMinutesToWaitOnLogoff":
			err = unpopulate(val, "RampUpMinutesToWaitOnLogoff", &s.RampUpMinutesToWaitOnLogoff)
			delete(rawMsg, key)
		case "rampUpStartTime":
			err = unpopulate(val, "RampUpStartTime", &s.RampUpStartTime)
			delete(rawMsg, key)
		case "rampUpStartVMOnConnect":
			err = unpopulate(val, "RampUpStartVMOnConnect", &s.RampUpStartVMOnConnect)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanPooledSchedule.
func (s ScalingPlanPooledSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanPooledSchedule.
func (s *ScalingPlanPooledSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanPooledScheduleList.
func (s ScalingPlanPooledScheduleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanPooledScheduleList.
func (s *ScalingPlanPooledScheduleList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanPooledSchedulePatch.
func (s ScalingPlanPooledSchedulePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanPooledSchedulePatch.
func (s *ScalingPlanPooledSchedulePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanPooledScheduleProperties.
func (s ScalingPlanPooledScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "daysOfWeek", s.DaysOfWeek)
	populate(objectMap, "offPeakLoadBalancingAlgorithm", s.OffPeakLoadBalancingAlgorithm)
	populate(objectMap, "offPeakStartTime", s.OffPeakStartTime)
	populate(objectMap, "peakLoadBalancingAlgorithm", s.PeakLoadBalancingAlgorithm)
	populate(objectMap, "peakStartTime", s.PeakStartTime)
	populate(objectMap, "rampDownCapacityThresholdPct", s.RampDownCapacityThresholdPct)
	populate(objectMap, "rampDownForceLogoffUsers", s.RampDownForceLogoffUsers)
	populate(objectMap, "rampDownLoadBalancingAlgorithm", s.RampDownLoadBalancingAlgorithm)
	populate(objectMap, "rampDownMinimumHostsPct", s.RampDownMinimumHostsPct)
	populate(objectMap, "rampDownNotificationMessage", s.RampDownNotificationMessage)
	populate(objectMap, "rampDownStartTime", s.RampDownStartTime)
	populate(objectMap, "rampDownStopHostsWhen", s.RampDownStopHostsWhen)
	populate(objectMap, "rampDownWaitTimeMinutes", s.RampDownWaitTimeMinutes)
	populate(objectMap, "rampUpCapacityThresholdPct", s.RampUpCapacityThresholdPct)
	populate(objectMap, "rampUpLoadBalancingAlgorithm", s.RampUpLoadBalancingAlgorithm)
	populate(objectMap, "rampUpMinimumHostsPct", s.RampUpMinimumHostsPct)
	populate(objectMap, "rampUpStartTime", s.RampUpStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanPooledScheduleProperties.
func (s *ScalingPlanPooledScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "daysOfWeek":
			err = unpopulate(val, "DaysOfWeek", &s.DaysOfWeek)
			delete(rawMsg, key)
		case "offPeakLoadBalancingAlgorithm":
			err = unpopulate(val, "OffPeakLoadBalancingAlgorithm", &s.OffPeakLoadBalancingAlgorithm)
			delete(rawMsg, key)
		case "offPeakStartTime":
			err = unpopulate(val, "OffPeakStartTime", &s.OffPeakStartTime)
			delete(rawMsg, key)
		case "peakLoadBalancingAlgorithm":
			err = unpopulate(val, "PeakLoadBalancingAlgorithm", &s.PeakLoadBalancingAlgorithm)
			delete(rawMsg, key)
		case "peakStartTime":
			err = unpopulate(val, "PeakStartTime", &s.PeakStartTime)
			delete(rawMsg, key)
		case "rampDownCapacityThresholdPct":
			err = unpopulate(val, "RampDownCapacityThresholdPct", &s.RampDownCapacityThresholdPct)
			delete(rawMsg, key)
		case "rampDownForceLogoffUsers":
			err = unpopulate(val, "RampDownForceLogoffUsers", &s.RampDownForceLogoffUsers)
			delete(rawMsg, key)
		case "rampDownLoadBalancingAlgorithm":
			err = unpopulate(val, "RampDownLoadBalancingAlgorithm", &s.RampDownLoadBalancingAlgorithm)
			delete(rawMsg, key)
		case "rampDownMinimumHostsPct":
			err = unpopulate(val, "RampDownMinimumHostsPct", &s.RampDownMinimumHostsPct)
			delete(rawMsg, key)
		case "rampDownNotificationMessage":
			err = unpopulate(val, "RampDownNotificationMessage", &s.RampDownNotificationMessage)
			delete(rawMsg, key)
		case "rampDownStartTime":
			err = unpopulate(val, "RampDownStartTime", &s.RampDownStartTime)
			delete(rawMsg, key)
		case "rampDownStopHostsWhen":
			err = unpopulate(val, "RampDownStopHostsWhen", &s.RampDownStopHostsWhen)
			delete(rawMsg, key)
		case "rampDownWaitTimeMinutes":
			err = unpopulate(val, "RampDownWaitTimeMinutes", &s.RampDownWaitTimeMinutes)
			delete(rawMsg, key)
		case "rampUpCapacityThresholdPct":
			err = unpopulate(val, "RampUpCapacityThresholdPct", &s.RampUpCapacityThresholdPct)
			delete(rawMsg, key)
		case "rampUpLoadBalancingAlgorithm":
			err = unpopulate(val, "RampUpLoadBalancingAlgorithm", &s.RampUpLoadBalancingAlgorithm)
			delete(rawMsg, key)
		case "rampUpMinimumHostsPct":
			err = unpopulate(val, "RampUpMinimumHostsPct", &s.RampUpMinimumHostsPct)
			delete(rawMsg, key)
		case "rampUpStartTime":
			err = unpopulate(val, "RampUpStartTime", &s.RampUpStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingPlanProperties.
func (s ScalingPlanProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "exclusionTag", s.ExclusionTag)
	populate(objectMap, "friendlyName", s.FriendlyName)
	populate(objectMap, "hostPoolReferences", s.HostPoolReferences)
	populate(objectMap, "hostPoolType", s.HostPoolType)
	populate(objectMap, "objectId", s.ObjectID)
	populate(objectMap, "schedules", s.Schedules)
	populate(objectMap, "timeZone", s.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingPlanProperties.
func (s *ScalingPlanProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "exclusionTag":
			err = unpopulate(val, "ExclusionTag", &s.ExclusionTag)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		case "hostPoolReferences":
			err = unpopulate(val, "HostPoolReferences", &s.HostPoolReferences)
			delete(rawMsg, key)
		case "hostPoolType":
			err = unpopulate(val, "HostPoolType", &s.HostPoolType)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &s.ObjectID)
			delete(rawMsg, key)
		case "schedules":
			err = unpopulate(val, "Schedules", &s.Schedules)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &s.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingSchedule.
func (s ScalingSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "daysOfWeek", s.DaysOfWeek)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "offPeakLoadBalancingAlgorithm", s.OffPeakLoadBalancingAlgorithm)
	populate(objectMap, "offPeakStartTime", s.OffPeakStartTime)
	populate(objectMap, "peakLoadBalancingAlgorithm", s.PeakLoadBalancingAlgorithm)
	populate(objectMap, "peakStartTime", s.PeakStartTime)
	populate(objectMap, "rampDownCapacityThresholdPct", s.RampDownCapacityThresholdPct)
	populate(objectMap, "rampDownForceLogoffUsers", s.RampDownForceLogoffUsers)
	populate(objectMap, "rampDownLoadBalancingAlgorithm", s.RampDownLoadBalancingAlgorithm)
	populate(objectMap, "rampDownMinimumHostsPct", s.RampDownMinimumHostsPct)
	populate(objectMap, "rampDownNotificationMessage", s.RampDownNotificationMessage)
	populate(objectMap, "rampDownStartTime", s.RampDownStartTime)
	populate(objectMap, "rampDownStopHostsWhen", s.RampDownStopHostsWhen)
	populate(objectMap, "rampDownWaitTimeMinutes", s.RampDownWaitTimeMinutes)
	populate(objectMap, "rampUpCapacityThresholdPct", s.RampUpCapacityThresholdPct)
	populate(objectMap, "rampUpLoadBalancingAlgorithm", s.RampUpLoadBalancingAlgorithm)
	populate(objectMap, "rampUpMinimumHostsPct", s.RampUpMinimumHostsPct)
	populate(objectMap, "rampUpStartTime", s.RampUpStartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingSchedule.
func (s *ScalingSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "daysOfWeek":
			err = unpopulate(val, "DaysOfWeek", &s.DaysOfWeek)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "offPeakLoadBalancingAlgorithm":
			err = unpopulate(val, "OffPeakLoadBalancingAlgorithm", &s.OffPeakLoadBalancingAlgorithm)
			delete(rawMsg, key)
		case "offPeakStartTime":
			err = unpopulate(val, "OffPeakStartTime", &s.OffPeakStartTime)
			delete(rawMsg, key)
		case "peakLoadBalancingAlgorithm":
			err = unpopulate(val, "PeakLoadBalancingAlgorithm", &s.PeakLoadBalancingAlgorithm)
			delete(rawMsg, key)
		case "peakStartTime":
			err = unpopulate(val, "PeakStartTime", &s.PeakStartTime)
			delete(rawMsg, key)
		case "rampDownCapacityThresholdPct":
			err = unpopulate(val, "RampDownCapacityThresholdPct", &s.RampDownCapacityThresholdPct)
			delete(rawMsg, key)
		case "rampDownForceLogoffUsers":
			err = unpopulate(val, "RampDownForceLogoffUsers", &s.RampDownForceLogoffUsers)
			delete(rawMsg, key)
		case "rampDownLoadBalancingAlgorithm":
			err = unpopulate(val, "RampDownLoadBalancingAlgorithm", &s.RampDownLoadBalancingAlgorithm)
			delete(rawMsg, key)
		case "rampDownMinimumHostsPct":
			err = unpopulate(val, "RampDownMinimumHostsPct", &s.RampDownMinimumHostsPct)
			delete(rawMsg, key)
		case "rampDownNotificationMessage":
			err = unpopulate(val, "RampDownNotificationMessage", &s.RampDownNotificationMessage)
			delete(rawMsg, key)
		case "rampDownStartTime":
			err = unpopulate(val, "RampDownStartTime", &s.RampDownStartTime)
			delete(rawMsg, key)
		case "rampDownStopHostsWhen":
			err = unpopulate(val, "RampDownStopHostsWhen", &s.RampDownStopHostsWhen)
			delete(rawMsg, key)
		case "rampDownWaitTimeMinutes":
			err = unpopulate(val, "RampDownWaitTimeMinutes", &s.RampDownWaitTimeMinutes)
			delete(rawMsg, key)
		case "rampUpCapacityThresholdPct":
			err = unpopulate(val, "RampUpCapacityThresholdPct", &s.RampUpCapacityThresholdPct)
			delete(rawMsg, key)
		case "rampUpLoadBalancingAlgorithm":
			err = unpopulate(val, "RampUpLoadBalancingAlgorithm", &s.RampUpLoadBalancingAlgorithm)
			delete(rawMsg, key)
		case "rampUpMinimumHostsPct":
			err = unpopulate(val, "RampUpMinimumHostsPct", &s.RampUpMinimumHostsPct)
			delete(rawMsg, key)
		case "rampUpStartTime":
			err = unpopulate(val, "RampUpStartTime", &s.RampUpStartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SendMessage.
func (s SendMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "messageBody", s.MessageBody)
	populate(objectMap, "messageTitle", s.MessageTitle)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SendMessage.
func (s *SendMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "messageBody":
			err = unpopulate(val, "MessageBody", &s.MessageBody)
			delete(rawMsg, key)
		case "messageTitle":
			err = unpopulate(val, "MessageTitle", &s.MessageTitle)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSpecification.
func (s ServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", s.LogSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSpecification.
func (s *ServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &s.LogSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SessionHost.
func (s SessionHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SessionHost.
func (s *SessionHost) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SessionHostHealthCheckFailureDetails.
func (s SessionHostHealthCheckFailureDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", s.ErrorCode)
	populateDateTimeRFC3339(objectMap, "lastHealthCheckDateTime", s.LastHealthCheckDateTime)
	populate(objectMap, "message", s.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SessionHostHealthCheckFailureDetails.
func (s *SessionHostHealthCheckFailureDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &s.ErrorCode)
			delete(rawMsg, key)
		case "lastHealthCheckDateTime":
			err = unpopulateDateTimeRFC3339(val, "LastHealthCheckDateTime", &s.LastHealthCheckDateTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SessionHostHealthCheckReport.
func (s SessionHostHealthCheckReport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalFailureDetails", s.AdditionalFailureDetails)
	populate(objectMap, "healthCheckName", s.HealthCheckName)
	populate(objectMap, "healthCheckResult", s.HealthCheckResult)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SessionHostHealthCheckReport.
func (s *SessionHostHealthCheckReport) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalFailureDetails":
			err = unpopulate(val, "AdditionalFailureDetails", &s.AdditionalFailureDetails)
			delete(rawMsg, key)
		case "healthCheckName":
			err = unpopulate(val, "HealthCheckName", &s.HealthCheckName)
			delete(rawMsg, key)
		case "healthCheckResult":
			err = unpopulate(val, "HealthCheckResult", &s.HealthCheckResult)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SessionHostList.
func (s SessionHostList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SessionHostList.
func (s *SessionHostList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SessionHostPatch.
func (s SessionHostPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SessionHostPatch.
func (s *SessionHostPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SessionHostPatchProperties.
func (s SessionHostPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowNewSession", s.AllowNewSession)
	populate(objectMap, "assignedUser", s.AssignedUser)
	populate(objectMap, "friendlyName", s.FriendlyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SessionHostPatchProperties.
func (s *SessionHostPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowNewSession":
			err = unpopulate(val, "AllowNewSession", &s.AllowNewSession)
			delete(rawMsg, key)
		case "assignedUser":
			err = unpopulate(val, "AssignedUser", &s.AssignedUser)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SessionHostProperties.
func (s SessionHostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentVersion", s.AgentVersion)
	populate(objectMap, "allowNewSession", s.AllowNewSession)
	populate(objectMap, "assignedUser", s.AssignedUser)
	populate(objectMap, "friendlyName", s.FriendlyName)
	populateDateTimeRFC3339(objectMap, "lastHeartBeat", s.LastHeartBeat)
	populateDateTimeRFC3339(objectMap, "lastUpdateTime", s.LastUpdateTime)
	populate(objectMap, "osVersion", s.OSVersion)
	populate(objectMap, "objectId", s.ObjectID)
	populate(objectMap, "resourceId", s.ResourceID)
	populate(objectMap, "sessionHostHealthCheckResults", s.SessionHostHealthCheckResults)
	populate(objectMap, "sessions", s.Sessions)
	populate(objectMap, "status", s.Status)
	populateDateTimeRFC3339(objectMap, "statusTimestamp", s.StatusTimestamp)
	populate(objectMap, "sxSStackVersion", s.SxSStackVersion)
	populate(objectMap, "updateErrorMessage", s.UpdateErrorMessage)
	populate(objectMap, "updateState", s.UpdateState)
	populate(objectMap, "virtualMachineId", s.VirtualMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SessionHostProperties.
func (s *SessionHostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &s.AgentVersion)
			delete(rawMsg, key)
		case "allowNewSession":
			err = unpopulate(val, "AllowNewSession", &s.AllowNewSession)
			delete(rawMsg, key)
		case "assignedUser":
			err = unpopulate(val, "AssignedUser", &s.AssignedUser)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		case "lastHeartBeat":
			err = unpopulateDateTimeRFC3339(val, "LastHeartBeat", &s.LastHeartBeat)
			delete(rawMsg, key)
		case "lastUpdateTime":
			err = unpopulateDateTimeRFC3339(val, "LastUpdateTime", &s.LastUpdateTime)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &s.OSVersion)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &s.ObjectID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &s.ResourceID)
			delete(rawMsg, key)
		case "sessionHostHealthCheckResults":
			err = unpopulate(val, "SessionHostHealthCheckResults", &s.SessionHostHealthCheckResults)
			delete(rawMsg, key)
		case "sessions":
			err = unpopulate(val, "Sessions", &s.Sessions)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "statusTimestamp":
			err = unpopulateDateTimeRFC3339(val, "StatusTimestamp", &s.StatusTimestamp)
			delete(rawMsg, key)
		case "sxSStackVersion":
			err = unpopulate(val, "SxSStackVersion", &s.SxSStackVersion)
			delete(rawMsg, key)
		case "updateErrorMessage":
			err = unpopulate(val, "UpdateErrorMessage", &s.UpdateErrorMessage)
			delete(rawMsg, key)
		case "updateState":
			err = unpopulate(val, "UpdateState", &s.UpdateState)
			delete(rawMsg, key)
		case "virtualMachineId":
			err = unpopulate(val, "VirtualMachineID", &s.VirtualMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StartMenuItem.
func (s StartMenuItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StartMenuItem.
func (s *StartMenuItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StartMenuItemList.
func (s StartMenuItemList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StartMenuItemList.
func (s *StartMenuItemList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StartMenuItemProperties.
func (s StartMenuItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appAlias", s.AppAlias)
	populate(objectMap, "commandLineArguments", s.CommandLineArguments)
	populate(objectMap, "filePath", s.FilePath)
	populate(objectMap, "iconIndex", s.IconIndex)
	populate(objectMap, "iconPath", s.IconPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StartMenuItemProperties.
func (s *StartMenuItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appAlias":
			err = unpopulate(val, "AppAlias", &s.AppAlias)
			delete(rawMsg, key)
		case "commandLineArguments":
			err = unpopulate(val, "CommandLineArguments", &s.CommandLineArguments)
			delete(rawMsg, key)
		case "filePath":
			err = unpopulate(val, "FilePath", &s.FilePath)
			delete(rawMsg, key)
		case "iconIndex":
			err = unpopulate(val, "IconIndex", &s.IconIndex)
			delete(rawMsg, key)
		case "iconPath":
			err = unpopulate(val, "IconPath", &s.IconPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Time.
func (t Time) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hour", t.Hour)
	populate(objectMap, "minute", t.Minute)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Time.
func (t *Time) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hour":
			err = unpopulate(val, "Hour", &t.Hour)
			delete(rawMsg, key)
		case "minute":
			err = unpopulate(val, "Minute", &t.Minute)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserSession.
func (u UserSession) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "systemData", u.SystemData)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserSession.
func (u *UserSession) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &u.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserSessionList.
func (u UserSessionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserSessionList.
func (u *UserSessionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserSessionProperties.
func (u UserSessionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeDirectoryUserName", u.ActiveDirectoryUserName)
	populate(objectMap, "applicationType", u.ApplicationType)
	populateDateTimeRFC3339(objectMap, "createTime", u.CreateTime)
	populate(objectMap, "objectId", u.ObjectID)
	populate(objectMap, "sessionState", u.SessionState)
	populate(objectMap, "userPrincipalName", u.UserPrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserSessionProperties.
func (u *UserSessionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeDirectoryUserName":
			err = unpopulate(val, "ActiveDirectoryUserName", &u.ActiveDirectoryUserName)
			delete(rawMsg, key)
		case "applicationType":
			err = unpopulate(val, "ApplicationType", &u.ApplicationType)
			delete(rawMsg, key)
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &u.CreateTime)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &u.ObjectID)
			delete(rawMsg, key)
		case "sessionState":
			err = unpopulate(val, "SessionState", &u.SessionState)
			delete(rawMsg, key)
		case "userPrincipalName":
			err = unpopulate(val, "UserPrincipalName", &u.UserPrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", w.Etag)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "kind", w.Kind)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "managedBy", w.ManagedBy)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "plan", w.Plan)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Workspace.
func (w *Workspace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &w.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &w.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &w.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, "ManagedBy", &w.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &w.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceList.
func (w WorkspaceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceList.
func (w *WorkspaceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspacePatch.
func (w WorkspacePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "tags", w.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspacePatch.
func (w *WorkspacePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspacePatchProperties.
func (w WorkspacePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationGroupReferences", w.ApplicationGroupReferences)
	populate(objectMap, "description", w.Description)
	populate(objectMap, "friendlyName", w.FriendlyName)
	populate(objectMap, "publicNetworkAccess", w.PublicNetworkAccess)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspacePatchProperties.
func (w *WorkspacePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationGroupReferences":
			err = unpopulate(val, "ApplicationGroupReferences", &w.ApplicationGroupReferences)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &w.FriendlyName)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &w.PublicNetworkAccess)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceProperties.
func (w WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationGroupReferences", w.ApplicationGroupReferences)
	populate(objectMap, "cloudPcResource", w.CloudPcResource)
	populate(objectMap, "description", w.Description)
	populate(objectMap, "friendlyName", w.FriendlyName)
	populate(objectMap, "objectId", w.ObjectID)
	populate(objectMap, "privateEndpointConnections", w.PrivateEndpointConnections)
	populate(objectMap, "publicNetworkAccess", w.PublicNetworkAccess)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceProperties.
func (w *WorkspaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationGroupReferences":
			err = unpopulate(val, "ApplicationGroupReferences", &w.ApplicationGroupReferences)
			delete(rawMsg, key)
		case "cloudPcResource":
			err = unpopulate(val, "CloudPcResource", &w.CloudPcResource)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &w.FriendlyName)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &w.ObjectID)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &w.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &w.PublicNetworkAccess)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray(m map[string]any, k string, b []byte, f runtime.Base64Encoding) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = runtime.EncodeByteArray(b, f)
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
