//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armapimanagement

import "time"

// APICollection - Paged API list representation.
type APICollection struct {
	// Total record count number across all pages.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*APIContract
}

// APIContactInformation - API contact information
type APIContactInformation struct {
	// The email address of the contact person/organization. MUST be in the format of an email address
	Email *string

	// The identifying name of the contact person/organization
	Name *string

	// The URL pointing to the contact information. MUST be in the format of a URL
	URL *string
}

// APIContract - API details.
type APIContract struct {
	// API entity contract properties.
	Properties *APIContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// APIContractProperties - API Entity Properties
type APIContractProperties struct {
	// REQUIRED; Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance.
	// It is appended to the API endpoint base URL specified during the service instance
	// creation to form a public URL for this API.
	Path *string

	// Describes the revision of the API. If no value is provided, default revision 1 is created
	APIRevision *string

	// Description of the API Revision.
	APIRevisionDescription *string

	// Type of API.
	APIType *APIType

	// Indicates the version identifier of the API if the API is versioned
	APIVersion *string

	// Description of the API Version.
	APIVersionDescription *string

	// Version set details
	APIVersionSet *APIVersionSetContractDetails

	// A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string

	// Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract

	// Contact information for the API.
	Contact *APIContactInformation

	// Description of the API. May include HTML formatting tags.
	Description *string

	// API name. Must be 1 to 300 characters long.
	DisplayName *string

	// Indicates if API revision is current api revision.
	IsCurrent *bool

	// License information for the API.
	License *APILicenseInformation

	// Describes on which protocols the operations in this API can be invoked.
	Protocols []*Protocol

	// Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
	ServiceURL *string

	// API identifier of the source API.
	SourceAPIID *string

	// Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract

	// Specifies whether an API or Product subscription is required for accessing the API.
	SubscriptionRequired *bool

	// A URL to the Terms of Service for the API. MUST be in the format of a URL.
	TermsOfServiceURL *string

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsOnline *bool
}

// APIContractUpdateProperties - API update contract properties.
type APIContractUpdateProperties struct {
	// Describes the revision of the API. If no value is provided, default revision 1 is created
	APIRevision *string

	// Description of the API Revision.
	APIRevisionDescription *string

	// Type of API.
	APIType *APIType

	// Indicates the version identifier of the API if the API is versioned
	APIVersion *string

	// Description of the API Version.
	APIVersionDescription *string

	// A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string

	// Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract

	// Contact information for the API.
	Contact *APIContactInformation

	// Description of the API. May include HTML formatting tags.
	Description *string

	// API name.
	DisplayName *string

	// Indicates if API revision is current api revision.
	IsCurrent *bool

	// License information for the API.
	License *APILicenseInformation

	// Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It
	// is appended to the API endpoint base URL specified during the service instance
	// creation to form a public URL for this API.
	Path *string

	// Describes on which protocols the operations in this API can be invoked.
	Protocols []*Protocol

	// Absolute URL of the backend service implementing this API.
	ServiceURL *string

	// Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract

	// Specifies whether an API or Product subscription is required for accessing the API.
	SubscriptionRequired *bool

	// A URL to the Terms of Service for the API. MUST be in the format of a URL.
	TermsOfServiceURL *string

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsOnline *bool
}

// APICreateOrUpdateParameter - API Create or Update Parameters.
type APICreateOrUpdateParameter struct {
	// API entity create of update properties.
	Properties *APICreateOrUpdateProperties
}

// APICreateOrUpdateProperties - API Create or Update Properties.
type APICreateOrUpdateProperties struct {
	// REQUIRED; Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance.
	// It is appended to the API endpoint base URL specified during the service instance
	// creation to form a public URL for this API.
	Path *string

	// Describes the revision of the API. If no value is provided, default revision 1 is created
	APIRevision *string

	// Description of the API Revision.
	APIRevisionDescription *string

	// Type of API.
	APIType *APIType

	// Indicates the version identifier of the API if the API is versioned
	APIVersion *string

	// Description of the API Version.
	APIVersionDescription *string

	// Version set details
	APIVersionSet *APIVersionSetContractDetails

	// A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string

	// Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract

	// Contact information for the API.
	Contact *APIContactInformation

	// Description of the API. May include HTML formatting tags.
	Description *string

	// API name. Must be 1 to 300 characters long.
	DisplayName *string

	// Format of the Content in which the API is getting imported.
	Format *ContentFormat

	// Indicates if API revision is current api revision.
	IsCurrent *bool

	// License information for the API.
	License *APILicenseInformation

	// Describes on which protocols the operations in this API can be invoked.
	Protocols []*Protocol

	// Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
	ServiceURL *string

	// Type of API to create.
	// * http creates a REST API
	// * soap creates a SOAP pass-through API
	// * websocket creates websocket API
	// * graphql creates GraphQL API.
	SoapAPIType *SoapAPIType

	// API identifier of the source API.
	SourceAPIID *string

	// Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract

	// Specifies whether an API or Product subscription is required for accessing the API.
	SubscriptionRequired *bool

	// A URL to the Terms of Service for the API. MUST be in the format of a URL.
	TermsOfServiceURL *string

	// Strategy of translating required query parameters to template ones. By default has value 'template'. Possible values: 'template',
	// 'query'
	TranslateRequiredQueryParametersConduct *TranslateRequiredQueryParametersConduct

	// Content value when Importing an API.
	Value *string

	// Criteria to limit import of WSDL to a subset of the document.
	WsdlSelector *APICreateOrUpdatePropertiesWsdlSelector

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsOnline *bool
}

// APICreateOrUpdatePropertiesWsdlSelector - Criteria to limit import of WSDL to a subset of the document.
type APICreateOrUpdatePropertiesWsdlSelector struct {
	// Name of endpoint(port) to import from WSDL
	WsdlEndpointName *string

	// Name of service to import from WSDL
	WsdlServiceName *string
}

// APIEntityBaseContract - API base contract details.
type APIEntityBaseContract struct {
	// Describes the revision of the API. If no value is provided, default revision 1 is created
	APIRevision *string

	// Description of the API Revision.
	APIRevisionDescription *string

	// Type of API.
	APIType *APIType

	// Indicates the version identifier of the API if the API is versioned
	APIVersion *string

	// Description of the API Version.
	APIVersionDescription *string

	// A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string

	// Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract

	// Contact information for the API.
	Contact *APIContactInformation

	// Description of the API. May include HTML formatting tags.
	Description *string

	// Indicates if API revision is current api revision.
	IsCurrent *bool

	// License information for the API.
	License *APILicenseInformation

	// Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract

	// Specifies whether an API or Product subscription is required for accessing the API.
	SubscriptionRequired *bool

	// A URL to the Terms of Service for the API. MUST be in the format of a URL.
	TermsOfServiceURL *string

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsOnline *bool
}

// APIExportResult - API Export result.
type APIExportResult struct {
	// Format in which the API Details are exported to the Storage Blob with Sas Key valid for 5 minutes.
	ExportResultFormat *ExportResultFormat

	// ResourceId of the API which was exported.
	ID *string

	// The object defining the schema of the exported API Detail
	Value *APIExportResultValue
}

// APIExportResultValue - The object defining the schema of the exported API Detail
type APIExportResultValue struct {
	// Link to the Storage Blob containing the result of the export operation. The Blob Uri is only valid for 5 minutes.
	Link *string
}

// APILicenseInformation - API license information
type APILicenseInformation struct {
	// The license name used for the API
	Name *string

	// A URL to the license used for the API. MUST be in the format of a URL
	URL *string
}

// APIReleaseCollection - Paged ApiRelease list representation.
type APIReleaseCollection struct {
	// Total record count number across all pages.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*APIReleaseContract
}

// APIReleaseContract - ApiRelease details.
type APIReleaseContract struct {
	// ApiRelease entity contract properties.
	Properties *APIReleaseContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// APIReleaseContractProperties - API Release details
type APIReleaseContractProperties struct {
	// Identifier of the API the release belongs to.
	APIID *string

	// Release Notes
	Notes *string

	// READ-ONLY; The time the API was released. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	CreatedDateTime *time.Time

	// READ-ONLY; The time the API release was updated.
	UpdatedDateTime *time.Time
}

// APIRevisionCollection - Paged API Revision list representation.
type APIRevisionCollection struct {
	// Total record count number across all pages.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*APIRevisionContract
}

// APIRevisionContract - Summary of revision metadata.
type APIRevisionContract struct {
	// READ-ONLY; Identifier of the API Revision.
	APIID *string

	// READ-ONLY; Revision number of API.
	APIRevision *string

	// READ-ONLY; The time the API Revision was created. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	CreatedDateTime *time.Time

	// READ-ONLY; Description of the API Revision.
	Description *string

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsCurrent *bool

	// READ-ONLY; Indicates if API revision is the current api revision.
	IsOnline *bool

	// READ-ONLY; Gateway URL for accessing the non-current API Revision.
	PrivateURL *string

	// READ-ONLY; The time the API Revision were updated. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	UpdatedDateTime *time.Time
}

// APIRevisionInfoContract - Object used to create an API Revision or Version based on an existing API Revision
type APIRevisionInfoContract struct {
	// Description of new API Revision.
	APIRevisionDescription *string

	// Version identifier for the new API Version.
	APIVersionName *string

	// Version set details
	APIVersionSet *APIVersionSetContractDetails

	// Resource identifier of API to be used to create the revision from.
	SourceAPIID *string
}

// APITagResourceContractProperties - API contract properties for the Tag Resources.
type APITagResourceContractProperties struct {
	// Describes the revision of the API. If no value is provided, default revision 1 is created
	APIRevision *string

	// Description of the API Revision.
	APIRevisionDescription *string

	// Type of API.
	APIType *APIType

	// Indicates the version identifier of the API if the API is versioned
	APIVersion *string

	// Description of the API Version.
	APIVersionDescription *string

	// A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string

	// Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract

	// Contact information for the API.
	Contact *APIContactInformation

	// Description of the API. May include HTML formatting tags.
	Description *string

	// API identifier in the form /apis/{apiId}.
	ID *string

	// Indicates if API revision is current api revision.
	IsCurrent *bool

	// License information for the API.
	License *APILicenseInformation

	// API name.
	Name *string

	// Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It
	// is appended to the API endpoint base URL specified during the service instance
	// creation to form a public URL for this API.
	Path *string

	// Describes on which protocols the operations in this API can be invoked.
	Protocols []*Protocol

	// Absolute URL of the backend service implementing this API.
	ServiceURL *string

	// Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract

	// Specifies whether an API or Product subscription is required for accessing the API.
	SubscriptionRequired *bool

	// A URL to the Terms of Service for the API. MUST be in the format of a URL.
	TermsOfServiceURL *string

	// READ-ONLY; Indicates if API revision is accessible via the gateway.
	IsOnline *bool
}

// APIUpdateContract - API update contract details.
type APIUpdateContract struct {
	// Properties of the API entity that can be updated.
	Properties *APIContractUpdateProperties
}

// APIVersionConstraint - Control Plane Apis version constraint for the API Management service.
type APIVersionConstraint struct {
	// Limit control plane API calls to API Management service with version equal to or newer than this value.
	MinAPIVersion *string
}

// APIVersionSetCollection - Paged API Version Set list representation.
type APIVersionSetCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*APIVersionSetContract
}

// APIVersionSetContract - API Version Set Contract details.
type APIVersionSetContract struct {
	// API VersionSet contract properties.
	Properties *APIVersionSetContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// APIVersionSetContractDetails - An API Version Set contains the common configuration for a set of API Versions relating
type APIVersionSetContractDetails struct {
	// Description of API Version Set.
	Description *string

	// Identifier for existing API Version Set. Omit this value to create a new Version Set.
	ID *string

	// The display Name of the API Version Set.
	Name *string

	// Name of HTTP header parameter that indicates the API Version if versioningScheme is set to header.
	VersionHeaderName *string

	// Name of query parameter that indicates the API Version if versioningScheme is set to query.
	VersionQueryName *string

	// An value that determines where the API Version identifier will be located in a HTTP request.
	VersioningScheme *APIVersionSetContractDetailsVersioningScheme
}

// APIVersionSetContractProperties - Properties of an API Version Set.
type APIVersionSetContractProperties struct {
	// REQUIRED; Name of API Version Set
	DisplayName *string

	// REQUIRED; An value that determines where the API Version identifier will be located in a HTTP request.
	VersioningScheme *VersioningScheme

	// Description of API Version Set.
	Description *string

	// Name of HTTP header parameter that indicates the API Version if versioningScheme is set to header.
	VersionHeaderName *string

	// Name of query parameter that indicates the API Version if versioningScheme is set to query.
	VersionQueryName *string
}

// APIVersionSetEntityBase - API Version set base parameters
type APIVersionSetEntityBase struct {
	// Description of API Version Set.
	Description *string

	// Name of HTTP header parameter that indicates the API Version if versioningScheme is set to header.
	VersionHeaderName *string

	// Name of query parameter that indicates the API Version if versioningScheme is set to query.
	VersionQueryName *string
}

// APIVersionSetUpdateParameters - Parameters to update or create an API Version Set Contract.
type APIVersionSetUpdateParameters struct {
	// Parameters to update or create an API Version Set Contract.
	Properties *APIVersionSetUpdateParametersProperties
}

// APIVersionSetUpdateParametersProperties - Properties used to create or update an API Version Set.
type APIVersionSetUpdateParametersProperties struct {
	// Description of API Version Set.
	Description *string

	// Name of API Version Set
	DisplayName *string

	// Name of HTTP header parameter that indicates the API Version if versioningScheme is set to header.
	VersionHeaderName *string

	// Name of query parameter that indicates the API Version if versioningScheme is set to query.
	VersionQueryName *string

	// An value that determines where the API Version identifier will be located in a HTTP request.
	VersioningScheme *VersioningScheme
}

// AccessInformationCollection - Paged AccessInformation list representation.
type AccessInformationCollection struct {
	// Total record count number across all pages.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*AccessInformationContract
}

// AccessInformationContract - Tenant Settings.
type AccessInformationContract struct {
	// AccessInformation entity contract properties.
	Properties *AccessInformationContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AccessInformationContractProperties - Tenant access information contract of the API Management service.
type AccessInformationContractProperties struct {
	// Determines whether direct access is enabled.
	Enabled *bool

	// Access Information type ('access' or 'gitAccess')
	ID *string

	// Principal (User) Identifier.
	PrincipalID *string
}

// AccessInformationCreateParameterProperties - Tenant access information update parameters of the API Management service
type AccessInformationCreateParameterProperties struct {
	// Determines whether direct access is enabled.
	Enabled *bool

	// Primary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
	PrimaryKey *string

	// Principal (User) Identifier.
	PrincipalID *string

	// Secondary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
	// value.
	SecondaryKey *string
}

// AccessInformationCreateParameters - Tenant access information update parameters.
type AccessInformationCreateParameters struct {
	// Tenant access information update parameter properties.
	Properties *AccessInformationCreateParameterProperties
}

// AccessInformationSecretsContract - Tenant access information contract of the API Management service.
type AccessInformationSecretsContract struct {
	// Determines whether direct access is enabled.
	Enabled *bool

	// Access Information type ('access' or 'gitAccess')
	ID *string

	// Primary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
	PrimaryKey *string

	// Principal (User) Identifier.
	PrincipalID *string

	// Secondary access key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
	// value.
	SecondaryKey *string
}

// AccessInformationUpdateParameterProperties - Tenant access information update parameters of the API Management service
type AccessInformationUpdateParameterProperties struct {
	// Determines whether direct access is enabled.
	Enabled *bool
}

// AccessInformationUpdateParameters - Tenant access information update parameters.
type AccessInformationUpdateParameters struct {
	// Tenant access information update parameter properties.
	Properties *AccessInformationUpdateParameterProperties
}

// AdditionalLocation - Description of an additional API Management resource location.
type AdditionalLocation struct {
	// REQUIRED; The location name of the additional region among Azure Data center regions.
	Location *string

	// REQUIRED; SKU properties of the API Management service.
	SKU *ServiceSKUProperties

	// Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway
	// in this additional location.
	DisableGateway *bool

	// Property can be used to enable NAT Gateway for this API Management service.
	NatGatewayState *NatGatewayState

	// Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the location. Supported
	// only for Premium SKU being deployed in Virtual Network.
	PublicIPAddressID *string

	// Virtual network configuration for the location.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string

	// READ-ONLY; Gateway URL of the API Management service in the Region.
	GatewayRegionalURL *string

	// READ-ONLY; Outbound public IPV4 address prefixes associated with NAT Gateway deployed service. Available only for Premium
	// SKU on stv2 platform.
	OutboundPublicIPAddresses []*string

	// READ-ONLY; Compute Platform Version running the service.
	PlatformVersion *PlatformVersion

	// READ-ONLY; Private Static Load Balanced IP addresses of the API Management service which is deployed in an Internal Virtual
	// Network in a particular additional location. Available only for Basic, Standard,
	// Premium and Isolated SKU.
	PrivateIPAddresses []*string

	// READ-ONLY; Public Static Load Balanced IP addresses of the API Management service in the additional location. Available
	// only for Basic, Standard, Premium and Isolated SKU.
	PublicIPAddresses []*string
}

// ApimResource - The Resource definition.
type ApimResource struct {
	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string
}

// ArmIDWrapper - A wrapper for an ARM resource id
type ArmIDWrapper struct {
	// READ-ONLY
	ID *string
}

// AssociationContract - Association entity details.
type AssociationContract struct {
	// Association entity contract properties.
	Properties *AssociationContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AssociationContractProperties - Association entity contract properties.
type AssociationContractProperties struct {
	// Provisioning state.
	ProvisioningState *string
}

// AuthenticationSettingsContract - API Authentication Settings.
type AuthenticationSettingsContract struct {
	// OAuth2 Authentication settings
	OAuth2 *OAuth2AuthenticationSettingsContract

	// Collection of OAuth2 authentication settings included into this API.
	OAuth2AuthenticationSettings []*OAuth2AuthenticationSettingsContract

	// OpenID Connect Authentication Settings
	Openid *OpenIDAuthenticationSettingsContract

	// Collection of Open ID Connect authentication settings included into this API.
	OpenidAuthenticationSettings []*OpenIDAuthenticationSettingsContract
}

// AuthorizationAccessPolicyCollection - Paged Authorization Access Policy list representation.
type AuthorizationAccessPolicyCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*AuthorizationAccessPolicyContract
}

// AuthorizationAccessPolicyContract - Authorization access policy contract.
type AuthorizationAccessPolicyContract struct {
	// Properties of the Authorization Contract.
	Properties *AuthorizationAccessPolicyContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AuthorizationAccessPolicyContractProperties - Authorization Access Policy details.
type AuthorizationAccessPolicyContractProperties struct {
	// The Object Id
	ObjectID *string

	// The Tenant Id
	TenantID *string
}

// AuthorizationCollection - Paged Authorization list representation.
type AuthorizationCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*AuthorizationContract
}

// AuthorizationConfirmConsentCodeRequestContract - Authorization confirm consent code request contract.
type AuthorizationConfirmConsentCodeRequestContract struct {
	// The consent code from the authorization server after authorizing and consenting.
	ConsentCode *string
}

// AuthorizationContract - Authorization contract.
type AuthorizationContract struct {
	// Properties of the Authorization Contract.
	Properties *AuthorizationContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AuthorizationContractProperties - Authorization details.
type AuthorizationContractProperties struct {
	// Authorization type options
	AuthorizationType *AuthorizationType

	// Authorization error details.
	Error *AuthorizationError

	// OAuth2 grant type options
	OAuth2GrantType *OAuth2GrantType

	// Authorization parameters
	Parameters map[string]*string

	// Status of the Authorization
	Status *string
}

// AuthorizationError - Authorization error details.
type AuthorizationError struct {
	// Error code
	Code *string

	// Error message
	Message *string
}

// AuthorizationLoginRequestContract - Authorization login request contract.
type AuthorizationLoginRequestContract struct {
	// The redirect URL after login has completed.
	PostLoginRedirectURL *string
}

// AuthorizationLoginResponseContract - Authorization login response contract.
type AuthorizationLoginResponseContract struct {
	// The login link
	LoginLink *string
}

// AuthorizationProviderCollection - Paged Authorization Provider list representation.
type AuthorizationProviderCollection struct {
	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*AuthorizationProviderContract
}

// AuthorizationProviderContract - Authorization Provider contract.
type AuthorizationProviderContract struct {
	// Properties of the Authorization Provider Contract.
	Properties *AuthorizationProviderContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AuthorizationProviderContractProperties - Authorization Provider details.
type AuthorizationProviderContractProperties struct {
	// Authorization Provider name. Must be 1 to 300 characters long.
	DisplayName *string

	// Identity provider name. Must be 1 to 300 characters long.
	IdentityProvider *string

	// OAuth2 settings
	Oauth2 *AuthorizationProviderOAuth2Settings
}

// AuthorizationProviderOAuth2GrantTypes - Authorization Provider oauth2 grant types settings
type AuthorizationProviderOAuth2GrantTypes struct {
	// OAuth2 authorization code grant parameters
	AuthorizationCode map[string]*string

	// OAuth2 client credential grant parameters
	ClientCredentials map[string]*string
}

// AuthorizationProviderOAuth2Settings - OAuth2 settings details
type AuthorizationProviderOAuth2Settings struct {
	// OAuth2 settings
	GrantTypes *AuthorizationProviderOAuth2GrantTypes

	// Redirect URL to be set in the OAuth application.
	RedirectURL *string
}

// AuthorizationServerCollection - Paged OAuth2 Authorization Servers list representation.
type AuthorizationServerCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*AuthorizationServerContract
}

// AuthorizationServerContract - External OAuth authorization server settings.
type AuthorizationServerContract struct {
	// Properties of the External OAuth authorization server Contract.
	Properties *AuthorizationServerContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AuthorizationServerContractBaseProperties - External OAuth authorization server Update settings contract.
type AuthorizationServerContractBaseProperties struct {
	// HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods []*AuthorizationMethod

	// Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods []*BearerTokenSendingMethod

	// Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or
	// Body. When Body is specified, client credentials and other parameters are passed
	// within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod []*ClientAuthenticationMethod

	// Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in
	// the form of a string containing space-delimited values.
	DefaultScope *string

	// Description of the authorization server. Can contain HTML formatting tags.
	Description *string

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner password.
	ResourceOwnerPassword *string

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner username.
	ResourceOwnerUsername *string

	// If true, authorization server will include state parameter from the authorization request to its response. Client may use
	// state parameter to raise protocol security.
	SupportState *bool

	// Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects
	// with name and value string properties, i.e. {"name" : "name value", "value":
	// "a value"}.
	TokenBodyParameters []*TokenBodyParameterContract

	// OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string
}

// AuthorizationServerContractProperties - External OAuth authorization server settings Properties.
type AuthorizationServerContractProperties struct {
	// REQUIRED; OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string

	// REQUIRED; Client or app id registered with this authorization server.
	ClientID *string

	// REQUIRED; Optional reference to a page where client or app registration for this authorization server is performed. Contains
	// absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string

	// REQUIRED; User-friendly authorization server name.
	DisplayName *string

	// REQUIRED; Form of an authorization grant, which the client uses to request the access token.
	GrantTypes []*GrantType

	// HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods []*AuthorizationMethod

	// Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods []*BearerTokenSendingMethod

	// Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or
	// Body. When Body is specified, client credentials and other parameters are passed
	// within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod []*ClientAuthenticationMethod

	// Client or app secret registered with this authorization server. This property will not be filled on 'GET' operations! Use
	// '/listSecrets' POST request to get the value.
	ClientSecret *string

	// Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in
	// the form of a string containing space-delimited values.
	DefaultScope *string

	// Description of the authorization server. Can contain HTML formatting tags.
	Description *string

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner password.
	ResourceOwnerPassword *string

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner username.
	ResourceOwnerUsername *string

	// If true, authorization server will include state parameter from the authorization request to its response. Client may use
	// state parameter to raise protocol security.
	SupportState *bool

	// Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects
	// with name and value string properties, i.e. {"name" : "name value", "value":
	// "a value"}.
	TokenBodyParameters []*TokenBodyParameterContract

	// OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string

	// If true, the authorization server will be used in the API documentation in the developer portal. False by default if no
	// value is provided.
	UseInAPIDocumentation *bool

	// If true, the authorization server may be used in the developer portal test console. True by default if no value is provided.
	UseInTestConsole *bool
}

// AuthorizationServerSecretsContract - OAuth Server Secrets Contract.
type AuthorizationServerSecretsContract struct {
	// oAuth Authorization Server Secrets.
	ClientSecret *string

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner password.
	ResourceOwnerPassword *string

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner username.
	ResourceOwnerUsername *string
}

// AuthorizationServerUpdateContract - External OAuth authorization server settings.
type AuthorizationServerUpdateContract struct {
	// Properties of the External OAuth authorization server update Contract.
	Properties *AuthorizationServerUpdateContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AuthorizationServerUpdateContractProperties - External OAuth authorization server Update settings contract.
type AuthorizationServerUpdateContractProperties struct {
	// OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string

	// HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods []*AuthorizationMethod

	// Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods []*BearerTokenSendingMethod

	// Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or
	// Body. When Body is specified, client credentials and other parameters are passed
	// within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod []*ClientAuthenticationMethod

	// Client or app id registered with this authorization server.
	ClientID *string

	// Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute
	// URL to entity being referenced.
	ClientRegistrationEndpoint *string

	// Client or app secret registered with this authorization server. This property will not be filled on 'GET' operations! Use
	// '/listSecrets' POST request to get the value.
	ClientSecret *string

	// Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in
	// the form of a string containing space-delimited values.
	DefaultScope *string

	// Description of the authorization server. Can contain HTML formatting tags.
	Description *string

	// User-friendly authorization server name.
	DisplayName *string

	// Form of an authorization grant, which the client uses to request the access token.
	GrantTypes []*GrantType

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner password.
	ResourceOwnerPassword *string

	// Can be optionally specified when resource owner password grant type is supported by this authorization server. Default
	// resource owner username.
	ResourceOwnerUsername *string

	// If true, authorization server will include state parameter from the authorization request to its response. Client may use
	// state parameter to raise protocol security.
	SupportState *bool

	// Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects
	// with name and value string properties, i.e. {"name" : "name value", "value":
	// "a value"}.
	TokenBodyParameters []*TokenBodyParameterContract

	// OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string

	// If true, the authorization server will be used in the API documentation in the developer portal. False by default if no
	// value is provided.
	UseInAPIDocumentation *bool

	// If true, the authorization server may be used in the developer portal test console. True by default if no value is provided.
	UseInTestConsole *bool
}

// BackendAuthorizationHeaderCredentials - Authorization header information.
type BackendAuthorizationHeaderCredentials struct {
	// REQUIRED; Authentication Parameter value.
	Parameter *string

	// REQUIRED; Authentication Scheme name.
	Scheme *string
}

// BackendBaseParameters - Backend entity base Parameter set.
type BackendBaseParameters struct {
	// Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract

	// Backend Description.
	Description *string

	// Backend Properties contract
	Properties *BackendProperties

	// Backend gateway Contract Properties
	Proxy *BackendProxyContract

	// Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function Apps or
	// API Apps.
	ResourceID *string

	// Backend TLS Properties
	TLS *BackendTLSProperties

	// Backend Title.
	Title *string
}

// BackendCollection - Paged Backend list representation.
type BackendCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Backend values.
	Value []*BackendContract
}

// BackendContract - Backend details.
type BackendContract struct {
	// Backend entity contract properties.
	Properties *BackendContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BackendContractProperties - Parameters supplied to the Create Backend operation.
type BackendContractProperties struct {
	// REQUIRED; Backend communication protocol.
	Protocol *BackendProtocol

	// REQUIRED; Runtime Url of the Backend.
	URL *string

	// Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract

	// Backend Description.
	Description *string

	// Backend Properties contract
	Properties *BackendProperties

	// Backend gateway Contract Properties
	Proxy *BackendProxyContract

	// Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function Apps or
	// API Apps.
	ResourceID *string

	// Backend TLS Properties
	TLS *BackendTLSProperties

	// Backend Title.
	Title *string
}

// BackendCredentialsContract - Details of the Credentials used to connect to Backend.
type BackendCredentialsContract struct {
	// Authorization header authentication
	Authorization *BackendAuthorizationHeaderCredentials

	// List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
	Certificate []*string

	// List of Client Certificate Ids.
	CertificateIDs []*string

	// Header Parameter description.
	Header map[string][]*string

	// Query Parameter description.
	Query map[string][]*string
}

// BackendProperties - Properties specific to the Backend Type.
type BackendProperties struct {
	// Backend Service Fabric Cluster Properties
	ServiceFabricCluster *BackendServiceFabricClusterProperties
}

// BackendProxyContract - Details of the Backend WebProxy Server to use in the Request to Backend.
type BackendProxyContract struct {
	// REQUIRED; WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all
	// fragments and query strings.
	URL *string

	// Password to connect to the WebProxy Server
	Password *string

	// Username to connect to the WebProxy server
	Username *string
}

// BackendReconnectContract - Reconnect request parameters.
type BackendReconnectContract struct {
	// Reconnect request properties.
	Properties *BackendReconnectProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BackendReconnectProperties - Properties to control reconnect requests.
type BackendReconnectProperties struct {
	// Duration in ISO8601 format after which reconnect will be initiated. Minimum duration of the Reconnect is PT2M.
	After *string
}

// BackendServiceFabricClusterProperties - Properties of the Service Fabric Type Backend.
type BackendServiceFabricClusterProperties struct {
	// REQUIRED; The cluster management endpoint.
	ManagementEndpoints []*string

	// The client certificate id for the management endpoint.
	ClientCertificateID *string

	// The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided
	ClientCertificatethumbprint *string

	// Maximum number of retries while attempting resolve the partition.
	MaxPartitionResolutionRetries *int32

	// Thumbprints of certificates cluster management service uses for tls communication
	ServerCertificateThumbprints []*string

	// Server X509 Certificate Names Collection
	ServerX509Names []*X509CertificateName
}

// BackendTLSProperties - Properties controlling TLS Certificate Validation.
type BackendTLSProperties struct {
	// Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend
	// host.
	ValidateCertificateChain *bool

	// Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend
	// host.
	ValidateCertificateName *bool
}

// BackendUpdateParameterProperties - Parameters supplied to the Update Backend operation.
type BackendUpdateParameterProperties struct {
	// Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract

	// Backend Description.
	Description *string

	// Backend Properties contract
	Properties *BackendProperties

	// Backend communication protocol.
	Protocol *BackendProtocol

	// Backend gateway Contract Properties
	Proxy *BackendProxyContract

	// Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function Apps or
	// API Apps.
	ResourceID *string

	// Backend TLS Properties
	TLS *BackendTLSProperties

	// Backend Title.
	Title *string

	// Runtime Url of the Backend.
	URL *string
}

// BackendUpdateParameters - Backend update parameters.
type BackendUpdateParameters struct {
	// Backend entity update contract properties.
	Properties *BackendUpdateParameterProperties
}

// BodyDiagnosticSettings - Body logging settings.
type BodyDiagnosticSettings struct {
	// Number of request body bytes to log.
	Bytes *int32
}

// CacheCollection - Paged Caches list representation.
type CacheCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*CacheContract
}

// CacheContract - Cache details.
type CacheContract struct {
	// Cache properties details.
	Properties *CacheContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CacheContractProperties - Properties of the Cache contract.
type CacheContractProperties struct {
	// REQUIRED; Runtime connection string to cache
	ConnectionString *string

	// REQUIRED; Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
	UseFromLocation *string

	// Cache description
	Description *string

	// Original uri of entity in external system cache points to
	ResourceID *string
}

// CacheUpdateParameters - Cache update details.
type CacheUpdateParameters struct {
	// Cache update properties details.
	Properties *CacheUpdateProperties
}

// CacheUpdateProperties - Parameters supplied to the Update Cache operation.
type CacheUpdateProperties struct {
	// Runtime connection string to cache
	ConnectionString *string

	// Cache description
	Description *string

	// Original uri of entity in external system cache points to
	ResourceID *string

	// Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
	UseFromLocation *string
}

// CertificateCollection - Paged Certificates list representation.
type CertificateCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*CertificateContract
}

// CertificateConfiguration - Certificate configuration which consist of non-trusted intermediates and root certificates.
type CertificateConfiguration struct {
	// REQUIRED; The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority
	// are valid locations.
	StoreName *CertificateConfigurationStoreName

	// Certificate information.
	Certificate *CertificateInformation

	// Certificate Password.
	CertificatePassword *string

	// Base64 Encoded certificate.
	EncodedCertificate *string
}

// CertificateContract - Certificate details.
type CertificateContract struct {
	// Certificate properties details.
	Properties *CertificateContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CertificateContractProperties - Properties of the Certificate contract.
type CertificateContractProperties struct {
	// REQUIRED; Expiration date of the certificate. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	ExpirationDate *time.Time

	// REQUIRED; Subject attribute of the certificate.
	Subject *string

	// REQUIRED; Thumbprint of the certificate.
	Thumbprint *string

	// KeyVault location details of the certificate.
	KeyVault *KeyVaultContractProperties
}

// CertificateCreateOrUpdateParameters - Certificate create or update details.
type CertificateCreateOrUpdateParameters struct {
	// Certificate create or update properties details.
	Properties *CertificateCreateOrUpdateProperties
}

// CertificateCreateOrUpdateProperties - Parameters supplied to the CreateOrUpdate certificate operation.
type CertificateCreateOrUpdateProperties struct {
	// Base 64 encoded certificate using the application/x-pkcs12 representation.
	Data *string

	// KeyVault location details of the certificate.
	KeyVault *KeyVaultContractCreateProperties

	// Password for the Certificate
	Password *string
}

// CertificateInformation - SSL certificate information.
type CertificateInformation struct {
	// REQUIRED; Expiration date of the certificate. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	Expiry *time.Time

	// REQUIRED; Subject of the certificate.
	Subject *string

	// REQUIRED; Thumbprint of the certificate.
	Thumbprint *string
}

// ClientSecretContract - Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
type ClientSecretContract struct {
	// Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
	ClientSecret *string
}

// ConnectivityCheckRequest - A request to perform the connectivity check operation on a API Management service.
type ConnectivityCheckRequest struct {
	// REQUIRED; The connectivity check operation destination.
	Destination *ConnectivityCheckRequestDestination

	// REQUIRED; Definitions about the connectivity check origin.
	Source *ConnectivityCheckRequestSource

	// The IP version to be used. Only IPv4 is supported for now.
	PreferredIPVersion *PreferredIPVersion

	// The request's protocol. Specific protocol configuration can be available based on this selection. The specified destination
	// address must be coherent with this value.
	Protocol *ConnectivityCheckProtocol

	// Protocol-specific configuration.
	ProtocolConfiguration *ConnectivityCheckRequestProtocolConfiguration
}

// ConnectivityCheckRequestDestination - The connectivity check operation destination.
type ConnectivityCheckRequestDestination struct {
	// REQUIRED; Destination address. Can either be an IP address or a FQDN.
	Address *string

	// REQUIRED; Destination port.
	Port *int64
}

// ConnectivityCheckRequestProtocolConfiguration - Protocol-specific configuration.
type ConnectivityCheckRequestProtocolConfiguration struct {
	// Configuration for HTTP or HTTPS requests.
	HTTPConfiguration *ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration
}

// ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration - Configuration for HTTP or HTTPS requests.
type ConnectivityCheckRequestProtocolConfigurationHTTPConfiguration struct {
	// List of headers to be included in the request.
	Headers []*HTTPHeader

	// The HTTP method to be used.
	Method *Method

	// List of HTTP status codes considered valid for the request response.
	ValidStatusCodes []*int64
}

// ConnectivityCheckRequestSource - Definitions about the connectivity check origin.
type ConnectivityCheckRequestSource struct {
	// REQUIRED; The API Management service region from where to start the connectivity check operation.
	Region *string

	// The particular VMSS instance from which to fire the request.
	Instance *int64
}

// ConnectivityCheckResponse - Information on the connectivity status.
type ConnectivityCheckResponse struct {
	// READ-ONLY; Average latency in milliseconds.
	AvgLatencyInMs *int64

	// READ-ONLY; The connection status.
	ConnectionStatus *ConnectionStatus

	// READ-ONLY; List of hops between the source and the destination.
	Hops []*ConnectivityHop

	// READ-ONLY; Maximum latency in milliseconds.
	MaxLatencyInMs *int64

	// READ-ONLY; Minimum latency in milliseconds.
	MinLatencyInMs *int64

	// READ-ONLY; Number of failed probes.
	ProbesFailed *int64

	// READ-ONLY; Total number of probes sent.
	ProbesSent *int64
}

// ConnectivityHop - Information about a hop between the source and the destination.
type ConnectivityHop struct {
	// READ-ONLY; The IP address of the hop.
	Address *string

	// READ-ONLY; The ID of the hop.
	ID *string

	// READ-ONLY; List of issues.
	Issues []*ConnectivityIssue

	// READ-ONLY; List of next hop identifiers.
	NextHopIDs []*string

	// READ-ONLY; The ID of the resource corresponding to this hop.
	ResourceID *string

	// READ-ONLY; The type of the hop.
	Type *string
}

// ConnectivityIssue - Information about an issue encountered in the process of checking for connectivity.
type ConnectivityIssue struct {
	// READ-ONLY; Provides additional context on the issue.
	Context []map[string]*string

	// READ-ONLY; The origin of the issue.
	Origin *Origin

	// READ-ONLY; The severity of the issue.
	Severity *Severity

	// READ-ONLY; The type of issue.
	Type *IssueType
}

// ConnectivityStatusContract - Details about connectivity to a resource.
type ConnectivityStatusContract struct {
	// REQUIRED; Whether this is optional.
	IsOptional *bool

	// REQUIRED; The date when the resource connectivity status last Changed from success to failure or vice-versa. The date conforms
	// to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
	// standard.
	LastStatusChange *time.Time

	// REQUIRED; The date when the resource connectivity status was last updated. This status should be updated every 15 minutes.
	// If this status has not been updated, then it means that the service has lost network
	// connectivity to the resource, from inside the Virtual Network.The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
	// as specified by the ISO 8601 standard.
	LastUpdated *time.Time

	// REQUIRED; The hostname of the resource which the service depends on. This can be the database, storage or any other azure
	// resource on which the service depends upon.
	Name *string

	// REQUIRED; Resource Type.
	ResourceType *string

	// REQUIRED; Resource Connectivity Status Type identifier.
	Status *ConnectivityStatusType

	// Error details of the connectivity to the resource.
	Error *string
}

// ContentItemCollection - Paged list of content items.
type ContentItemCollection struct {
	// READ-ONLY; Next page link, if any.
	NextLink *string

	// READ-ONLY; Collection of content items.
	Value []*ContentItemContract
}

// ContentItemContract - Content type contract details.
type ContentItemContract struct {
	// Properties of the content item.
	Properties map[string]any

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ContentTypeCollection - Paged list of content types.
type ContentTypeCollection struct {
	// READ-ONLY; Next page link, if any.
	NextLink *string

	// READ-ONLY; Collection of content types.
	Value []*ContentTypeContract
}

// ContentTypeContract - Content type contract details.
type ContentTypeContract struct {
	// Properties of the content type.
	Properties *ContentTypeContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type ContentTypeContractProperties struct {
	// Content type description.
	Description *string

	// Content type identifier
	ID *string

	// Content type name. Must be 1 to 250 characters long.
	Name *string

	// Content type schema.
	Schema any

	// Content type version.
	Version *string
}

type DataMasking struct {
	// Masking settings for headers
	Headers []*DataMaskingEntity

	// Masking settings for Url query parameters
	QueryParams []*DataMaskingEntity
}

type DataMaskingEntity struct {
	// Data masking mode.
	Mode *DataMaskingMode

	// The name of an entity to mask (e.g. a name of a header or a query parameter).
	Value *string
}

// DeletedServiceContract - Deleted API Management Service information.
type DeletedServiceContract struct {
	// Deleted API Management Service details.
	Properties *DeletedServiceContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; API Management Service Master Location.
	Location *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type DeletedServiceContractProperties struct {
	// UTC Timestamp when the service was soft-deleted. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	DeletionDate *time.Time

	// UTC Date and Time when the service will be automatically purged. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
	// as specified by the ISO 8601 standard.
	ScheduledPurgeDate *time.Time

	// Fully-qualified API Management Service Resource ID
	ServiceID *string
}

// DeletedServicesCollection - Paged deleted API Management Services List Representation.
type DeletedServicesCollection struct {
	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*DeletedServiceContract
}

// DeployConfigurationParameterProperties - Parameters supplied to the Deploy Configuration operation.
type DeployConfigurationParameterProperties struct {
	// REQUIRED; The name of the Git branch from which the configuration is to be deployed to the configuration database.
	Branch *string

	// The value enforcing deleting subscriptions to products that are deleted in this update.
	Force *bool
}

// DeployConfigurationParameters - Deploy Tenant Configuration Contract.
type DeployConfigurationParameters struct {
	// Deploy Configuration Parameter contract properties.
	Properties *DeployConfigurationParameterProperties
}

// DiagnosticCollection - Paged Diagnostic list representation.
type DiagnosticCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*DiagnosticContract
}

// DiagnosticContract - Diagnostic details.
type DiagnosticContract struct {
	// Diagnostic entity contract properties.
	Properties *DiagnosticContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DiagnosticContractProperties - Diagnostic Entity Properties
type DiagnosticContractProperties struct {
	// REQUIRED; Resource Id of a target logger.
	LoggerID *string

	// Specifies for what type of messages sampling settings should not apply.
	AlwaysLog *AlwaysLog

	// Diagnostic settings for incoming/outgoing HTTP messages to the Backend
	Backend *PipelineDiagnosticSettings

	// Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
	Frontend *PipelineDiagnosticSettings

	// Sets correlation protocol to use for Application Insights diagnostics.
	HTTPCorrelationProtocol *HTTPCorrelationProtocol

	// Log the ClientIP. Default is false.
	LogClientIP *bool

	// Emit custom metrics via emit-metric policy. Applicable only to Application Insights diagnostic settings.
	Metrics *bool

	// The format of the Operation Name for Application Insights telemetries. Default is Name.
	OperationNameFormat *OperationNameFormat

	// Sampling settings for Diagnostic.
	Sampling *SamplingSettings

	// The verbosity level applied to traces emitted by trace policies.
	Verbosity *Verbosity
}

// DocumentationCollection - Paged Documentation list representation.
type DocumentationCollection struct {
	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*DocumentationContract
}

// DocumentationContract - Markdown documentation details.
type DocumentationContract struct {
	// Markdown Documentation details.
	Properties *DocumentationContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DocumentationContractProperties - Markdown documentation details.
type DocumentationContractProperties struct {
	// Markdown documentation content.
	Content *string

	// documentation title.
	Title *string
}

// DocumentationUpdateContract - Documentation update contract details.
type DocumentationUpdateContract struct {
	// Markdown Documentation details.
	Properties *DocumentationContractProperties
}

// EmailTemplateCollection - Paged email template list representation.
type EmailTemplateCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*EmailTemplateContract
}

// EmailTemplateContract - Email Template details.
type EmailTemplateContract struct {
	// Email Template entity contract properties.
	Properties *EmailTemplateContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// EmailTemplateContractProperties - Email Template Contract properties.
type EmailTemplateContractProperties struct {
	// REQUIRED; Email Template Body. This should be a valid XDocument
	Body *string

	// REQUIRED; Subject of the Template.
	Subject *string

	// Description of the Email Template.
	Description *string

	// Email Template Parameter values.
	Parameters []*EmailTemplateParametersContractProperties

	// Title of the Template.
	Title *string

	// READ-ONLY; Whether the template is the default template provided by API Management or has been edited.
	IsDefault *bool
}

// EmailTemplateParametersContractProperties - Email Template Parameter contract.
type EmailTemplateParametersContractProperties struct {
	// Template parameter description.
	Description *string

	// Template parameter name.
	Name *string

	// Template parameter title.
	Title *string
}

// EmailTemplateUpdateParameterProperties - Email Template Update Contract properties.
type EmailTemplateUpdateParameterProperties struct {
	// Email Template Body. This should be a valid XDocument
	Body *string

	// Description of the Email Template.
	Description *string

	// Email Template Parameter values.
	Parameters []*EmailTemplateParametersContractProperties

	// Subject of the Template.
	Subject *string

	// Title of the Template.
	Title *string
}

// EmailTemplateUpdateParameters - Email Template update Parameters.
type EmailTemplateUpdateParameters struct {
	// Email Template Update contract properties.
	Properties *EmailTemplateUpdateParameterProperties
}

// EndpointDependency - A domain name that a service is reached at.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string

	// The Ports used when connecting to DomainName.
	EndpointDetails []*EndpointDetail
}

// EndpointDetail - Current TCP connectivity information from the Api Management Service to a single endpoint.
type EndpointDetail struct {
	// The port an endpoint is connected to.
	Port *int32

	// The region of the dependency.
	Region *string
}

// ErrorFieldContract - Error Field contract.
type ErrorFieldContract struct {
	// Property level error code.
	Code *string

	// Human-readable representation of property-level error.
	Message *string

	// Property name.
	Target *string
}

// ErrorResponse - Error Response.
type ErrorResponse struct {
	// Properties of the Error Response.
	Error *ErrorResponseBody
}

// ErrorResponseBody - Error Body contract.
type ErrorResponseBody struct {
	// Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string

	// The list of invalid fields send in request, in case of validation error.
	Details []*ErrorFieldContract

	// Human-readable representation of the error.
	Message *string
}

// GatewayCertificateAuthorityCollection - Paged Gateway certificate authority list representation.
type GatewayCertificateAuthorityCollection struct {
	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*GatewayCertificateAuthorityContract
}

// GatewayCertificateAuthorityContract - Gateway certificate authority details.
type GatewayCertificateAuthorityContract struct {
	// Gateway certificate authority details.
	Properties *GatewayCertificateAuthorityContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GatewayCertificateAuthorityContractProperties - Gateway certificate authority details.
type GatewayCertificateAuthorityContractProperties struct {
	// Determines whether certificate authority is trusted.
	IsTrusted *bool
}

// GatewayCollection - Paged Gateway list representation.
type GatewayCollection struct {
	// Total record count number across all pages.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*GatewayContract
}

// GatewayContract - Gateway details.
type GatewayContract struct {
	// Gateway details.
	Properties *GatewayContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GatewayContractProperties - Properties of the Gateway contract.
type GatewayContractProperties struct {
	// Gateway description
	Description *string

	// Gateway location.
	LocationData *ResourceLocationDataContract
}

// GatewayHostnameConfigurationCollection - Paged Gateway hostname configuration list representation.
type GatewayHostnameConfigurationCollection struct {
	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*GatewayHostnameConfigurationContract
}

// GatewayHostnameConfigurationContract - Gateway hostname configuration details.
type GatewayHostnameConfigurationContract struct {
	// Gateway hostname configuration details.
	Properties *GatewayHostnameConfigurationContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GatewayHostnameConfigurationContractProperties - Gateway hostname configuration details.
type GatewayHostnameConfigurationContractProperties struct {
	// Identifier of Certificate entity that will be used for TLS connection establishment
	CertificateID *string

	// Specifies if HTTP/2.0 is supported
	HTTP2Enabled *bool

	// Hostname value. Supports valid domain name, partial or full wildcard
	Hostname *string

	// Determines whether gateway requests client certificate
	NegotiateClientCertificate *bool

	// Specifies if TLS 1.0 is supported
	Tls10Enabled *bool

	// Specifies if TLS 1.1 is supported
	Tls11Enabled *bool
}

// GatewayKeyRegenerationRequestContract - Gateway key regeneration request contract properties.
type GatewayKeyRegenerationRequestContract struct {
	// REQUIRED; The Key being regenerated.
	KeyType *KeyType
}

// GatewayKeysContract - Gateway authentication keys.
type GatewayKeysContract struct {
	// Primary gateway key.
	Primary *string

	// Secondary gateway key.
	Secondary *string
}

// GatewayTokenContract - Gateway access token.
type GatewayTokenContract struct {
	// Shared Access Authentication token value for the Gateway.
	Value *string
}

// GatewayTokenRequestContract - Gateway token request contract properties.
type GatewayTokenRequestContract struct {
	// REQUIRED; The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following
	// format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	Expiry *time.Time

	// REQUIRED; The Key to be used to generate gateway token.
	KeyType *KeyType
}

// GenerateSsoURLResult - Generate SSO Url operations response details.
type GenerateSsoURLResult struct {
	// Redirect Url containing the SSO URL value.
	Value *string
}

// GlobalSchemaCollection - The response of the list schema operation.
type GlobalSchemaCollection struct {
	// Total record count number.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Global Schema Contract value.
	Value []*GlobalSchemaContract
}

// GlobalSchemaContract - Global Schema Contract details.
type GlobalSchemaContract struct {
	// Properties of the Global Schema.
	Properties *GlobalSchemaContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GlobalSchemaContractProperties - Schema create or update contract Properties.
type GlobalSchemaContractProperties struct {
	// REQUIRED; Schema Type. Immutable.
	SchemaType *SchemaType

	// Free-form schema entity description.
	Description *string

	// Global Schema document object for json-based schema formats(e.g. json schema).
	Document any

	// Json-encoded string for non json-based schema.
	Value any
}

// GroupCollection - Paged Group list representation.
type GroupCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*GroupContract
}

// GroupContract - Contract details.
type GroupContract struct {
	// Group entity contract properties.
	Properties *GroupContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GroupContractProperties - Group contract Properties.
type GroupContractProperties struct {
	// REQUIRED; Group name.
	DisplayName *string

	// Group description. Can contain HTML formatting tags.
	Description *string

	// For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active
	// Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise
	// the value is null.
	ExternalID *string

	// Group type.
	Type *GroupType

	// READ-ONLY; true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
	BuiltIn *bool
}

// GroupCreateParameters - Parameters supplied to the Create Group operation.
type GroupCreateParameters struct {
	// Properties supplied to Create Group operation.
	Properties *GroupCreateParametersProperties
}

// GroupCreateParametersProperties - Parameters supplied to the Create Group operation.
type GroupCreateParametersProperties struct {
	// REQUIRED; Group name.
	DisplayName *string

	// Group description.
	Description *string

	// Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g.
	// for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object
	// id>; otherwise the value is null.
	ExternalID *string

	// Group type.
	Type *GroupType
}

// GroupUpdateParameters - Parameters supplied to the Update Group operation.
type GroupUpdateParameters struct {
	// Group entity update contract properties.
	Properties *GroupUpdateParametersProperties
}

// GroupUpdateParametersProperties - Parameters supplied to the Update Group operation.
type GroupUpdateParametersProperties struct {
	// Group description.
	Description *string

	// Group name.
	DisplayName *string

	// Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g.
	// for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object
	// id>; otherwise the value is null.
	ExternalID *string

	// Group type.
	Type *GroupType
}

// HTTPHeader - HTTP header and it's value.
type HTTPHeader struct {
	// REQUIRED; Header name.
	Name *string

	// REQUIRED; Header value.
	Value *string
}

// HTTPMessageDiagnostic - Http message diagnostic settings.
type HTTPMessageDiagnostic struct {
	// Body logging settings.
	Body *BodyDiagnosticSettings

	// Data masking settings.
	DataMasking *DataMasking

	// Array of HTTP Headers to log.
	Headers []*string
}

// HostnameConfiguration - Custom hostname configuration.
type HostnameConfiguration struct {
	// REQUIRED; Hostname to configure on the Api Management service.
	HostName *string

	// REQUIRED; Hostname type.
	Type *HostnameType

	// Certificate information.
	Certificate *CertificateInformation

	// Certificate Password.
	CertificatePassword *string

	// Certificate Source.
	CertificateSource *CertificateSource

	// Certificate Status.
	CertificateStatus *CertificateStatus

	// Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not
	// send the SNI header, then this will be the certificate that will be challenged.
	// The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate.
	// The setting only applied to gateway Hostname Type.
	DefaultSSLBinding *bool

	// Base64 Encoded certificate.
	EncodedCertificate *string

	// System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault containing
	// the SSL certificate.
	IdentityClientID *string

	// Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update
	// of ssl certificate will not work. This requires Api Management service to be
	// configured with aka.ms/apimmsi. The secret should be of type application/x-pkcs12
	KeyVaultID *string

	// Specify true to always negotiate client certificate on the hostname. Default Value is false.
	NegotiateClientCertificate *bool
}

// IdentityProviderBaseParameters - Identity Provider Base Parameter Properties.
type IdentityProviderBaseParameters struct {
	// List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants []*string

	// OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
	Authority *string

	// The client library to be used in the developer portal. Only applies to AAD and AAD B2C Identity Provider.
	ClientLibrary *string

	// Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string

	// Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string

	// Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string

	// The TenantId to use instead of Common when logging into Active Directory
	SigninTenant *string

	// Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string

	// Identity Provider Type identifier.
	Type *IdentityProviderType
}

// IdentityProviderContract - Identity Provider details.
type IdentityProviderContract struct {
	// Identity Provider contract properties.
	Properties *IdentityProviderContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IdentityProviderContractProperties - The external Identity Providers like Facebook, Google, Microsoft, Twitter or Azure
// Active Directory which can be used to enable access to the API Management service developer portal for all users.
type IdentityProviderContractProperties struct {
	// REQUIRED; Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for
	// Google login, App ID for Microsoft.
	ClientID *string

	// List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants []*string

	// OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
	Authority *string

	// The client library to be used in the developer portal. Only applies to AAD and AAD B2C Identity Provider.
	ClientLibrary *string

	// Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is
	// App Secret for Facebook login, API Key for Google login, Public Key for
	// Microsoft. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
	ClientSecret *string

	// Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string

	// Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string

	// Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string

	// The TenantId to use instead of Common when logging into Active Directory
	SigninTenant *string

	// Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string

	// Identity Provider Type identifier.
	Type *IdentityProviderType
}

// IdentityProviderCreateContract - Identity Provider details.
type IdentityProviderCreateContract struct {
	// Identity Provider contract properties.
	Properties *IdentityProviderCreateContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IdentityProviderCreateContractProperties - The external Identity Providers like Facebook, Google, Microsoft, Twitter or
// Azure Active Directory which can be used to enable access to the API Management service developer portal for all users.
type IdentityProviderCreateContractProperties struct {
	// REQUIRED; Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for
	// Google login, App ID for Microsoft.
	ClientID *string

	// REQUIRED; Client secret of the Application in external Identity Provider, used to authenticate login request. For example,
	// it is App Secret for Facebook login, API Key for Google login, Public Key for
	// Microsoft. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the value.
	ClientSecret *string

	// List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants []*string

	// OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
	Authority *string

	// The client library to be used in the developer portal. Only applies to AAD and AAD B2C Identity Provider.
	ClientLibrary *string

	// Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string

	// Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string

	// Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string

	// The TenantId to use instead of Common when logging into Active Directory
	SigninTenant *string

	// Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string

	// Identity Provider Type identifier.
	Type *IdentityProviderType
}

// IdentityProviderList - List of all the Identity Providers configured on the service instance.
type IdentityProviderList struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Identity Provider configuration values.
	Value []*IdentityProviderContract
}

// IdentityProviderUpdateParameters - Parameters supplied to update Identity Provider
type IdentityProviderUpdateParameters struct {
	// Identity Provider update properties.
	Properties *IdentityProviderUpdateProperties
}

// IdentityProviderUpdateProperties - Parameters supplied to the Update Identity Provider operation.
type IdentityProviderUpdateProperties struct {
	// List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants []*string

	// OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
	Authority *string

	// Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login,
	// App ID for Microsoft.
	ClientID *string

	// The client library to be used in the developer portal. Only applies to AAD and AAD B2C Identity Provider.
	ClientLibrary *string

	// Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is
	// App Secret for Facebook login, API Key for Google login, Public Key for
	// Microsoft.
	ClientSecret *string

	// Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string

	// Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string

	// Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string

	// The TenantId to use instead of Common when logging into Active Directory
	SigninTenant *string

	// Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string

	// Identity Provider Type identifier.
	Type *IdentityProviderType
}

// IssueAttachmentCollection - Paged Issue Attachment list representation.
type IssueAttachmentCollection struct {
	// Total record count number across all pages.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Issue Attachment values.
	Value []*IssueAttachmentContract
}

// IssueAttachmentContract - Issue Attachment Contract details.
type IssueAttachmentContract struct {
	// Properties of the Issue Attachment.
	Properties *IssueAttachmentContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IssueAttachmentContractProperties - Issue Attachment contract Properties.
type IssueAttachmentContractProperties struct {
	// REQUIRED; An HTTP link or Base64-encoded binary data.
	Content *string

	// REQUIRED; Either 'link' if content is provided via an HTTP link or the MIME type of the Base64-encoded binary data provided
	// in the 'content' property.
	ContentFormat *string

	// REQUIRED; Filename by which the binary data will be saved.
	Title *string
}

// IssueCollection - Paged Issue list representation.
type IssueCollection struct {
	// Total record count number across all pages.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Issue values.
	Value []*IssueContract
}

// IssueCommentCollection - Paged Issue Comment list representation.
type IssueCommentCollection struct {
	// Total record count number across all pages.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Issue Comment values.
	Value []*IssueCommentContract
}

// IssueCommentContract - Issue Comment Contract details.
type IssueCommentContract struct {
	// Properties of the Issue Comment.
	Properties *IssueCommentContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IssueCommentContractProperties - Issue Comment contract Properties.
type IssueCommentContractProperties struct {
	// REQUIRED; Comment text.
	Text *string

	// REQUIRED; A resource identifier for the user who left the comment.
	UserID *string

	// Date and time when the comment was created.
	CreatedDate *time.Time
}

// IssueContract - Issue Contract details.
type IssueContract struct {
	// Properties of the Issue.
	Properties *IssueContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IssueContractBaseProperties - Issue contract Base Properties.
type IssueContractBaseProperties struct {
	// A resource identifier for the API the issue was created for.
	APIID *string

	// Date and time when the issue was created.
	CreatedDate *time.Time

	// Status of the issue.
	State *State
}

// IssueContractProperties - Issue contract Properties.
type IssueContractProperties struct {
	// REQUIRED; Text describing the issue.
	Description *string

	// REQUIRED; The issue title.
	Title *string

	// REQUIRED; A resource identifier for the user created the issue.
	UserID *string

	// A resource identifier for the API the issue was created for.
	APIID *string

	// Date and time when the issue was created.
	CreatedDate *time.Time

	// Status of the issue.
	State *State
}

// IssueUpdateContract - Issue update Parameters.
type IssueUpdateContract struct {
	// Issue entity Update contract properties.
	Properties *IssueUpdateContractProperties
}

// IssueUpdateContractProperties - Issue contract Update Properties.
type IssueUpdateContractProperties struct {
	// A resource identifier for the API the issue was created for.
	APIID *string

	// Date and time when the issue was created.
	CreatedDate *time.Time

	// Text describing the issue.
	Description *string

	// Status of the issue.
	State *State

	// The issue title.
	Title *string

	// A resource identifier for the user created the issue.
	UserID *string
}

// KeyVaultContractCreateProperties - Create keyVault contract details.
type KeyVaultContractCreateProperties struct {
	// Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault secret.
	IdentityClientID *string

	// Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires
	// API Management service to be configured with aka.ms/apimmsi
	SecretIdentifier *string
}

// KeyVaultContractProperties - KeyVault contract details.
type KeyVaultContractProperties struct {
	// Null for SystemAssignedIdentity or Client Id for UserAssignedIdentity , which will be used to access key vault secret.
	IdentityClientID *string

	// Last time sync and refresh status of secret from key vault.
	LastStatus *KeyVaultLastAccessStatusContractProperties

	// Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires
	// API Management service to be configured with aka.ms/apimmsi
	SecretIdentifier *string
}

// KeyVaultLastAccessStatusContractProperties - Issue contract Update Properties.
type KeyVaultLastAccessStatusContractProperties struct {
	// Last status code for sync and refresh of secret from key vault.
	Code *string

	// Details of the error else empty.
	Message *string

	// Last time secret was accessed. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO
	// 8601 standard.
	TimeStampUTC *time.Time
}

// LoggerCollection - Paged Logger list representation.
type LoggerCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Logger values.
	Value []*LoggerContract
}

// LoggerContract - Logger details.
type LoggerContract struct {
	// Logger entity contract properties.
	Properties *LoggerContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LoggerContractProperties - The Logger entity in API Management represents an event sink that you can use to log API Management
// events. Currently the Logger entity supports logging API Management events to Azure Event Hubs.
type LoggerContractProperties struct {
	// REQUIRED; Logger type.
	LoggerType *LoggerType

	// The name and SendRule connection string of the event hub for azureEventHub logger. Instrumentation key for applicationInsights
	// logger.
	Credentials map[string]*string

	// Logger description.
	Description *string

	// Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool

	// Azure Resource Id of a log target (either Azure Event Hub resource or Azure Application Insights resource).
	ResourceID *string
}

// LoggerUpdateContract - Logger update contract.
type LoggerUpdateContract struct {
	// Logger entity update contract properties.
	Properties *LoggerUpdateParameters
}

// LoggerUpdateParameters - Parameters supplied to the Update Logger operation.
type LoggerUpdateParameters struct {
	// Logger credentials.
	Credentials map[string]*string

	// Logger description.
	Description *string

	// Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool

	// Logger type.
	LoggerType *LoggerType
}

// NamedValueCollection - Paged NamedValue list representation.
type NamedValueCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*NamedValueContract
}

// NamedValueContract - NamedValue details.
type NamedValueContract struct {
	// NamedValue entity contract properties.
	Properties *NamedValueContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NamedValueContractProperties - NamedValue Contract properties.
type NamedValueContractProperties struct {
	// REQUIRED; Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
	DisplayName *string

	// KeyVault location details of the namedValue.
	KeyVault *KeyVaultContractProperties

	// Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool

	// Optional tags that when provided can be used to filter the NamedValue list.
	Tags []*string

	// Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace. This property
	// will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
	// the value.
	Value *string
}

// NamedValueCreateContract - NamedValue details.
type NamedValueCreateContract struct {
	// NamedValue entity contract properties for PUT operation.
	Properties *NamedValueCreateContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NamedValueCreateContractProperties - NamedValue Contract properties.
type NamedValueCreateContractProperties struct {
	// REQUIRED; Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
	DisplayName *string

	// KeyVault location details of the namedValue.
	KeyVault *KeyVaultContractCreateProperties

	// Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool

	// Optional tags that when provided can be used to filter the NamedValue list.
	Tags []*string

	// Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace. This property
	// will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
	// the value.
	Value *string
}

// NamedValueEntityBaseParameters - NamedValue Entity Base Parameters set.
type NamedValueEntityBaseParameters struct {
	// Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool

	// Optional tags that when provided can be used to filter the NamedValue list.
	Tags []*string
}

// NamedValueSecretContract - Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
type NamedValueSecretContract struct {
	// This is secret value of the NamedValue entity.
	Value *string
}

// NamedValueUpdateParameterProperties - NamedValue Contract properties.
type NamedValueUpdateParameterProperties struct {
	// Unique name of NamedValue. It may contain only letters, digits, period, dash, and underscore characters.
	DisplayName *string

	// KeyVault location details of the namedValue.
	KeyVault *KeyVaultContractCreateProperties

	// Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool

	// Optional tags that when provided can be used to filter the NamedValue list.
	Tags []*string

	// Value of the NamedValue. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string
}

// NamedValueUpdateParameters - NamedValue update Parameters.
type NamedValueUpdateParameters struct {
	// NamedValue entity Update contract properties.
	Properties *NamedValueUpdateParameterProperties
}

// NetworkStatusContract - Network Status details.
type NetworkStatusContract struct {
	// REQUIRED; Gets the list of Connectivity Status to the Resources on which the service depends upon.
	ConnectivityStatus []*ConnectivityStatusContract

	// REQUIRED; Gets the list of DNS servers IPV4 addresses.
	DNSServers []*string
}

// NetworkStatusContractByLocation - Network Status in the Location
type NetworkStatusContractByLocation struct {
	// Location of service
	Location *string

	// Network status in Location
	NetworkStatus *NetworkStatusContract
}

// NotificationCollection - Paged Notification list representation.
type NotificationCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*NotificationContract
}

// NotificationContract - Notification details.
type NotificationContract struct {
	// Notification entity contract properties.
	Properties *NotificationContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NotificationContractProperties - Notification Contract properties.
type NotificationContractProperties struct {
	// REQUIRED; Title of the Notification.
	Title *string

	// Description of the Notification.
	Description *string

	// Recipient Parameter values.
	Recipients *RecipientsContractProperties
}

// OAuth2AuthenticationSettingsContract - API OAuth2 Authentication settings details.
type OAuth2AuthenticationSettingsContract struct {
	// OAuth authorization server identifier.
	AuthorizationServerID *string

	// operations scope.
	Scope *string
}

// OpenIDAuthenticationSettingsContract - API OAuth2 Authentication settings details.
type OpenIDAuthenticationSettingsContract struct {
	// How to send token to the server.
	BearerTokenSendingMethods []*BearerTokenSendingMethods

	// OAuth authorization server identifier.
	OpenidProviderID *string
}

// OpenIDConnectProviderCollection - Paged OpenIdProviders list representation.
type OpenIDConnectProviderCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*OpenidConnectProviderContract
}

// OpenidConnectProviderContract - OpenId Connect Provider details.
type OpenidConnectProviderContract struct {
	// OpenId Connect Provider contract properties.
	Properties *OpenidConnectProviderContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// OpenidConnectProviderContractProperties - OpenID Connect Providers Contract.
type OpenidConnectProviderContractProperties struct {
	// REQUIRED; Client ID of developer console which is the client application.
	ClientID *string

	// REQUIRED; User-friendly OpenID Connect Provider name.
	DisplayName *string

	// REQUIRED; Metadata endpoint URI.
	MetadataEndpoint *string

	// Client Secret of developer console which is the client application.
	ClientSecret *string

	// User-friendly description of OpenID Connect Provider.
	Description *string

	// If true, the Open ID Connect provider will be used in the API documentation in the developer portal. False by default if
	// no value is provided.
	UseInAPIDocumentation *bool

	// If true, the Open ID Connect provider may be used in the developer portal test console. True by default if no value is
	// provided.
	UseInTestConsole *bool
}

// OpenidConnectProviderUpdateContract - Parameters supplied to the Update OpenID Connect Provider operation.
type OpenidConnectProviderUpdateContract struct {
	// OpenId Connect Provider Update contract properties.
	Properties *OpenidConnectProviderUpdateContractProperties
}

// OpenidConnectProviderUpdateContractProperties - Parameters supplied to the Update OpenID Connect Provider operation.
type OpenidConnectProviderUpdateContractProperties struct {
	// Client ID of developer console which is the client application.
	ClientID *string

	// Client Secret of developer console which is the client application.
	ClientSecret *string

	// User-friendly description of OpenID Connect Provider.
	Description *string

	// User-friendly OpenID Connect Provider name.
	DisplayName *string

	// Metadata endpoint URI.
	MetadataEndpoint *string

	// If true, the Open ID Connect provider will be used in the API documentation in the developer portal. False by default if
	// no value is provided.
	UseInAPIDocumentation *bool

	// If true, the Open ID Connect provider may be used in the developer portal test console. True by default if no value is
	// provided.
	UseInTestConsole *bool
}

// Operation - REST API operation
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string

	// The operation origin.
	Origin *string

	// The operation properties.
	Properties any
}

// OperationCollection - Paged Operation list representation.
type OperationCollection struct {
	// Total record count number across all pages.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*OperationContract
}

// OperationContract - API Operation details.
type OperationContract struct {
	// Properties of the Operation Contract.
	Properties *OperationContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// OperationContractProperties - Operation Contract Properties
type OperationContractProperties struct {
	// REQUIRED; Operation Name.
	DisplayName *string

	// REQUIRED; A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string

	// REQUIRED; Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string

	// Description of the operation. May include HTML formatting tags.
	Description *string

	// Operation Policies
	Policies *string

	// An entity containing request details.
	Request *RequestContract

	// Array of Operation responses.
	Responses []*ResponseContract

	// Collection of URL template parameters.
	TemplateParameters []*ParameterContract
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// Friendly name of the operation
	Description *string

	// Operation type: read, write, delete, listKeys/action, etc.
	Operation *string

	// Friendly name of the resource provider
	Provider *string

	// Resource type on which the operation is performed.
	Resource *string
}

// OperationEntityBaseContract - API Operation Entity Base Contract details.
type OperationEntityBaseContract struct {
	// Description of the operation. May include HTML formatting tags.
	Description *string

	// Operation Policies
	Policies *string

	// An entity containing request details.
	Request *RequestContract

	// Array of Operation responses.
	Responses []*ResponseContract

	// Collection of URL template parameters.
	TemplateParameters []*ParameterContract
}

// OperationListResult - Result of the request to list REST API operations. It contains a list of operations and a URL nextLink
// to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of operations supported by the resource provider.
	Value []*Operation
}

// OperationResultContract - Long Running Git Operation Results.
type OperationResultContract struct {
	// Properties of the Operation Contract.
	Properties *OperationResultContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// OperationResultContractProperties - Operation Result.
type OperationResultContractProperties struct {
	// Error Body Contract
	Error *ErrorResponseBody

	// Operation result identifier.
	ID *string

	// Optional result info.
	ResultInfo *string

	// Start time of an async operation. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO
	// 8601 standard.
	Started *time.Time

	// Status of an async operation.
	Status *AsyncOperationStatus

	// Last update time of an async operation. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by
	// the ISO 8601 standard.
	Updated *time.Time

	// READ-ONLY; This property if only provided as part of the TenantConfigurationValidate operation. It contains the log the
	// entities which will be updated/created/deleted as part of the TenantConfigurationDeploy
	// operation.
	ActionLog []*OperationResultLogItemContract
}

// OperationResultLogItemContract - Log of the entity being created, updated or deleted.
type OperationResultLogItemContract struct {
	// Action like create/update/delete.
	Action *string

	// Identifier of the entity being created/updated/deleted.
	ObjectKey *string

	// The type of entity contract.
	ObjectType *string
}

// OperationTagResourceContractProperties - Operation Entity contract Properties.
type OperationTagResourceContractProperties struct {
	// Identifier of the operation in form /operations/{operationId}.
	ID *string

	// READ-ONLY; API Name.
	APIName *string

	// READ-ONLY; API Revision.
	APIRevision *string

	// READ-ONLY; API Version.
	APIVersion *string

	// READ-ONLY; Operation Description.
	Description *string

	// READ-ONLY; A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string

	// READ-ONLY; Operation name.
	Name *string

	// READ-ONLY; Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string
}

// OperationUpdateContract - API Operation Update Contract details.
type OperationUpdateContract struct {
	// Properties of the API Operation entity that can be updated.
	Properties *OperationUpdateContractProperties
}

// OperationUpdateContractProperties - Operation Update Contract Properties.
type OperationUpdateContractProperties struct {
	// Description of the operation. May include HTML formatting tags.
	Description *string

	// Operation Name.
	DisplayName *string

	// A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string

	// Operation Policies
	Policies *string

	// An entity containing request details.
	Request *RequestContract

	// Array of Operation responses.
	Responses []*ResponseContract

	// Collection of URL template parameters.
	TemplateParameters []*ParameterContract

	// Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string
}

// OutboundEnvironmentEndpoint - Endpoints accessed for a common purpose that the Api Management Service requires outbound
// network access to.
type OutboundEnvironmentEndpoint struct {
	// The type of service accessed by the Api Management Service, e.g., Azure Storage, Azure SQL Database, and Azure Active Directory.
	Category *string

	// The endpoints that the Api Management Service reaches the service at.
	Endpoints []*EndpointDependency
}

// OutboundEnvironmentEndpointList - Collection of Outbound Environment Endpoints
type OutboundEnvironmentEndpointList struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundEnvironmentEndpoint

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ParameterContract - Operation parameters details.
type ParameterContract struct {
	// REQUIRED; Parameter name.
	Name *string

	// REQUIRED; Parameter type.
	Type *string

	// Default parameter value.
	DefaultValue *string

	// Parameter description.
	Description *string

	// Exampled defined for the parameter.
	Examples map[string]*ParameterExampleContract

	// Specifies whether parameter is required or not.
	Required *bool

	// Schema identifier.
	SchemaID *string

	// Type name defined by the schema.
	TypeName *string

	// Parameter values.
	Values []*string
}

// ParameterExampleContract - Parameter example.
type ParameterExampleContract struct {
	// Long description for the example
	Description *string

	// A URL that points to the literal example
	ExternalValue *string

	// Short description for the example
	Summary *string

	// Example value. May be a primitive value, or an object.
	Value any
}

// PipelineDiagnosticSettings - Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
type PipelineDiagnosticSettings struct {
	// Diagnostic settings for request.
	Request *HTTPMessageDiagnostic

	// Diagnostic settings for response.
	Response *HTTPMessageDiagnostic
}

// PolicyCollection - The response of the list policy operation.
type PolicyCollection struct {
	// Total record count number.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Policy Contract value.
	Value []*PolicyContract
}

// PolicyContract - Policy Contract details.
type PolicyContract struct {
	// Properties of the Policy.
	Properties *PolicyContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PolicyContractProperties - Policy contract Properties.
type PolicyContractProperties struct {
	// REQUIRED; Contents of the Policy as defined by the format.
	Value *string

	// Format of the policyContent.
	Format *PolicyContentFormat
}

// PolicyDescriptionCollection - Descriptions of API Management policies.
type PolicyDescriptionCollection struct {
	// Total record count number.
	Count *int64

	// Descriptions of API Management policies.
	Value []*PolicyDescriptionContract
}

// PolicyDescriptionContract - Policy description details.
type PolicyDescriptionContract struct {
	// Policy description contract properties.
	Properties *PolicyDescriptionContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PolicyDescriptionContractProperties - Policy description properties.
type PolicyDescriptionContractProperties struct {
	// READ-ONLY; Policy description.
	Description *string

	// READ-ONLY; Binary OR value of the Snippet scope.
	Scope *int64
}

// PolicyFragmentCollection - The response of the get policy fragments operation.
type PolicyFragmentCollection struct {
	// Total record count number.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Policy fragment contract value.
	Value []*PolicyFragmentContract
}

// PolicyFragmentContract - Policy fragment contract details.
type PolicyFragmentContract struct {
	// Properties of the Policy Fragment.
	Properties *PolicyFragmentContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PolicyFragmentContractProperties - Policy fragment contract properties.
type PolicyFragmentContractProperties struct {
	// REQUIRED; Contents of the policy fragment.
	Value *string

	// Policy fragment description.
	Description *string

	// Format of the policy fragment content.
	Format *PolicyFragmentContentFormat
}

// PortalConfigCollection - The collection of the developer portal configurations.
type PortalConfigCollection struct {
	// The developer portal configurations.
	Value []*PortalConfigContract

	// READ-ONLY; Next page link if any.
	NextLink *string
}

// PortalConfigContract - The developer portal configuration contract.
type PortalConfigContract struct {
	// The developer portal configuration contract properties.
	Properties *PortalConfigProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PortalConfigCorsProperties - The developer portal Cross-Origin Resource Sharing (CORS) settings.
type PortalConfigCorsProperties struct {
	// Allowed origins, e.g. https://trusted.com.
	AllowedOrigins []*string
}

// PortalConfigCspProperties - The developer portal Content Security Policy (CSP) settings.
type PortalConfigCspProperties struct {
	// Allowed sources, e.g. *.trusted.com, trusted.com, https://.
	AllowedSources []*string

	// The mode of the developer portal Content Security Policy (CSP).
	Mode *PortalSettingsCspMode

	// The URLs used by the browser to report CSP violations.
	ReportURI []*string
}

type PortalConfigDelegationProperties struct {
	// Enable or disable delegation for user registration.
	DelegateRegistration *bool

	// Enable or disable delegation for product subscriptions.
	DelegateSubscription *bool

	// A delegation endpoint URL.
	DelegationURL *string

	// A base64-encoded validation key to ensure requests originate from Azure API Management service.
	ValidationKey *string
}

// PortalConfigProperties - The developer portal configuration contract properties.
type PortalConfigProperties struct {
	// The developer portal Cross-Origin Resource Sharing (CORS) settings.
	Cors *PortalConfigCorsProperties

	// The developer portal Content Security Policy (CSP) settings.
	Csp *PortalConfigCspProperties

	// The developer portal delegation settings.
	Delegation *PortalConfigDelegationProperties

	// Enable or disable Basic authentication method.
	EnableBasicAuth *bool
	Signin          *PortalConfigPropertiesSignin
	Signup          *PortalConfigPropertiesSignup
}

type PortalConfigPropertiesSignin struct {
	// Redirect anonymous users to the sign-in page.
	Require *bool
}

type PortalConfigPropertiesSignup struct {
	// Terms of service settings.
	TermsOfService *PortalConfigTermsOfServiceProperties
}

// PortalConfigTermsOfServiceProperties - Terms of service contract properties.
type PortalConfigTermsOfServiceProperties struct {
	// Ask user for consent to the terms of service.
	RequireConsent *bool

	// A terms of service text.
	Text *string
}

// PortalDelegationSettings - Delegation settings for a developer portal.
type PortalDelegationSettings struct {
	// Delegation settings contract properties.
	Properties *PortalDelegationSettingsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PortalDelegationSettingsProperties - Delegation settings contract properties.
type PortalDelegationSettingsProperties struct {
	// Subscriptions delegation settings.
	Subscriptions *SubscriptionsDelegationSettingsProperties

	// A delegation Url.
	URL *string

	// User registration delegation settings.
	UserRegistration *RegistrationDelegationSettingsProperties

	// A base64-encoded validation key to validate, that a request is coming from Azure API Management.
	ValidationKey *string
}

// PortalRevisionCollection - Paged list of portal revisions.
type PortalRevisionCollection struct {
	// READ-ONLY; Next page link, if any.
	NextLink *string

	// READ-ONLY; Collection of portal revisions.
	Value []*PortalRevisionContract
}

// PortalRevisionContract - Portal Revision's contract details.
type PortalRevisionContract struct {
	// Properties of the portal revisions.
	Properties *PortalRevisionContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type PortalRevisionContractProperties struct {
	// Portal revision description.
	Description *string

	// Indicates if the portal's revision is public.
	IsCurrent *bool

	// READ-ONLY; Portal's revision creation date and time.
	CreatedDateTime *time.Time

	// READ-ONLY; Status of the portal's revision.
	Status *PortalRevisionStatus

	// READ-ONLY; Portal revision publishing status details.
	StatusDetails *string

	// READ-ONLY; Last updated date and time.
	UpdatedDateTime *time.Time
}

// PortalSettingValidationKeyContract - Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
type PortalSettingValidationKeyContract struct {
	// This is secret value of the validation key in portal settings.
	ValidationKey *string
}

// PortalSettingsCollection - Descriptions of API Management policies.
type PortalSettingsCollection struct {
	// Total record count number.
	Count *int64

	// Descriptions of API Management policies.
	Value []*PortalSettingsContract
}

// PortalSettingsContract - Portal Settings for the Developer Portal.
type PortalSettingsContract struct {
	// Portal Settings contract properties.
	Properties *PortalSettingsContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PortalSettingsContractProperties - Sign-in settings contract properties.
type PortalSettingsContractProperties struct {
	// Redirect Anonymous users to the Sign-In page.
	Enabled *bool

	// Subscriptions delegation settings.
	Subscriptions *SubscriptionsDelegationSettingsProperties

	// Terms of service contract properties.
	TermsOfService *TermsOfServiceProperties

	// A delegation Url.
	URL *string

	// User registration delegation settings.
	UserRegistration *RegistrationDelegationSettingsProperties

	// A base64-encoded validation key to validate, that a request is coming from Azure API Management.
	ValidationKey *string
}

// PortalSigninSettingProperties - Sign-in settings contract properties.
type PortalSigninSettingProperties struct {
	// Redirect Anonymous users to the Sign-In page.
	Enabled *bool
}

// PortalSigninSettings - Sign-In settings for the Developer Portal.
type PortalSigninSettings struct {
	// Sign-in settings contract properties.
	Properties *PortalSigninSettingProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PortalSignupSettings - Sign-Up settings for a developer portal.
type PortalSignupSettings struct {
	// Sign-up settings contract properties.
	Properties *PortalSignupSettingsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PortalSignupSettingsProperties - Sign-up settings contract properties.
type PortalSignupSettingsProperties struct {
	// Allow users to sign up on a developer portal.
	Enabled *bool

	// Terms of service contract properties.
	TermsOfService *TermsOfServiceProperties
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateEndpointConnectionRequest - A request to approve or reject a private endpoint connection
type PrivateEndpointConnectionRequest struct {
	// Private Endpoint Connection Resource Id.
	ID *string

	// The connection state of the private endpoint connection.
	Properties *PrivateEndpointConnectionRequestProperties
}

// PrivateEndpointConnectionRequestProperties - The connection state of the private endpoint connection.
type PrivateEndpointConnectionRequestProperties struct {
	// A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState
}

// PrivateEndpointConnectionWrapperProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionWrapperProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private end point.
	PrivateEndpoint *ArmIDWrapper

	// READ-ONLY; All the Group ids.
	GroupIDs []*string

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *string
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// ProductCollection - Paged Products list representation.
type ProductCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*ProductContract
}

// ProductContract - Product details.
type ProductContract struct {
	// Product entity contract properties.
	Properties *ProductContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProductContractProperties - Product profile.
type ProductContractProperties struct {
	// REQUIRED; Product name.
	DisplayName *string

	// whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers
	// to call the product’s APIs immediately after subscribing. If true,
	// administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present
	// only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool

	// Product description. May include HTML formatting tags.
	Description *string

	// whether product is published or not. Published products are discoverable by users of developer portal. Non published products
	// are visible only to administrators. Default state of Product is
	// notPublished.
	State *ProductState

	// Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred
	// to as "protected" and a valid subscription key is required for a request to an
	// API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included
	// in the product can be made without a subscription key. If property is omitted
	// when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool

	// Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited
	// per user subscriptions. Can be present only if subscriptionRequired
	// property is present and has a value of false.
	SubscriptionsLimit *int32

	// Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms
	// before they can complete the subscription process.
	Terms *string
}

// ProductEntityBaseParameters - Product Entity Base Parameters
type ProductEntityBaseParameters struct {
	// whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers
	// to call the product’s APIs immediately after subscribing. If true,
	// administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present
	// only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool

	// Product description. May include HTML formatting tags.
	Description *string

	// whether product is published or not. Published products are discoverable by users of developer portal. Non published products
	// are visible only to administrators. Default state of Product is
	// notPublished.
	State *ProductState

	// Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred
	// to as "protected" and a valid subscription key is required for a request to an
	// API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included
	// in the product can be made without a subscription key. If property is omitted
	// when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool

	// Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited
	// per user subscriptions. Can be present only if subscriptionRequired
	// property is present and has a value of false.
	SubscriptionsLimit *int32

	// Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms
	// before they can complete the subscription process.
	Terms *string
}

// ProductTagResourceContractProperties - Product profile.
type ProductTagResourceContractProperties struct {
	// REQUIRED; Product name.
	Name *string

	// whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers
	// to call the product’s APIs immediately after subscribing. If true,
	// administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present
	// only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool

	// Product description. May include HTML formatting tags.
	Description *string

	// Identifier of the product in the form of /products/{productId}
	ID *string

	// whether product is published or not. Published products are discoverable by users of developer portal. Non published products
	// are visible only to administrators. Default state of Product is
	// notPublished.
	State *ProductState

	// Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred
	// to as "protected" and a valid subscription key is required for a request to an
	// API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included
	// in the product can be made without a subscription key. If property is omitted
	// when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool

	// Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited
	// per user subscriptions. Can be present only if subscriptionRequired
	// property is present and has a value of false.
	SubscriptionsLimit *int32

	// Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms
	// before they can complete the subscription process.
	Terms *string
}

// ProductUpdateParameters - Product Update parameters.
type ProductUpdateParameters struct {
	// Product entity Update contract properties.
	Properties *ProductUpdateProperties
}

// ProductUpdateProperties - Parameters supplied to the Update Product operation.
type ProductUpdateProperties struct {
	// whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers
	// to call the product’s APIs immediately after subscribing. If true,
	// administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present
	// only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool

	// Product description. May include HTML formatting tags.
	Description *string

	// Product name.
	DisplayName *string

	// whether product is published or not. Published products are discoverable by users of developer portal. Non published products
	// are visible only to administrators. Default state of Product is
	// notPublished.
	State *ProductState

	// Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred
	// to as "protected" and a valid subscription key is required for a request to an
	// API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included
	// in the product can be made without a subscription key. If property is omitted
	// when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool

	// Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited
	// per user subscriptions. Can be present only if subscriptionRequired
	// property is present and has a value of false.
	SubscriptionsLimit *int32

	// Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms
	// before they can complete the subscription process.
	Terms *string
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// QuotaCounterCollection - Paged Quota Counter list representation.
type QuotaCounterCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Quota counter values.
	Value []*QuotaCounterContract
}

// QuotaCounterContract - Quota counter details.
type QuotaCounterContract struct {
	// REQUIRED; The Key value of the Counter. Must not be empty.
	CounterKey *string

	// REQUIRED; The date of the end of Counter Period. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	PeriodEndTime *time.Time

	// REQUIRED; Identifier of the Period for which the counter was collected. Must not be empty.
	PeriodKey *string

	// REQUIRED; The date of the start of Counter Period. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	PeriodStartTime *time.Time

	// Quota Value Properties
	Value *QuotaCounterValueContractProperties
}

// QuotaCounterValueContract - Quota counter value details.
type QuotaCounterValueContract struct {
	// Quota counter Value Properties.
	Value *QuotaCounterValueContractProperties
}

// QuotaCounterValueContractProperties - Quota counter value details.
type QuotaCounterValueContractProperties struct {
	// Number of times Counter was called.
	CallsCount *int32

	// Data Transferred in KiloBytes.
	KbTransferred *float64
}

// QuotaCounterValueUpdateContract - Quota counter value details.
type QuotaCounterValueUpdateContract struct {
	// Quota counter value details.
	Properties *QuotaCounterValueContractProperties
}

// RecipientEmailCollection - Paged Recipient User list representation.
type RecipientEmailCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*RecipientEmailContract
}

// RecipientEmailContract - Recipient Email details.
type RecipientEmailContract struct {
	// Recipient Email contract properties.
	Properties *RecipientEmailContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RecipientEmailContractProperties - Recipient Email Contract Properties.
type RecipientEmailContractProperties struct {
	// User Email subscribed to notification.
	Email *string
}

// RecipientUserCollection - Paged Recipient User list representation.
type RecipientUserCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*RecipientUserContract
}

// RecipientUserContract - Recipient User details.
type RecipientUserContract struct {
	// Recipient User entity contract properties.
	Properties *RecipientUsersContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RecipientUsersContractProperties - Recipient User Contract Properties.
type RecipientUsersContractProperties struct {
	// API Management UserId subscribed to notification.
	UserID *string
}

// RecipientsContractProperties - Notification Parameter contract.
type RecipientsContractProperties struct {
	// List of Emails subscribed for the notification.
	Emails []*string

	// List of Users subscribed for the notification.
	Users []*string
}

// RegionContract - Region profile.
type RegionContract struct {
	// whether Region is deleted.
	IsDeleted *bool

	// whether Region is the master region.
	IsMasterRegion *bool

	// READ-ONLY; Region name.
	Name *string
}

// RegionListResult - Lists Regions operation response details.
type RegionListResult struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Lists of Regions.
	Value []*RegionContract
}

// RegistrationDelegationSettingsProperties - User registration delegation settings properties.
type RegistrationDelegationSettingsProperties struct {
	// Enable or disable delegation for user registration.
	Enabled *bool
}

// RemotePrivateEndpointConnectionWrapper - Remote Private Endpoint Connection resource.
type RemotePrivateEndpointConnectionWrapper struct {
	// Private Endpoint connection resource id
	ID *string

	// Private Endpoint Connection Name
	Name *string

	// Resource properties.
	Properties *PrivateEndpointConnectionWrapperProperties

	// Private Endpoint Connection Resource Type
	Type *string
}

// ReportCollection - Paged Report records list representation.
type ReportCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*ReportRecordContract
}

// ReportRecordContract - Report data.
type ReportRecordContract struct {
	// API identifier path. /apis/{apiId}
	APIID *string

	// API region identifier.
	APIRegion *string

	// Average time it took to process request.
	APITimeAvg *float64

	// Maximum time it took to process request.
	APITimeMax *float64

	// Minimum time it took to process request.
	APITimeMin *float64

	// Bandwidth consumed.
	Bandwidth *int64

	// Number of times when content was served from cache policy.
	CacheHitCount *int32

	// Number of times content was fetched from backend.
	CacheMissCount *int32

	// Number of calls blocked due to invalid credentials. This includes calls returning HttpStatusCode.Unauthorized and HttpStatusCode.Forbidden
	// and HttpStatusCode.TooManyRequests
	CallCountBlocked *int32

	// Number of calls failed due to gateway or backend errors. This includes calls returning HttpStatusCode.BadRequest(400) and
	// any Code between HttpStatusCode.InternalServerError (500) and 600
	CallCountFailed *int32

	// Number of other calls.
	CallCountOther *int32

	// Number of successful calls. This includes calls returning HttpStatusCode <= 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect
	CallCountSuccess *int32

	// Total number of calls.
	CallCountTotal *int32

	// Country to which this record data is related.
	Country *string

	// Length of aggregation period. Interval must be multiple of 15 minutes and may not be zero. The value should be in ISO 8601
	// format (http://en.wikipedia.org/wiki/ISO_8601#Durations).
	Interval *string

	// Name depending on report endpoint specifies product, API, operation or developer name.
	Name *string

	// Operation identifier path. /apis/{apiId}/operations/{operationId}
	OperationID *string

	// Country region to which this record data is related.
	Region *string

	// Average time it took to process request on backend.
	ServiceTimeAvg *float64

	// Maximum time it took to process request on backend.
	ServiceTimeMax *float64

	// Minimum time it took to process request on backend.
	ServiceTimeMin *float64

	// Subscription identifier path. /subscriptions/{subscriptionId}
	SubscriptionID *string

	// Start of aggregation period. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
	// standard.
	Timestamp *time.Time

	// Zip code to which this record data is related.
	Zip *string

	// READ-ONLY; Product identifier path. /products/{productId}
	ProductID *string

	// READ-ONLY; User identifier path. /users/{userId}
	UserID *string
}

// RepresentationContract - Operation request/response representation details.
type RepresentationContract struct {
	// REQUIRED; Specifies a registered or custom content type for this representation, e.g. application/xml.
	ContentType *string

	// Exampled defined for the representation.
	Examples map[string]*ParameterExampleContract

	// Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
	FormParameters []*ParameterContract

	// Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
	SchemaID *string

	// Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded'
	// nor 'multipart/form-data'.
	TypeName *string
}

// RequestContract - Operation request details.
type RequestContract struct {
	// Operation request description.
	Description *string

	// Collection of operation request headers.
	Headers []*ParameterContract

	// Collection of operation request query parameters.
	QueryParameters []*ParameterContract

	// Collection of operation request representations.
	Representations []*RepresentationContract
}

// RequestReportCollection - Paged Report records list representation.
type RequestReportCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Page values.
	Value []*RequestReportRecordContract
}

// RequestReportRecordContract - Request Report data.
type RequestReportRecordContract struct {
	// API identifier path. /apis/{apiId}
	APIID *string

	// Azure region where the gateway that processed this request is located.
	APIRegion *string

	// The total time it took to process this request.
	APITime *float64

	// The HTTP status code received by the gateway as a result of forwarding this request to the backend.
	BackendResponseCode *string

	// Specifies if response cache was involved in generating the response. If the value is none, the cache was not used. If the
	// value is hit, cached response was returned. If the value is miss, the cache
	// was used but lookup resulted in a miss and request was fulfilled by the backend.
	Cache *string

	// The client IP address associated with this request.
	IPAddress *string

	// The HTTP method associated with this request..
	Method *string

	// Operation identifier path. /apis/{apiId}/operations/{operationId}
	OperationID *string

	// Request Identifier.
	RequestID *string

	// The size of this request..
	RequestSize *int32

	// The HTTP status code returned by the gateway.
	ResponseCode *int32

	// The size of the response returned by the gateway.
	ResponseSize *int32

	// he time it took to forward this request to the backend and get the response back.
	ServiceTime *float64

	// Subscription identifier path. /subscriptions/{subscriptionId}
	SubscriptionID *string

	// The date and time when this request was received by the gateway in ISO 8601 format.
	Timestamp *time.Time

	// The full URL associated with this request.
	URL *string

	// READ-ONLY; Product identifier path. /products/{productId}
	ProductID *string

	// READ-ONLY; User identifier path. /users/{userId}
	UserID *string
}

// ResolverCollection - Paged Resolver list representation.
type ResolverCollection struct {
	// Total record count number across all pages.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*ResolverContract
}

// ResolverContract - GraphQL API Resolver details.
type ResolverContract struct {
	// Properties of the Resolver Contract.
	Properties *ResolverEntityBaseContract

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResolverEntityBaseContract - GraphQL API Resolver Entity Base Contract details.
type ResolverEntityBaseContract struct {
	// Description of the resolver. May include HTML formatting tags.
	Description *string

	// Resolver Name.
	DisplayName *string

	// Path is type/field being resolved.
	Path *string
}

// ResolverResultContract - Long Running Git Resolver Results.
type ResolverResultContract struct {
	// Properties of the Resolver Contract.
	Properties *ResolverResultContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResolverResultContractProperties - Resolver Result.
type ResolverResultContractProperties struct {
	// Error Body Contract
	Error *ErrorResponseBody

	// Resolver result identifier.
	ID *string

	// Optional result info.
	ResultInfo *string

	// Start time of an async resolver. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO
	// 8601 standard.
	Started *time.Time

	// Status of an async resolver.
	Status *AsyncResolverStatus

	// Last update time of an async resolver. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by
	// the ISO 8601 standard.
	Updated *time.Time

	// READ-ONLY; This property if only provided as part of the TenantConfigurationValidate resolver. It contains the log the
	// entities which will be updated/created/deleted as part of the TenantConfigurationDeploy
	// resolver.
	ActionLog []*ResolverResultLogItemContract
}

// ResolverResultLogItemContract - Log of the entity being created, updated or deleted.
type ResolverResultLogItemContract struct {
	// Action like create/update/delete.
	Action *string

	// Identifier of the entity being created/updated/deleted.
	ObjectKey *string

	// The type of entity contract.
	ObjectType *string
}

// ResolverUpdateContract - GraphQL API Resolver Update Contract details.
type ResolverUpdateContract struct {
	// Properties of the GraphQL API Resolver entity that can be updated.
	Properties *ResolverUpdateContractProperties
}

// ResolverUpdateContractProperties - Resolver Update Contract Properties.
type ResolverUpdateContractProperties struct {
	// Description of the resolver. May include HTML formatting tags.
	Description *string

	// Resolver Name.
	DisplayName *string

	// Path is type/field being resolved.
	Path *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceCollection - A collection of resources.
type ResourceCollection struct {
	// Total record count number.
	Count *int64

	// Next page link if any.
	NextLink *string

	// A collection of resources.
	Value []*ResourceCollectionValueItem
}

type ResourceCollectionValueItem struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceLocationDataContract - Resource location data properties.
type ResourceLocationDataContract struct {
	// REQUIRED; A canonical name for the geographic or physical location.
	Name *string

	// The city or locality where the resource is located.
	City *string

	// The country or region where the resource is located.
	CountryOrRegion *string

	// The district, state, or province where the resource is located.
	District *string
}

// ResourceSKU - Describes an available API Management SKU.
type ResourceSKU struct {
	// Name of the Sku.
	Name *SKUType
}

// ResourceSKUCapacity - Describes scaling information of a SKU.
type ResourceSKUCapacity struct {
	// READ-ONLY; The default capacity.
	Default *int32

	// READ-ONLY; The maximum capacity that can be set.
	Maximum *int32

	// READ-ONLY; The minimum capacity.
	Minimum *int32

	// READ-ONLY; The scale type applicable to the sku.
	ScaleType *ResourceSKUCapacityScaleType
}

// ResourceSKUResult - Describes an available API Management service SKU.
type ResourceSKUResult struct {
	// READ-ONLY; Specifies the number of API Management units.
	Capacity *ResourceSKUCapacity

	// READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string

	// READ-ONLY; Specifies API Management SKU.
	SKU *ResourceSKU
}

// ResourceSKUResults - The API Management service SKUs operation response.
type ResourceSKUResults struct {
	// REQUIRED; The list of skus available for the service.
	Value []*ResourceSKUResult

	// The uri to fetch the next page of API Management service Skus.
	NextLink *string
}

// ResponseContract - Operation response details.
type ResponseContract struct {
	// REQUIRED; Operation response HTTP status code.
	StatusCode *int32

	// Operation response description.
	Description *string

	// Collection of operation response headers.
	Headers []*ParameterContract

	// Collection of operation response representations.
	Representations []*RepresentationContract
}

// SKU - Describes an available ApiManagement SKU.
type SKU struct {
	// READ-ONLY; The api versions that support this SKU.
	APIVersions []*string

	// READ-ONLY; A name value pair to describe the capability.
	Capabilities []*SKUCapabilities

	// READ-ONLY; Specifies the number of virtual machines in the scale set.
	Capacity *SKUCapacity

	// READ-ONLY; Metadata for retrieving price info.
	Costs []*SKUCosts

	// READ-ONLY; The Family of this particular SKU.
	Family *string

	// READ-ONLY; The Kind of resources that are supported in this SKU.
	Kind *string

	// READ-ONLY; A list of locations and availability zones in those locations where the SKU is available.
	LocationInfo []*SKULocationInfo

	// READ-ONLY; The set of locations that the SKU is available.
	Locations []*string

	// READ-ONLY; The name of SKU.
	Name *string

	// READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string

	// READ-ONLY; The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*SKURestrictions

	// READ-ONLY; The Size of the SKU.
	Size *string

	// READ-ONLY; Specifies the tier of virtual machines in a scale set.
	// Possible Values:
	// Standard
	// Basic
	Tier *string
}

// SKUCapabilities - Describes The SKU capabilities object.
type SKUCapabilities struct {
	// READ-ONLY; An invariant to describe the feature.
	Name *string

	// READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string
}

// SKUCapacity - Describes scaling information of a SKU.
type SKUCapacity struct {
	// READ-ONLY; The default capacity.
	Default *int32

	// READ-ONLY; The maximum capacity that can be set.
	Maximum *int32

	// READ-ONLY; The minimum capacity.
	Minimum *int32

	// READ-ONLY; The scale type applicable to the sku.
	ScaleType *APIManagementSKUCapacityScaleType
}

// SKUCosts - Describes metadata for retrieving price info.
type SKUCosts struct {
	// READ-ONLY; An invariant to show the extended unit.
	ExtendedUnit *string

	// READ-ONLY; Used for querying price from commerce.
	MeterID *string

	// READ-ONLY; The multiplier is needed to extend the base metered cost.
	Quantity *int64
}

type SKULocationInfo struct {
	// READ-ONLY; Location of the SKU
	Location *string

	// READ-ONLY; Details of capabilities available to a SKU in specific zones.
	ZoneDetails []*SKUZoneDetails

	// READ-ONLY; List of availability zones where the SKU is supported.
	Zones []*string
}

type SKURestrictionInfo struct {
	// READ-ONLY; Locations where the SKU is restricted
	Locations []*string

	// READ-ONLY; List of availability zones where the SKU is restricted.
	Zones []*string
}

// SKURestrictions - Describes scaling information of a SKU.
type SKURestrictions struct {
	// READ-ONLY; The reason for restriction.
	ReasonCode *APIManagementSKURestrictionsReasonCode

	// READ-ONLY; The information about the restriction where the SKU cannot be used.
	RestrictionInfo *SKURestrictionInfo

	// READ-ONLY; The type of restrictions.
	Type *APIManagementSKURestrictionsType

	// READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where
	// the SKU is restricted.
	Values []*string
}

// SKUZoneDetails - Describes The zonal capabilities of a SKU.
type SKUZoneDetails struct {
	// READ-ONLY; A list of capabilities that are available for the SKU in the specified list of zones.
	Capabilities []*SKUCapabilities

	// READ-ONLY; The set of zones that the SKU is available in with the specified capabilities.
	Name []*string
}

// SKUsResult - The List Resource Skus operation response.
type SKUsResult struct {
	// REQUIRED; The list of skus available for the subscription.
	Value []*SKU

	// READ-ONLY; The URI to fetch the next page of Resource Skus. Call ListNext() with this URI to fetch the next page of Resource
	// Skus
	NextLink *string
}

// SamplingSettings - Sampling settings for Diagnostic.
type SamplingSettings struct {
	// Rate of sampling for fixed-rate sampling.
	Percentage *float64

	// Sampling type.
	SamplingType *SamplingType
}

// SaveConfigurationParameter - Save Tenant Configuration Contract details.
type SaveConfigurationParameter struct {
	// Properties of the Save Configuration Parameters.
	Properties *SaveConfigurationParameterProperties
}

// SaveConfigurationParameterProperties - Parameters supplied to the Save Tenant Configuration operation.
type SaveConfigurationParameterProperties struct {
	// REQUIRED; The name of the Git branch in which to commit the current configuration snapshot.
	Branch *string

	// The value if true, the current configuration database is committed to the Git repository, even if the Git repository has
	// newer changes that would be overwritten.
	Force *bool
}

// SchemaCollection - The response of the list schema operation.
type SchemaCollection struct {
	// Total record count number.
	Count *int64

	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; API Schema Contract value.
	Value []*SchemaContract
}

// SchemaContract - API Schema Contract details.
type SchemaContract struct {
	// Properties of the API Schema.
	Properties *SchemaContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SchemaContractProperties - API Schema create or update contract Properties.
type SchemaContractProperties struct {
	// REQUIRED; Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema
	// document (e.g. application/json, application/xml).
	// - Swagger Schema use application/vnd.ms-azure-apim.swagger.definitions+json
	// - WSDL Schema use application/vnd.ms-azure-apim.xsd+xml
	// - OpenApi Schema use application/vnd.oai.openapi.components+json
	// - WADL Schema use application/vnd.ms-azure-apim.wadl.grammars+xml.
	ContentType *string

	// REQUIRED; Create or update Properties of the API Schema Document.
	Document *SchemaDocumentProperties
}

// SchemaDocumentProperties - Api Schema Document Properties.
type SchemaDocumentProperties struct {
	// Types definitions. Used for Swagger/OpenAPI v2/v3 schemas only, null otherwise.
	Components any

	// Types definitions. Used for Swagger/OpenAPI v1 schemas only, null otherwise.
	Definitions any

	// Json escaped string defining the document representing the Schema. Used for schemas other than Swagger/OpenAPI.
	Value *string
}

// ServiceApplyNetworkConfigurationParameters - Parameter supplied to the Apply Network configuration operation.
type ServiceApplyNetworkConfigurationParameters struct {
	// Location of the Api Management service to update for a multi-region service. For a service deployed in a single region,
	// this parameter is not required.
	Location *string
}

// ServiceBackupRestoreParameters - Parameters supplied to the Backup/Restore of an API Management service operation.
type ServiceBackupRestoreParameters struct {
	// REQUIRED; The name of the backup file to create/retrieve.
	BackupName *string

	// REQUIRED; The name of the blob container (used to place/retrieve the backup).
	ContainerName *string

	// REQUIRED; The name of the Azure storage account (used to place/retrieve the backup).
	StorageAccount *string

	// Storage account access key. Required only if accessType is set to AccessKey.
	AccessKey *string

	// The type of access to be used for the storage account.
	AccessType *AccessType

	// The Client ID of user assigned managed identity. Required only if accessType is set to UserAssignedManagedIdentity.
	ClientID *string
}

// ServiceBaseProperties - Base Properties of an API Management service resource description.
type ServiceBaseProperties struct {
	// Control Plane Apis version constraint for the API Management service.
	APIVersionConstraint *APIVersionConstraint

	// Additional datacenter locations of the API Management service.
	AdditionalLocations []*AdditionalLocation

	// List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed
	// is 10.
	Certificates []*CertificateConfiguration

	// Custom properties of the API Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168 will disable the cipher TLSRSAWITH3DESEDECBCSHA
	// for all TLS(1.0, 1.1 and 1.2).
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11 can be used to disable just TLS 1.1.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10 can be used to disable TLS 1.0 on an API
	// Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11 can be used to disable just TLS 1.1
	// for communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10 can be used to disable TLS 1.0 for
	// communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2 can be used to enable HTTP2 protocol on an
	// API Management service.
	// Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For
	// all the settings except Http2 the default value is True if the service was
	// created on or before April 1, 2018 and False otherwise. Http2 setting's default value is False.
	// You can disable any of the following ciphers by using settings Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]:
	// TLSECDHEECDSAWITHAES256CBCSHA, TLSECDHEECDSAWITHAES128CBC
	// SHA, TLSECDHERSAWITHAES256CBCSHA, TLSECDHERSAWITHAES128CBCSHA, TLSRSAWITHAES128GCMSHA256, TLSRSAWITHAES256CBCSHA256, TLSRSAWITHAES128CBCSHA256,
	// TLSRSAWITHAES256CBCSHA, TLSRSAWITHAES128CBCSHA. For
	// example, Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256:false. The default
	// value is true for them.
	// Note: The following ciphers can't be disabled since they are required by internal platform components: TLSAES256GCMSHA384,TLSAES128GCMSHA256,TLSECDHEECDSAWITHAES256GCMSHA384,TLSECDHEECDSAWITHAES128GCM
	// SHA256,TLSECDHERSAWITHAES256GCMSHA384,TLSECDHERSAWITHAES128GCMSHA256,TLSECDHEECDSAWITHAES256CBCSHA384,TLSECDHEECDSAWITHAES128CBCSHA256,TLSECDHERSAWITHAES256CBCSHA384,TLSECDHERSAWITHAES128CBCSHA256
	CustomProperties map[string]*string

	// Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway
	// in master region.
	DisableGateway *bool

	// Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each
	// request to the gateway. This also enables the ability to authenticate the
	// certificate in the policy on the gateway.
	EnableClientCertificate *bool

	// Custom hostname configuration of the API Management service.
	HostnameConfigurations []*HostnameConfiguration

	// Property can be used to enable NAT Gateway for this API Management service.
	NatGatewayState *NatGatewayState

	// Email address from which the notification will be sent.
	NotificationSenderEmail *string

	// List of Private Endpoint Connections of this service.
	PrivateEndpointConnections []*RemotePrivateEndpointConnectionWrapper

	// Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported
	// only for Developer and Premium SKU being deployed in Virtual Network.
	PublicIPAddressID *string

	// Whether or not public endpoint access is allowed for this API Management service. Value is optional but if passed in, must
	// be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
	// exclusive access method. Default value is 'Enabled'
	PublicNetworkAccess *PublicNetworkAccess

	// Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other
	// properties will be ignored.
	Restore *bool

	// Virtual network configuration of the API Management service.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration

	// The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management
	// service is not part of any Virtual Network, External means the API Management
	// deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management
	// deployment is setup inside a Virtual Network having an Intranet Facing Endpoint
	// only.
	VirtualNetworkType *VirtualNetworkType

	// READ-ONLY; Creation UTC date of the API Management service.The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
	// as specified by the ISO 8601 standard.
	CreatedAtUTC *time.Time

	// READ-ONLY; DEveloper Portal endpoint URL of the API Management service.
	DeveloperPortalURL *string

	// READ-ONLY; Gateway URL of the API Management service in the Default Region.
	GatewayRegionalURL *string

	// READ-ONLY; Gateway URL of the API Management service.
	GatewayURL *string

	// READ-ONLY; Management API endpoint URL of the API Management service.
	ManagementAPIURL *string

	// READ-ONLY; Outbound public IPV4 address prefixes associated with NAT Gateway deployed service. Available only for Premium
	// SKU on stv2 platform.
	OutboundPublicIPAddresses []*string

	// READ-ONLY; Compute Platform Version running the service in this location.
	PlatformVersion *PlatformVersion

	// READ-ONLY; Publisher portal endpoint Url of the API Management service.
	PortalURL *string

	// READ-ONLY; Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed
	// in an Internal Virtual Network. Available only for Basic, Standard, Premium and Isolated
	// SKU.
	PrivateIPAddresses []*string

	// READ-ONLY; The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string

	// READ-ONLY; Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for
	// Basic, Standard, Premium and Isolated SKU.
	PublicIPAddresses []*string

	// READ-ONLY; SCM endpoint URL of the API Management service.
	ScmURL *string

	// READ-ONLY; The provisioning state of the API Management service, which is targeted by the long running operation started
	// on the service.
	TargetProvisioningState *string
}

// ServiceCheckNameAvailabilityParameters - Parameters supplied to the CheckNameAvailability operation.
type ServiceCheckNameAvailabilityParameters struct {
	// REQUIRED; The name to check for availability.
	Name *string
}

// ServiceGetDomainOwnershipIdentifierResult - Response of the GetDomainOwnershipIdentifier operation.
type ServiceGetDomainOwnershipIdentifierResult struct {
	// READ-ONLY; The domain ownership identifier value.
	DomainOwnershipIdentifier *string
}

// ServiceGetSsoTokenResult - The response of the GetSsoToken operation.
type ServiceGetSsoTokenResult struct {
	// Redirect URL to the Publisher Portal containing the SSO token.
	RedirectURI *string
}

// ServiceIdentity - Identity properties of the Api Management service resource.
type ServiceIdentity struct {
	// REQUIRED; The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly
	// created identity and a set of user assigned identities. The type 'None' will remove any
	// identities from the service.
	Type *ApimIdentityType

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/ providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserIdentityProperties

	// READ-ONLY; The principal id of the identity.
	PrincipalID *string

	// READ-ONLY; The client tenant id of the identity.
	TenantID *string
}

// ServiceListResult - The response of the List API Management services operation.
type ServiceListResult struct {
	// REQUIRED; Result of the List API Management services operation.
	Value []*ServiceResource

	// Link to the next set of results. Not empty if Value contains incomplete list of API Management services.
	NextLink *string
}

// ServiceNameAvailabilityResult - Response of the CheckNameAvailability operation.
type ServiceNameAvailabilityResult struct {
	// Invalid indicates the name provided does not match the resource provider’s naming requirements (incorrect length, unsupported
	// characters, etc.) AlreadyExists indicates that the name is already in use
	// and is therefore unavailable.
	Reason *NameAvailabilityReason

	// READ-ONLY; If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource
	// naming requirements so that the user can select a valid name. If reason == AlreadyExists,
	// explain that is already in use, and direct them to select a different name.
	Message *string

	// READ-ONLY; True if the name is available and can be used to create a new API Management service; otherwise false.
	NameAvailable *bool
}

// ServiceProperties - Properties of an API Management service resource description.
type ServiceProperties struct {
	// REQUIRED; Publisher email.
	PublisherEmail *string

	// REQUIRED; Publisher name.
	PublisherName *string

	// Control Plane Apis version constraint for the API Management service.
	APIVersionConstraint *APIVersionConstraint

	// Additional datacenter locations of the API Management service.
	AdditionalLocations []*AdditionalLocation

	// List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed
	// is 10.
	Certificates []*CertificateConfiguration

	// Custom properties of the API Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168 will disable the cipher TLSRSAWITH3DESEDECBCSHA
	// for all TLS(1.0, 1.1 and 1.2).
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11 can be used to disable just TLS 1.1.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10 can be used to disable TLS 1.0 on an API
	// Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11 can be used to disable just TLS 1.1
	// for communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10 can be used to disable TLS 1.0 for
	// communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2 can be used to enable HTTP2 protocol on an
	// API Management service.
	// Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For
	// all the settings except Http2 the default value is True if the service was
	// created on or before April 1, 2018 and False otherwise. Http2 setting's default value is False.
	// You can disable any of the following ciphers by using settings Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]:
	// TLSECDHEECDSAWITHAES256CBCSHA, TLSECDHEECDSAWITHAES128CBC
	// SHA, TLSECDHERSAWITHAES256CBCSHA, TLSECDHERSAWITHAES128CBCSHA, TLSRSAWITHAES128GCMSHA256, TLSRSAWITHAES256CBCSHA256, TLSRSAWITHAES128CBCSHA256,
	// TLSRSAWITHAES256CBCSHA, TLSRSAWITHAES128CBCSHA. For
	// example, Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256:false. The default
	// value is true for them.
	// Note: The following ciphers can't be disabled since they are required by internal platform components: TLSAES256GCMSHA384,TLSAES128GCMSHA256,TLSECDHEECDSAWITHAES256GCMSHA384,TLSECDHEECDSAWITHAES128GCM
	// SHA256,TLSECDHERSAWITHAES256GCMSHA384,TLSECDHERSAWITHAES128GCMSHA256,TLSECDHEECDSAWITHAES256CBCSHA384,TLSECDHEECDSAWITHAES128CBCSHA256,TLSECDHERSAWITHAES256CBCSHA384,TLSECDHERSAWITHAES128CBCSHA256
	CustomProperties map[string]*string

	// Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway
	// in master region.
	DisableGateway *bool

	// Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each
	// request to the gateway. This also enables the ability to authenticate the
	// certificate in the policy on the gateway.
	EnableClientCertificate *bool

	// Custom hostname configuration of the API Management service.
	HostnameConfigurations []*HostnameConfiguration

	// Property can be used to enable NAT Gateway for this API Management service.
	NatGatewayState *NatGatewayState

	// Email address from which the notification will be sent.
	NotificationSenderEmail *string

	// List of Private Endpoint Connections of this service.
	PrivateEndpointConnections []*RemotePrivateEndpointConnectionWrapper

	// Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported
	// only for Developer and Premium SKU being deployed in Virtual Network.
	PublicIPAddressID *string

	// Whether or not public endpoint access is allowed for this API Management service. Value is optional but if passed in, must
	// be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
	// exclusive access method. Default value is 'Enabled'
	PublicNetworkAccess *PublicNetworkAccess

	// Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other
	// properties will be ignored.
	Restore *bool

	// Virtual network configuration of the API Management service.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration

	// The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management
	// service is not part of any Virtual Network, External means the API Management
	// deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management
	// deployment is setup inside a Virtual Network having an Intranet Facing Endpoint
	// only.
	VirtualNetworkType *VirtualNetworkType

	// READ-ONLY; Creation UTC date of the API Management service.The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
	// as specified by the ISO 8601 standard.
	CreatedAtUTC *time.Time

	// READ-ONLY; DEveloper Portal endpoint URL of the API Management service.
	DeveloperPortalURL *string

	// READ-ONLY; Gateway URL of the API Management service in the Default Region.
	GatewayRegionalURL *string

	// READ-ONLY; Gateway URL of the API Management service.
	GatewayURL *string

	// READ-ONLY; Management API endpoint URL of the API Management service.
	ManagementAPIURL *string

	// READ-ONLY; Outbound public IPV4 address prefixes associated with NAT Gateway deployed service. Available only for Premium
	// SKU on stv2 platform.
	OutboundPublicIPAddresses []*string

	// READ-ONLY; Compute Platform Version running the service in this location.
	PlatformVersion *PlatformVersion

	// READ-ONLY; Publisher portal endpoint Url of the API Management service.
	PortalURL *string

	// READ-ONLY; Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed
	// in an Internal Virtual Network. Available only for Basic, Standard, Premium and Isolated
	// SKU.
	PrivateIPAddresses []*string

	// READ-ONLY; The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string

	// READ-ONLY; Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for
	// Basic, Standard, Premium and Isolated SKU.
	PublicIPAddresses []*string

	// READ-ONLY; SCM endpoint URL of the API Management service.
	ScmURL *string

	// READ-ONLY; The provisioning state of the API Management service, which is targeted by the long running operation started
	// on the service.
	TargetProvisioningState *string
}

// ServiceResource - A single API Management service resource in List or Get response.
type ServiceResource struct {
	// REQUIRED; Resource location.
	Location *string

	// REQUIRED; Properties of the API Management service.
	Properties *ServiceProperties

	// REQUIRED; SKU properties of the API Management service.
	SKU *ServiceSKUProperties

	// Managed service identity of the Api Management service.
	Identity *ServiceIdentity

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string

	// READ-ONLY; ETag of the resource.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string
}

// ServiceSKUProperties - API Management service resource SKU properties.
type ServiceSKUProperties struct {
	// REQUIRED; Capacity of the SKU (number of deployed units of the SKU). For Consumption SKU capacity must be specified as
	// 0.
	Capacity *int32

	// REQUIRED; Name of the Sku.
	Name *SKUType
}

// ServiceUpdateParameters - Parameter supplied to Update Api Management Service.
type ServiceUpdateParameters struct {
	// Managed service identity of the Api Management service.
	Identity *ServiceIdentity

	// Properties of the API Management service.
	Properties *ServiceUpdateProperties

	// SKU properties of the API Management service.
	SKU *ServiceSKUProperties

	// Resource tags.
	Tags map[string]*string

	// A list of availability zones denoting where the resource needs to come from.
	Zones []*string

	// READ-ONLY; ETag of the resource.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string
}

// ServiceUpdateProperties - Properties of an API Management service resource description.
type ServiceUpdateProperties struct {
	// Control Plane Apis version constraint for the API Management service.
	APIVersionConstraint *APIVersionConstraint

	// Additional datacenter locations of the API Management service.
	AdditionalLocations []*AdditionalLocation

	// List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed
	// is 10.
	Certificates []*CertificateConfiguration

	// Custom properties of the API Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168 will disable the cipher TLSRSAWITH3DESEDECBCSHA
	// for all TLS(1.0, 1.1 and 1.2).
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11 can be used to disable just TLS 1.1.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10 can be used to disable TLS 1.0 on an API
	// Management service.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11 can be used to disable just TLS 1.1
	// for communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10 can be used to disable TLS 1.0 for
	// communications with backends.
	// Setting Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2 can be used to enable HTTP2 protocol on an
	// API Management service.
	// Not specifying any of these properties on PATCH operation will reset omitted properties' values to their defaults. For
	// all the settings except Http2 the default value is True if the service was
	// created on or before April 1, 2018 and False otherwise. Http2 setting's default value is False.
	// You can disable any of the following ciphers by using settings Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]:
	// TLSECDHEECDSAWITHAES256CBCSHA, TLSECDHEECDSAWITHAES128CBC
	// SHA, TLSECDHERSAWITHAES256CBCSHA, TLSECDHERSAWITHAES128CBCSHA, TLSRSAWITHAES128GCMSHA256, TLSRSAWITHAES256CBCSHA256, TLSRSAWITHAES128CBCSHA256,
	// TLSRSAWITHAES256CBCSHA, TLSRSAWITHAES128CBCSHA. For
	// example, Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256:false. The default
	// value is true for them.
	// Note: The following ciphers can't be disabled since they are required by internal platform components: TLSAES256GCMSHA384,TLSAES128GCMSHA256,TLSECDHEECDSAWITHAES256GCMSHA384,TLSECDHEECDSAWITHAES128GCM
	// SHA256,TLSECDHERSAWITHAES256GCMSHA384,TLSECDHERSAWITHAES128GCMSHA256,TLSECDHEECDSAWITHAES256CBCSHA384,TLSECDHEECDSAWITHAES128CBCSHA256,TLSECDHERSAWITHAES256CBCSHA384,TLSECDHERSAWITHAES128CBCSHA256
	CustomProperties map[string]*string

	// Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway
	// in master region.
	DisableGateway *bool

	// Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on each
	// request to the gateway. This also enables the ability to authenticate the
	// certificate in the policy on the gateway.
	EnableClientCertificate *bool

	// Custom hostname configuration of the API Management service.
	HostnameConfigurations []*HostnameConfiguration

	// Property can be used to enable NAT Gateway for this API Management service.
	NatGatewayState *NatGatewayState

	// Email address from which the notification will be sent.
	NotificationSenderEmail *string

	// List of Private Endpoint Connections of this service.
	PrivateEndpointConnections []*RemotePrivateEndpointConnectionWrapper

	// Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region. Supported
	// only for Developer and Premium SKU being deployed in Virtual Network.
	PublicIPAddressID *string

	// Whether or not public endpoint access is allowed for this API Management service. Value is optional but if passed in, must
	// be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
	// exclusive access method. Default value is 'Enabled'
	PublicNetworkAccess *PublicNetworkAccess

	// Publisher email.
	PublisherEmail *string

	// Publisher name.
	PublisherName *string

	// Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all other
	// properties will be ignored.
	Restore *bool

	// Virtual network configuration of the API Management service.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration

	// The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management
	// service is not part of any Virtual Network, External means the API Management
	// deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management
	// deployment is setup inside a Virtual Network having an Intranet Facing Endpoint
	// only.
	VirtualNetworkType *VirtualNetworkType

	// READ-ONLY; Creation UTC date of the API Management service.The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ
	// as specified by the ISO 8601 standard.
	CreatedAtUTC *time.Time

	// READ-ONLY; DEveloper Portal endpoint URL of the API Management service.
	DeveloperPortalURL *string

	// READ-ONLY; Gateway URL of the API Management service in the Default Region.
	GatewayRegionalURL *string

	// READ-ONLY; Gateway URL of the API Management service.
	GatewayURL *string

	// READ-ONLY; Management API endpoint URL of the API Management service.
	ManagementAPIURL *string

	// READ-ONLY; Outbound public IPV4 address prefixes associated with NAT Gateway deployed service. Available only for Premium
	// SKU on stv2 platform.
	OutboundPublicIPAddresses []*string

	// READ-ONLY; Compute Platform Version running the service in this location.
	PlatformVersion *PlatformVersion

	// READ-ONLY; Publisher portal endpoint Url of the API Management service.
	PortalURL *string

	// READ-ONLY; Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed
	// in an Internal Virtual Network. Available only for Basic, Standard, Premium and Isolated
	// SKU.
	PrivateIPAddresses []*string

	// READ-ONLY; The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string

	// READ-ONLY; Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for
	// Basic, Standard, Premium and Isolated SKU.
	PublicIPAddresses []*string

	// READ-ONLY; SCM endpoint URL of the API Management service.
	ScmURL *string

	// READ-ONLY; The provisioning state of the API Management service, which is targeted by the long running operation started
	// on the service.
	TargetProvisioningState *string
}

// SubscriptionCollection - Paged Subscriptions list representation.
type SubscriptionCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*SubscriptionContract
}

// SubscriptionContract - Subscription details.
type SubscriptionContract struct {
	// Subscription contract properties.
	Properties *SubscriptionContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SubscriptionContractProperties - Subscription details.
type SubscriptionContractProperties struct {
	// REQUIRED; Scope like /products/{productId} or /apis or /apis/{apiId}.
	Scope *string

	// REQUIRED; Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription
	// is blocked, and the subscriber cannot call any APIs of the product, * submitted – the
	// subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription
	// request has been denied by an administrator, * cancelled – the
	// subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration
	// date and was deactivated.
	State *SubscriptionState

	// Determines whether tracing is enabled
	AllowTracing *bool

	// The name of the subscription, or null if the subscription has no name.
	DisplayName *string

	// Date when subscription was cancelled or expired. The setting is for audit purposes only and the subscription is not automatically
	// cancelled. The subscription lifecycle can be managed by using the
	// state property. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	EndDate *time.Time

	// Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically expired.
	// The subscription lifecycle can be managed by using the state property. The date
	// conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	ExpirationDate *time.Time

	// Upcoming subscription expiration notification date. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as
	// specified by the ISO 8601 standard.
	NotificationDate *time.Time

	// The user resource identifier of the subscription owner. The value is a valid relative URL in the format of /users/{userId}
	// where {userId} is a user identifier.
	OwnerID *string

	// Subscription primary key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
	// the value.
	PrimaryKey *string

	// Subscription secondary key. This property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get
	// the value.
	SecondaryKey *string

	// Subscription activation date. The setting is for audit purposes only and the subscription is not automatically activated.
	// The subscription lifecycle can be managed by using the state property. The
	// date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	StartDate *time.Time

	// Optional subscription comment added by an administrator when the state is changed to the 'rejected'.
	StateComment *string

	// READ-ONLY; Subscription creation date. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by
	// the ISO 8601 standard.
	CreatedDate *time.Time
}

// SubscriptionCreateParameterProperties - Parameters supplied to the Create subscription operation.
type SubscriptionCreateParameterProperties struct {
	// REQUIRED; Subscription name.
	DisplayName *string

	// REQUIRED; Scope like /products/{productId} or /apis or /apis/{apiId}.
	Scope *string

	// Determines whether tracing can be enabled
	AllowTracing *bool

	// User (user id path) for whom subscription is being created in form /users/{userId}
	OwnerID *string

	// Primary subscription key. If not specified during request key will be generated automatically.
	PrimaryKey *string

	// Secondary subscription key. If not specified during request key will be generated automatically.
	SecondaryKey *string

	// Initial subscription state. If no value is specified, subscription is created with Submitted state. Possible states are
	// * active – the subscription is active, * suspended – the subscription is
	// blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by
	// the developer, but has not yet been approved or rejected, * rejected – the
	// subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer
	// or administrator, * expired – the subscription reached its expiration date
	// and was deactivated.
	State *SubscriptionState
}

// SubscriptionCreateParameters - Subscription create details.
type SubscriptionCreateParameters struct {
	// Subscription contract properties.
	Properties *SubscriptionCreateParameterProperties
}

// SubscriptionKeyParameterNamesContract - Subscription key parameter names details.
type SubscriptionKeyParameterNamesContract struct {
	// Subscription key header name.
	Header *string

	// Subscription key query string parameter name.
	Query *string
}

// SubscriptionKeysContract - Subscription keys.
type SubscriptionKeysContract struct {
	// Subscription primary key.
	PrimaryKey *string

	// Subscription secondary key.
	SecondaryKey *string
}

// SubscriptionUpdateParameterProperties - Parameters supplied to the Update subscription operation.
type SubscriptionUpdateParameterProperties struct {
	// Determines whether tracing can be enabled
	AllowTracing *bool

	// Subscription name.
	DisplayName *string

	// Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically expired.
	// The subscription lifecycle can be managed by using the state property. The date
	// conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	ExpirationDate *time.Time

	// User identifier path: /users/{userId}
	OwnerID *string

	// Primary subscription key.
	PrimaryKey *string

	// Scope like /products/{productId} or /apis or /apis/{apiId}
	Scope *string

	// Secondary subscription key.
	SecondaryKey *string

	// Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked,
	// and the subscriber cannot call any APIs of the product, * submitted – the
	// subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription
	// request has been denied by an administrator, * cancelled – the
	// subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration
	// date and was deactivated.
	State *SubscriptionState

	// Comments describing subscription state change by the administrator when the state is changed to the 'rejected'.
	StateComment *string
}

// SubscriptionUpdateParameters - Subscription update details.
type SubscriptionUpdateParameters struct {
	// Subscription Update contract properties.
	Properties *SubscriptionUpdateParameterProperties
}

// SubscriptionsDelegationSettingsProperties - Subscriptions delegation settings properties.
type SubscriptionsDelegationSettingsProperties struct {
	// Enable or disable delegation for subscriptions.
	Enabled *bool
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagCollection - Paged Tag list representation.
type TagCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*TagContract
}

// TagContract - Tag Contract details.
type TagContract struct {
	// Tag entity contract properties.
	Properties *TagContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TagContractProperties - Tag contract Properties.
type TagContractProperties struct {
	// REQUIRED; Tag name.
	DisplayName *string
}

// TagCreateUpdateParameters - Parameters supplied to Create/Update Tag operations.
type TagCreateUpdateParameters struct {
	// Properties supplied to Create Tag operation.
	Properties *TagContractProperties
}

// TagDescriptionBaseProperties - Parameters supplied to the Create TagDescription operation.
type TagDescriptionBaseProperties struct {
	// Description of the Tag.
	Description *string

	// Description of the external resources describing the tag.
	ExternalDocsDescription *string

	// Absolute URL of external resources describing the tag.
	ExternalDocsURL *string
}

// TagDescriptionCollection - Paged TagDescription list representation.
type TagDescriptionCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*TagDescriptionContract
}

// TagDescriptionContract - Contract details.
type TagDescriptionContract struct {
	// TagDescription entity contract properties.
	Properties *TagDescriptionContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TagDescriptionContractProperties - TagDescription contract Properties.
type TagDescriptionContractProperties struct {
	// Description of the Tag.
	Description *string

	// Tag name.
	DisplayName *string

	// Description of the external resources describing the tag.
	ExternalDocsDescription *string

	// Absolute URL of external resources describing the tag.
	ExternalDocsURL *string

	// Identifier of the tag in the form of /tags/{tagId}
	TagID *string
}

// TagDescriptionCreateParameters - Parameters supplied to the Create TagDescription operation.
type TagDescriptionCreateParameters struct {
	// Properties supplied to Create TagDescription operation.
	Properties *TagDescriptionBaseProperties
}

// TagResourceCollection - Paged Tag list representation.
type TagResourceCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*TagResourceContract
}

// TagResourceContract - TagResource contract properties.
type TagResourceContract struct {
	// REQUIRED; Tag associated with the resource.
	Tag *TagResourceContractProperties

	// API associated with the tag.
	API *APITagResourceContractProperties

	// Operation associated with the tag.
	Operation *OperationTagResourceContractProperties

	// Product associated with the tag.
	Product *ProductTagResourceContractProperties
}

// TagResourceContractProperties - Contract defining the Tag property in the Tag Resource Contract
type TagResourceContractProperties struct {
	// Tag identifier
	ID *string

	// Tag Name
	Name *string
}

// TenantConfigurationSyncStateContract - Result of Tenant Configuration Sync State.
type TenantConfigurationSyncStateContract struct {
	// Properties returned Tenant Configuration Sync State check.
	Properties *TenantConfigurationSyncStateContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TenantConfigurationSyncStateContractProperties - Tenant Configuration Synchronization State.
type TenantConfigurationSyncStateContractProperties struct {
	// The name of Git branch.
	Branch *string

	// The latest commit Id.
	CommitID *string

	// The date of the latest configuration change. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified
	// by the ISO 8601 standard.
	ConfigurationChangeDate *time.Time

	// value indicating if last sync was save (true) or deploy (false) operation.
	IsExport *bool

	// value indicating whether Git configuration access is enabled.
	IsGitEnabled *bool

	// value indicating if last synchronization was later than the configuration change.
	IsSynced *bool

	// Most recent tenant configuration operation identifier
	LastOperationID *string

	// The date of the latest synchronization. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by
	// the ISO 8601 standard.
	SyncDate *time.Time
}

// TenantSettingsCollection - Paged AccessInformation list representation.
type TenantSettingsCollection struct {
	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*TenantSettingsContract
}

// TenantSettingsContract - Tenant Settings.
type TenantSettingsContract struct {
	// TenantSettings entity contract properties.
	Properties *TenantSettingsContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TenantSettingsContractProperties - Tenant access information contract of the API Management service.
type TenantSettingsContractProperties struct {
	// Tenant settings
	Settings map[string]*string
}

// TermsOfServiceProperties - Terms of service contract properties.
type TermsOfServiceProperties struct {
	// Ask user for consent to the terms of service.
	ConsentRequired *bool

	// Display terms of service during a sign-up process.
	Enabled *bool

	// A terms of service text.
	Text *string
}

// TokenBodyParameterContract - OAuth acquire token request body parameter (www-url-form-encoded).
type TokenBodyParameterContract struct {
	// REQUIRED; body parameter name.
	Name *string

	// REQUIRED; body parameter value.
	Value *string
}

// UserCollection - Paged Users list representation.
type UserCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// Page values.
	Value []*UserContract
}

// UserContract - User details.
type UserContract struct {
	// User entity contract properties.
	Properties *UserContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UserContractProperties - User profile.
type UserContractProperties struct {
	// Email address.
	Email *string

	// First name.
	FirstName *string

	// Collection of user identities.
	Identities []*UserIdentityContract

	// Last name.
	LastName *string

	// Optional note about a user set by the administrator.
	Note *string

	// Date of user registration. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
	// standard.
	RegistrationDate *time.Time

	// Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal
	// or call any APIs of subscribed products. Default state is Active.
	State *UserState

	// READ-ONLY; Collection of groups user is part of.
	Groups []*GroupContractProperties
}

// UserCreateParameterProperties - Parameters supplied to the Create User operation.
type UserCreateParameterProperties struct {
	// REQUIRED; Email address. Must not be empty and must be unique within the service instance.
	Email *string

	// REQUIRED; First name.
	FirstName *string

	// REQUIRED; Last name.
	LastName *string

	// Determines the type of application which send the create user request. Default is legacy portal.
	AppType *AppType

	// Determines the type of confirmation e-mail that will be sent to the newly created user.
	Confirmation *Confirmation

	// Collection of user identities.
	Identities []*UserIdentityContract

	// Optional note about a user set by the administrator.
	Note *string

	// User Password. If no value is provided, a default password is generated.
	Password *string

	// Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal
	// or call any APIs of subscribed products. Default state is Active.
	State *UserState
}

// UserCreateParameters - User create details.
type UserCreateParameters struct {
	// User entity create contract properties.
	Properties *UserCreateParameterProperties
}

// UserEntityBaseParameters - User Entity Base Parameters set.
type UserEntityBaseParameters struct {
	// Collection of user identities.
	Identities []*UserIdentityContract

	// Optional note about a user set by the administrator.
	Note *string

	// Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal
	// or call any APIs of subscribed products. Default state is Active.
	State *UserState
}

// UserIdentityCollection - List of Users Identity list representation.
type UserIdentityCollection struct {
	// Total record count number across all pages.
	Count *int64

	// Next page link if any.
	NextLink *string

	// User Identity values.
	Value []*UserIdentityContract
}

// UserIdentityContract - User identity details.
type UserIdentityContract struct {
	// Identifier value within provider.
	ID *string

	// Identity provider name.
	Provider *string
}

type UserIdentityProperties struct {
	// The client id of user assigned identity.
	ClientID *string

	// The principal id of user assigned identity.
	PrincipalID *string
}

// UserTokenParameterProperties - Parameters supplied to the Get User Token operation.
type UserTokenParameterProperties struct {
	// REQUIRED; The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following
	// format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	Expiry *time.Time

	// REQUIRED; The Key to be used to generate token for user.
	KeyType *KeyType
}

// UserTokenParameters - Get User Token parameters.
type UserTokenParameters struct {
	// User Token Parameter contract properties.
	Properties *UserTokenParameterProperties
}

// UserTokenResult - Get User Token response details.
type UserTokenResult struct {
	// Shared Access Authorization token for the User.
	Value *string
}

// UserUpdateParameters - User update parameters.
type UserUpdateParameters struct {
	// User entity update contract properties.
	Properties *UserUpdateParametersProperties
}

// UserUpdateParametersProperties - Parameters supplied to the Update User operation.
type UserUpdateParametersProperties struct {
	// Email address. Must not be empty and must be unique within the service instance.
	Email *string

	// First name.
	FirstName *string

	// Collection of user identities.
	Identities []*UserIdentityContract

	// Last name.
	LastName *string

	// Optional note about a user set by the administrator.
	Note *string

	// User Password.
	Password *string

	// Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal
	// or call any APIs of subscribed products. Default state is Active.
	State *UserState
}

// VirtualNetworkConfiguration - Configuration of a virtual network to which API Management service is deployed.
type VirtualNetworkConfiguration struct {
	// The full resource ID of a subnet in a virtual network to deploy the API Management service in.
	SubnetResourceID *string

	// READ-ONLY; The name of the subnet.
	Subnetname *string

	// READ-ONLY; The virtual network ID. This is typically a GUID. Expect a null GUID by default.
	Vnetid *string
}

// WikiCollection - Paged Wiki list representation.
type WikiCollection struct {
	// READ-ONLY; Next page link if any.
	NextLink *string

	// READ-ONLY; Page values.
	Value []*WikiContract
}

// WikiContract - Wiki properties
type WikiContract struct {
	// Wiki details.
	Properties *WikiContractProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WikiContractProperties - Wiki contract details
type WikiContractProperties struct {
	// Collection wiki documents included into this wiki.
	Documents []*WikiDocumentationContract
}

// WikiDocumentationContract - Wiki documentation details.
type WikiDocumentationContract struct {
	// Documentation Identifier
	DocumentationID *string
}

// WikiUpdateContract - Wiki update contract details.
type WikiUpdateContract struct {
	// Wiki details.
	Properties *WikiContractProperties
}

// X509CertificateName - Properties of server X509Names.
type X509CertificateName struct {
	// Thumbprint for the Issuer of the Certificate.
	IssuerCertificateThumbprint *string

	// Common Name of the Certificate.
	Name *string
}
