---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Absence of anti-CSRF tokens

## Description

The application failed to protect against Cross-Site Request Forgery (CSRF) by using
secure application tokens or `SameSite` cookie directives.

The vulnerability can be exploited by an attacker creating a link or form on a third
party site and tricking an authenticated victim to access them.

## Remediation

Consider setting all session cookies to have the `SameSite=Strict` attribute. However,
it should be noted that this may impact usability when sharing links across other mediums.
It is recommended that a two cookie based approach is taken, as outlined in the
[Top level navigations](https://datatracker.ietf.org/doc/html/draft-ietf-httpbis-rfc6265bis-08#section-8.8.2) section
of the RFC.

If the application is using a common framework, there is a chance that Anti-CSRF protection
is built in but needs to be enabled. Consult your application framework documentation for
details.

If neither of the above are applicable, it is **strongly** recommended that a third party library is used.
Implementing a secure Anti-CSRF system is a significant investment and difficult to do correctly.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 352.1 | true | 352 | Passive | Medium |

## Links

- [OWASP](https://owasp.org/www-community/attacks/csrf)
- [CWE](https://cwe.mitre.org/data/definitions/352.html)
