package repro is
	type MicroInst_r is record
		STATE_CTRL    	: bit_vector(1 downto 0);
		ADDR_BUS      	: bit_vector(2 downto 0);
		LOAD_SDLH      : bit_vector(1 downto 0);
		LOAD_P			: bit_vector(2 downto 0); 
		LOAD_T			: bit_vector(2 downto 0); 
		ADDR_CTRL     	: bit_vector(5 downto 0);
		LOAD_PC       	: bit_vector(2 downto 0);
		LOAD_SP       	: bit_vector(2 downto 0);
		AXY_CTRL      	: bit_vector(2 downto 0); 
		ALUBUS_CTRL		: bit_vector(3 downto 0); 
		ALUCtrl      	: bit_vector(4 downto 0); 
		OUT_BUS       	: bit_vector(3 downto 0);
		MEM_CYCLE      : bit;
	end record;
 
	type MicroInst_t is array(0 to 256*8-1) of MicroInst_r;
	constant M_TAB1: MicroInst_t := (
  --STATE ADBUS SDLH  P    T   ADDRCTRL  PC    SP  AXYBUS  ALUBUS  ALUCTRL  OUT  MCYC
	-- 00 BRK
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","010","00","000","000","000000","000","011","000","0000","00000","0110",'1'),-- ['PCH->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0111",'1'),-- ['PCL->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0101",'1'),-- ['P->[21:SP]', 'SP--', '0->T]
	("00","100","00","010","000","000000","010","000","000","0000","00000","0000",'1'),-- ['[VECT+0]->PCL', '1->I', '0->D', '1->B']
	("10","100","00","000","000","000000","011","000","000","0000","00000","0000",'1'),-- ['[VECT+1]->PCH']
	-- 01 ORA (ZP,X)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+X->AAL']
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0001","00010","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 02 S0Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","010","000000","000","000","010","0011","00000","0000",'1'),-- ['0->T', 'Y->0'] 
	("10","000","00","000","000","000000","000","000","100","0101","00000","0000",'0'),-- ['T->Y'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 03 ST0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","001","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->T', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- [] 
	("10","101","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[ST]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 04 TSB ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","101","001","000000","000","000","000","0001","01110","0000",'1'),-- ['ALU(A,[20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 05 ORA ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","001","000","000000","000","000","001","0001","00010","0000",'1'),-- ['ALU(A,[20:AAL])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 06 ASL ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","101","001","000000","000","000","000","0000","01000","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 07 RMB0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01101","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 08 PHP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","010","00","000","000","000000","000","011","000","0000","00000","0101",'1'),-- ['P->[21:SP]', 'SP--']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 09 ORA IMM / IMM,(0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","001","000","001","0001","00010","0000",'1'),-- ['ALU(A,[PC])->A', 'PC++', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 0A ASL A
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","101","000","000000","000","000","001","0001","01000","0000",'1'),-- ['ALU(A)->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 0B
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 0C TSB ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","001","00","101","001","000000","000","000","000","0001","01110","0000",'1'),-- ['ALU(A,[AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 0D ORA ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0001","00010","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 0E ASL ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","001","00","101","001","000000","000","000","000","0000","01000","0000",'1'),-- ['ALU([AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 0F BBR0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 10 BPL
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 11 ORA (ZP),Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","110001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'1'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0001","00010","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 12 ORA (ZP)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0001","00010","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 13 ST1
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","001","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->T', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- [] 
	("10","101","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[ST]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 14 TRB ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","101","001","000000","000","000","000","0001","01101","0000",'1'),-- ['ALU(A,[20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 15 ORA ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("10","011","00","001","000","000000","000","000","001","0001","00010","0000",'1'),-- ['ALU(A,[20:AAL])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 16 ASL ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","101","001","000000","000","000","000","0000","01000","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 17 RMB1
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01101","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 18 CLC
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","100","000","000000","000","000","000","0000","00000","0000",'1'),-- ['Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 19 ORA ABS,Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0001","00010","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 1A INC A
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","001","0001","00111","0000",'1'),-- ['ALU(A)->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 1B
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 1C TRB ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","001","00","101","001","000000","000","000","000","0001","01101","0000",'1'),-- ['ALU(A,[AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 1D ORA ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0001","00010","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 1E ASL ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("00","001","00","101","001","000000","000","000","000","0000","01000","0000",'1'),-- ['ALU([AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 1F BBR1
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 20 JSR ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","000","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- [] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0110",'1'),-- ['PCH->[00:SP]', 'SP--']
	("00","010","00","000","000","000000","000","011","000","0000","00000","0111",'1'),-- ['PCL->[00:SP]', 'SP--'] 
	("10","000","00","000","000","000000","110","000","000","0000","00000","0000",'0'),-- ['AA->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 21 AND (ZP,0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0001","00001","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 22 SA0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","010","000000","000","000","010","0001","00000","0000",'1'),-- ['0->T', 'A->0'] 
	("10","000","00","000","000","000000","000","000","001","0101","00000","0000",'0'),-- ['T->A'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 23 ST2
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","001","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->T', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- [] 
	("10","101","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[ST]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 24 BIT ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","101","000","000000","000","000","000","0001","01100","0000",'1'),-- ['ALU(A,[20:AAL])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 25 AND ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","001","000","000000","000","000","001","0001","00001","0000",'1'),-- ['ALU(A,[20:AAL])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 26 ROL ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","101","001","000000","000","000","000","0000","01010","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 27 RMB2
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01101","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 28 PLP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","010","000","0000","00000","0000",'0'),-- ['SP++']
	("10","010","00","011","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[21:SP]->P']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 29 AND IMM / IMM,(0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","001","000","001","0001","00001","0000",'1'),-- ['ALU(A,[PC])->A', 'PC++', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 2A ROL A
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","101","000","000000","000","000","001","0001","01010","0000",'1'),-- ['ALU(A)->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 2B
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 2C BIT ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","101","000","000000","000","000","000","0001","01100","0000",'1'),-- ['ALU(A,[AA])', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 2D AND ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0001","00001","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 2E ROL ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","001","00","101","001","000000","000","000","000","0000","01010","0000",'1'),-- ['ALU([AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 2F BBR2
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 30 BMI
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 31 AND (ZP),Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","110001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0001","00001","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 32 AND (ZP)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0001","00001","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 33
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 34 BIT ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("10","011","00","101","000","000000","000","000","000","0001","01100","0000",'1'),-- ['ALU(A,[20:AAL])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 35 AND ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("10","011","00","001","000","000000","000","000","001","0001","00001","0000",'1'),-- ['ALU(A,[20:AAL])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 36 ROL ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","101","001","000000","000","000","000","0000","01010","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 37 RMB3
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01101","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 38 SEC
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","100","000","000000","000","000","000","0000","00000","0000",'1'),-- ['Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 39 AND ABS,Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0001","00001","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 3A DEC A
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","001","0001","00110","0000",'1'),-- ['ALU(A)->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 3B
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 3C BIT ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","101","000","000000","000","000","000","0001","01100","0000",'1'),-- ['ALU(A,[AA])', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 3D AND ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0001","00001","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 3E ROL ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("00","001","00","101","001","000000","000","000","000","0000","01010","0000",'1'),-- ['ALU([AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 3F BBR3
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 40 RTI
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","010","000","0000","00000","0000",'0'),-- ['SP++']
	("00","010","00","011","000","000000","000","010","000","0000","00000","0000",'1'),-- ['[21:SP]->P', 'SP++']
	("00","010","00","000","000","000000","010","010","000","0000","00000","0000",'1'),-- ['[21:SP]->PCL', 'SP++']
	("10","010","00","000","000","000000","011","000","000","0000","00000","0000",'1'),-- ['[21:SP]->PCH']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 41 EOR (ZP,0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0001","00011","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 42 SAY
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","011","000000","000","000","100","0001","00000","0000",'1'),-- ['Y->T', 'A->Y'] 
	("10","000","00","000","000","000000","000","000","001","0101","00000","0000",'0'),-- ['T->A'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 43 TMAi
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","001","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->T', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","000","00","000","000","000000","000","000","001","1011","00000","0000",'0'),-- ['MPR->A']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 44 BSR
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","010","00","000","000","000000","000","011","000","0000","00000","0110",'1'),-- ['PCH->[00:SP]', 'SP--']
	("00","010","00","000","000","000000","000","011","000","0000","00000","0111",'1'),-- ['PCL->[00:SP]', 'SP--'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- [] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- [] 
	("10","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	-- 45 EOR ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","001","000","000000","000","000","001","0001","00011","0000",'1'),-- ['ALU(A,[20:AAL])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 46 LSR ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","101","001","000000","000","000","000","0000","01001","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 47 RMB4
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01101","0000",'1'),-- ['ALU([20:AAL])->T']  
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 48 PHA
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","010","00","000","000","000000","000","011","000","0000","00000","0001",'1'),-- ['A->[21:SP]', 'SP--']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 49 EOR IMM / IMM,(0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","001","000","001","0001","00011","0000",'1'),-- ['ALU(A,[PC])->A', 'PC++', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 4A LSR A
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","101","000","000000","000","000","001","0001","01001","0000",'1'),-- ['ALU(A)->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 4B
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 4C JMP ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","000","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH']
	("10","000","00","000","000","000000","110","000","000","0000","00000","0000",'0'),-- ['AA->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 4D EOR ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0001","00011","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 4E LSR ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","001","00","101","001","000000","000","000","000","0000","01001","0000",'1'),-- ['ALU([AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 4F BBR4
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 50 BVC
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 51 EOR (ZP),Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","110001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0001","00011","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 52 EOR (ZP)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0001","00011","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 53 TAMi
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","001","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->T', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- ['A->MPR']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 54 CSL
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 55 EOR ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("10","011","00","001","000","000000","000","000","001","0001","00011","0000",'1'),-- ['ALU(A,[20:AAL])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 56 LSR ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","101","001","000000","000","000","000","0000","01001","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 57 RMB5
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01101","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 58 CLI
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","100","000","000000","000","000","000","0000","00000","0000",'1'),-- ['Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 59 EOR ABS,Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0001","00011","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 5A PHY
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","010","00","000","000","000000","000","011","000","0000","00000","0011",'1'),-- ['Y->[21:SP]', 'SP--']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 5B
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 5C
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 5D EOR ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0001","00011","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 5E LSR ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("00","001","00","101","001","000000","000","000","000","0000","01001","0000",'1'),-- ['ALU([AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 5F BBR5
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 60 RTS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","010","000","0000","00000","0000",'0'),-- ['SP++']
	("00","010","00","000","000","000000","010","010","000","0000","00000","0000",'1'),-- ['[21:SP]->PCL', 'SP++']
	("00","010","00","000","000","000000","011","000","000","0000","00000","0000",'1'),-- ['[21:SP]->PCH']
	("10","000","00","000","000","000000","001","000","000","0000","00000","0000",'0'),-- ['PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 61 ADC (ZP,0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("01","001","00","101","000","000000","000","000","001","0001","00100","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	-- 62 CLA
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","001","1111","00000","0000",'1'),-- ['0->A'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 63
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 64 STZ ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","1111",'1'),-- ['0->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 65 ADC ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("01","011","00","101","000","000000","000","000","001","0001","00100","0000",'1'),-- ['ALU(A,[20:AAL])->A', 'Flags'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 66 ROR ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","101","001","000000","000","000","000","0000","01011","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 67 RMB6
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01101","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 68 PLA
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","010","000","0000","00000","0000",'0'),-- ['SP++']
	("10","010","00","001","000","000000","000","000","001","0000","00000","0000",'1'),-- ['ALU([21:SP])->A']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 69 ADC IMM / IMM,(0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("01","000","00","101","000","000000","001","000","001","0001","00100","0000",'1'),-- ['ALU(A,[PC])->A', 'PC++', 'Flags'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 6A ROR A
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","101","000","000000","000","000","001","0001","01011","0000",'1'),-- ['ALU(A)->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 6B
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 6C JMP (ABS)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","001","00","000","000","010000","010","000","000","0000","00000","0000",'1'),-- ['[AA]->PCL', 'AAL+1->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","000","000","000000","011","000","000","0000","00000","0000",'1'),-- ['[AA]->PCH']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 6D ADC ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("01","001","00","101","000","000000","000","000","001","0001","00100","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 6E ROR ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","001","00","101","001","000000","000","000","000","0000","01011","0000",'1'),-- ['ALU([AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 6F BBR6
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 70 BVS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 71 ADC (ZP),Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","110001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH']
	("01","001","00","101","000","000000","000","000","001","0001","00100","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 72 ADC (ZP)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("01","001","00","101","000","000000","000","000","001","0001","00100","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 73 TII
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0011",'1'),-- ['Y->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0001",'1'),-- ['A->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","000","000","0000","00000","0010",'1'),-- ['0->[21:SP]'] 
	("00","000","00","000","000","000000","001","000","010","0000","00000","0000",'1'),-- ['[PC]->0', 'PC++'] 
	("00","000","01","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->SH', 'PC++'] 
	("00","000","00","000","000","000000","001","000","100","0000","00000","0000",'1'),-- ['[PC]->Y', 'PC++'] 
	("00","000","10","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->DH', 'PC++'] 
	-- 74 STZ ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("10","011","00","000","000","000000","000","000","000","0000","00000","1111",'1'),-- ['0->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 75 ADC ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("01","011","00","101","000","000000","000","000","001","0001","00100","0000",'1'),-- ['ALU(A,[20:AAL])->A', 'Flags'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 76 ROR ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","101","001","000000","000","000","000","0000","01011","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 77 RMB7
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01101","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 78 SEI
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","100","000","000000","000","000","000","0000","00000","0000",'1'),-- ['Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 79 ADC ABS,Y/ABS,Y,(0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH']
	("01","001","00","101","000","000000","000","000","001","0001","00100","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 7A PLY
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","010","000","0000","00000","0000",'0'),-- ['SP++']
	("10","010","00","001","000","000000","000","000","100","0000","00000","0000",'1'),-- ['ALU([21:SP])->Y']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 7B
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 7C JMP (ABS,0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("00","001","00","000","000","010000","010","000","000","0000","00000","0000",'1'),-- ['[AA]->PCL', 'AAL+1->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","000","000","000000","011","000","000","0000","00000","0000",'1'),-- ['[AA]->PCH']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 7D ADC ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("01","001","00","101","000","000000","000","000","001","0001","00100","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 7E ROR ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH']
	("00","001","00","101","001","000000","000","000","000","0000","01011","0000",'1'),-- ['ALU([AA])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 7F BBR7
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'1'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 80 BRA
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 81 STA (ZP,0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0001",'1'),-- ['A->[AA]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 82 CL0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","010","1111","00000","0000",'1'),-- ['0->0'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 83 TST IMM,ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","001","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->T', 'PC++']
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","101","000","000000","000","000","000","0101","01100","0000",'1'),-- ['ALU(T,[20:AAL])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 84 STY ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0011",'1'),-- ['Y->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 85 STA ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0001",'1'),-- ['A->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 86 ST0 ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0010",'1'),-- ['0->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 87 SMB0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01110","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 88 DEY
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","100","0011","00110","0000",'1'),-- ['ALU(Y)->Y', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 89 BIT IMM
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","101","000","000000","001","000","000","0001","01100","0000",'1'),-- ['ALU(A,[PC])', 'PC++', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 8A T0A
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","001","0010","00000","0000",'1'),-- ['ALU(0)->A']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 8B
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 8C STY ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0011",'1'),-- ['Y->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 8D STA ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0001",'1'),-- ['A->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 8E ST0 ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0010",'1'),-- ['0->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 8F BBS0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- 90 BCC
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 91 STA (ZP),Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","110001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","000","000","000000","000","000","000","0000","00000","0001",'1'),-- ['A->[AA]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 92 STA (ZP)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0001",'1'),-- ['A->[AA]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 93 TST IMM,ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","001","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->T', 'PC++']
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","101","000","000000","000","000","000","0101","01100","0000",'1'),-- ['ALU(T,[AA])', 'Flags']
	-- 94 STY ZP, 0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("10","011","00","000","000","000000","000","000","000","0000","00000","0011",'1'),-- ['Y->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 95 STA ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("10","011","00","000","000","000000","000","000","000","0000","00000","0001",'1'),-- ['A->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 96 ST0 ZP,Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100000","000","000","000","0000","00000","0000",'0'),-- ['AAL+Y->AAL']
	("10","011","00","000","000","000000","000","000","000","0000","00000","0010",'1'),-- ['0->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 97 SMB1
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01110","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 98 TYA
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","001","0011","00000","0000",'1'),-- ['ALU(Y)->A'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 99 STA ABS,Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","000","000","000000","000","000","000","0000","00000","0001",'1'),-- ['A->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 9A T0S
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","001","000","0010","00000","0000",'1'),-- ['0->SP'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 9B
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 9C STZ ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","1111",'1'),-- ['0->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 9D STA ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","000","000","000000","000","000","000","0000","00000","0001",'1'),-- ['A->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 9E STZ ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","000","000","000000","000","000","000","0000","00000","1111",'1'),-- ['0->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- 9F BBS1
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- A0 LDY IMM
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","001","000","100","0000","00000","0000",'1'),-- ['ALU([PC])->Y', 'PC++', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- A1 LDA (ZP,0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0000","00000","0000",'1'),-- ['ALU([AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- A2 LD0 IMM
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","001","000","010","0000","00000","0000",'1'),-- ['ALU([PC])->0', 'PC++', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- A3 TST IMM,ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","001","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->T', 'PC++']
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","101","000","000000","000","000","000","0101","01100","0000",'1'),-- ['ALU(T,[20:AAL])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- A4 LDY ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","001","000","000000","000","000","100","0000","00000","0000",'1'),-- ['ALU([20:AAL])->Y', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- A5 LDA ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","001","000","000000","000","000","001","0000","00000","0000",'1'),-- ['ALU([20:AAL])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- A6 LD0 ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","001","000","000000","000","000","010","0000","00000","0000",'1'),-- ['ALU([20:AAL])->0', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- A7 SMB2
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01110","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- A8 TAY
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","100","0001","00000","0000",'1'),-- ['ALU(A)->Y', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- A9 LDA IMM
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","001","000","001","0000","00000","0000",'1'),-- ['ALU([PC])->A', 'PC++', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- AA TA0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","010","0001","00000","0000",'1'),-- ['ALU(A)->0', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- AB
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- AC LDY ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","100","0000","00000","0000",'1'),-- ['ALU([AA])->Y', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- AD LDA ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0000","00000","0000",'1'),-- ['ALU([AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- AE LD0 ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","010","0000","00000","0000",'1'),-- ['ALU([AA])->0', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- AF BBS2
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- B0 BCS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- B1 LDA (ZP),Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","110001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0000","00000","0000",'1'),-- ['ALU([AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- B2 LDA (ZP)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","001","000","000000","000","000","001","0000","00000","0000",'1'),-- ['ALU([AA])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- B3 TST IMM,ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","001","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->T', 'PC++']
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","101","000","000000","000","000","000","0101","01100","0000",'1'),-- ['ALU(T,[AA])', 'Flags']
	-- B4 LDY ZP, 0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("10","011","00","001","000","000000","000","000","100","0000","00000","0000",'1'),-- ['ALU([20:AAL])->Y', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- B5 LDA ZP, 0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("10","011","00","001","000","000000","000","000","001","0000","00000","0000",'1'),-- ['ALU([20:AAL])->A', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- B6 LD0 ZP, Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100000","000","000","000","0000","00000","0000",'0'),-- ['AAL+Y->AAL']
	("10","011","00","001","000","000000","000","000","010","0000","00000","0000",'1'),-- ['ALU([20:AAL])->0', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- B7 SMB3
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01110","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- B8 CLV
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","100","000","000000","000","000","000","0000","00000","0000",'1'),-- ['Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- B9 LDA ABS,Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0000","00000","0000",'1'),-- ['ALU([AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- BA TS0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","010","0100","00000","0000",'1'),-- ['ALU(SP)->0'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- BB
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- BC LDY ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0/Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","100","0000","00000","0000",'1'),-- ['ALU([AA])->Y', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- BD LDA ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","001","0000","00000","0000",'1'),-- ['ALU([AA])->A', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- BE LD0 ABS,Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0/Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","001","000","000000","000","000","010","0000","00000","0000",'1'),-- ['ALU([AA])->0', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- BF BBS3
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- C0 CPY IMM
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","101","000","000000","001","000","000","0011","01111","0000",'1'),-- ['ALU(Y,[PC])', 'PC++', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- C1 CMP (ZP,0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","101","000","000000","000","000","000","0001","01111","0000",'1'),-- ['ALU(A,[AA])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- C2 CLY
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","100","1111","00000","0000",'1'),-- ['0->Y'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- C3 TDD
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0011",'1'),-- ['Y->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0001",'1'),-- ['A->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","000","000","0000","00000","0010",'1'),-- ['0->[21:SP]'] 
	("00","000","00","000","000","000000","001","000","010","0000","00000","0000",'1'),-- ['[PC]->0', 'PC++'] 
	("00","000","01","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->SH', 'PC++'] 
	("00","000","00","000","000","000000","001","000","100","0000","00000","0000",'1'),-- ['[PC]->Y', 'PC++'] 
	("00","000","10","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->DH', 'PC++'] 
	-- C4 CPY ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","101","000","000000","000","000","000","0011","01111","0000",'1'),-- ['ALU(Y,[20:AAL])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- C5 CMP ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","101","000","000000","000","000","000","0001","01111","0000",'1'),-- ['ALU(A,[20:AAL])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- C6 DEC ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","001","001","000000","000","000","000","0000","00110","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- C7 SMB4
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01110","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- C8 INY
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","100","0011","00111","0000",'1'),-- ['ALU(Y)->Y', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- C9 CMP IMM
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","101","000","000000","001","000","000","0001","01111","0000",'1'),-- ['ALU(A,[PC])', 'PC++', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- CA DE0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","010","0010","00110","0000",'1'),-- ['ALU(0)->0', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- CB
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- CC CPY ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","101","000","000000","000","000","000","0011","01111","0000",'1'),-- ['ALU(Y,[AA])', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- CD CMP ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","101","000","000000","000","000","000","0001","01111","0000",'1'),-- ['ALU(A,[AA])', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- CE DEC ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","001","00","001","001","000000","000","000","000","0000","00110","0000",'1'),-- ['ALU([AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- CF BBS4
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- D0 BNE
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- D1 CMP (ZP),Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","110001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","101","000","000000","000","000","000","0001","01111","0000",'1'),-- ['ALU(A,[AA])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- D2 CMP (ZP)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","101","000","000000","000","000","000","0001","01111","0000",'1'),-- ['ALU(A,[AA])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- D3 TIN
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0011",'1'),-- ['Y->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0001",'1'),-- ['A->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","000","000","0000","00000","0010",'1'),-- ['0->[21:SP]'] 
	("00","000","00","000","000","000000","001","000","010","0000","00000","0000",'1'),-- ['[PC]->0', 'PC++'] 
	("00","000","01","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->SH', 'PC++'] 
	("00","000","00","000","000","000000","001","000","100","0000","00000","0000",'1'),-- ['[PC]->Y', 'PC++'] 
	("00","000","10","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->DH', 'PC++'] 
	-- D4 CSH
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- D5 CMP ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("10","011","00","101","000","000000","000","000","000","0001","01111","0000",'1'),-- ['ALU(A,[20:AAL])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- D6 DEC ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","001","001","000000","000","000","000","0000","00110","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- D7 SMB5
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01110","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- D8 CLD
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","100","000","000000","000","000","000","0000","00000","0000",'1'),-- ['Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- D9 CMP ABS,Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","101","000","000000","000","000","000","0001","01111","0000",'1'),-- ['ALU(A,[AA])', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- DA PH0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","010","00","000","000","000000","000","011","000","0000","00000","0010",'1'),-- ['0->[21:SP]', 'SP--']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- DB
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- DC
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- DD CMP ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("10","001","00","101","000","000000","000","000","000","0001","01111","0000",'1'),-- ['ALU(A,[AA])', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- DE DEC ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH']
	("00","001","00","001","001","000000","000","000","000","0000","00110","0000",'1'),-- ['ALU([AA])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- DF BBS5
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- E0 CP0 IMM
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","101","000","000000","001","000","000","0010","01111","0000",'1'),-- ['ALU(0,[PC])', 'PC++', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- E1 SBC (ZP,0)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("01","001","00","101","000","000000","000","000","001","0001","00101","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- E2
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- E3 TIA
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0011",'1'),-- ['Y->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0001",'1'),-- ['A->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","000","000","0000","00000","0010",'1'),-- ['0->[21:SP]'] 
	("00","000","00","000","000","000000","001","000","010","0000","00000","0000",'1'),-- ['[PC]->0', 'PC++'] 
	("00","000","01","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->SH', 'PC++'] 
	("00","000","00","000","000","000000","001","000","100","0000","00000","0000",'1'),-- ['[PC]->Y', 'PC++'] 
	("00","000","10","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->DH', 'PC++'] 
	-- E4 CP0 ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","101","000","000000","000","000","000","0010","01111","0000",'1'),-- ['ALU(0,[20:AAL])', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- E5 SBC ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("01","011","00","101","000","000000","000","000","001","0001","00101","0000",'1'),-- ['ALU(A,[20:AAL])->A', 'Flags'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- E6 INC ZP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","001","001","000000","000","000","000","0000","00111","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- E7 SMB6
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01110","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- E8 IN0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","001","000","000000","000","000","010","0010","00111","0000",'1'),-- ['ALU(0)->0', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- E9 SBC IMM
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("01","000","00","101","000","000000","001","000","001","0001","00101","0000",'1'),-- ['ALU(A,[PC])->A', 'PC++', 'Flags'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- EA NOP
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- EB
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- EC CP0 ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","101","000","000000","000","000","000","0010","01111","0000",'1'),-- ['ALU(0,[AA])', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- ED SBC ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","101","000","000000","000","000","001","0001","00101","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- EE INC ABS
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","001","00","001","001","000000","000","000","000","0000","00111","0000",'1'),-- ['ALU([AA])->T', 'Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- EF BBS6
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	-- F0 BEQ
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- []
	("10","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- F1 SBC (ZP),Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","110001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("01","001","00","101","000","000000","000","000","001","0001","00101","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- [] 
	-- F2 SBC (ZP)
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","010000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR', 'AAL+1->AAL'] 
	("00","011","00","000","000","101001","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->AAH', 'DR->AAL']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("01","001","00","101","000","000000","000","000","001","0001","00101","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- [] 
	-- F3 TAI
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0011",'1'),-- ['Y->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","011","000","0000","00000","0001",'1'),-- ['A->[21:SP]', 'SP--'] 
	("00","010","00","000","000","000000","000","000","000","0000","00000","0010",'1'),-- ['0->[21:SP]'] 
	("00","000","00","000","000","000000","001","000","010","0000","00000","0000",'1'),-- ['[PC]->0', 'PC++'] 
	("00","000","01","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->SH', 'PC++'] 
	("00","000","00","000","000","000000","001","000","100","0000","00000","0000",'1'),-- ['[PC]->Y', 'PC++'] 
	("00","000","10","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->DH', 'PC++'] 
	-- F4 SET
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","110","000","000000","000","000","000","0000","00000","0000",'1'),-- ['Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- F5 SBC ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("01","011","00","101","000","000000","000","000","001","0001","00101","0000",'1'),-- ['ALU(A,[20:AAL])->A', 'Flags'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- F6 INC ZP,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011000","000","000","000","0000","00000","0000",'0'),-- ['AAL+0->AAL']
	("00","011","00","001","001","000000","000","000","000","0000","00111","0000",'1'),-- ['ALU([20:AAL])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- F7 SMB7
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","001","000000","000","000","000","1100","01110","0000",'1'),-- ['ALU([20:AAL])->T'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","011","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[20:AAL]'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- F8 SED
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","100","000","000000","000","000","000","0000","00000","0000",'1'),-- ['Flags']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- F9 SBC ABS,Y
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","100001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+Y->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH'] 
	("01","001","00","101","000","000000","000","000","001","0001","00101","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- FA PL0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","010","000","0000","00000","0000",'0'),-- ['SP++']
	("10","010","00","001","000","000000","000","000","010","0000","00000","0000",'1'),-- ['ALU([21:SP])->0']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- FB
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- FC
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- FD SBC ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH']
	("01","001","00","101","000","000000","000","000","001","0001","00101","0000",'1'),-- ['ALU(A,[AA])->A', 'Flags']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- FE INC ABS,0
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","011001","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAH', 'PC++', 'AAL+0->AAL']
	("00","000","00","000","000","000011","000","000","000","0000","00000","0000",'0'),-- ['AAH+AALCarry->AAH']
	("00","001","00","001","001","000000","000","000","000","0000","00111","0000",'1'),-- ['ALU([AA])->T', 'Flags'] 
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("10","001","00","000","000","000000","000","000","000","0000","00000","0100",'1'),-- ['T->[AA]']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),
	-- FF BBS7
	("00","000","00","000","000","000000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->IR', 'PC++'] 
	("00","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","000","00","000","000","000000","000","000","000","0000","00000","0000",'0'),-- []
	("00","011","00","000","000","000000","000","000","000","0000","00000","0000",'1'),-- ['[20:AAL]->DR']
	("10","000","00","000","000","001000","001","000","000","0000","00000","0000",'1'),-- ['[PC]->AAL', 'PC++']
	("00","000","00","000","000","000000","100","000","000","0000","00000","0000",'0'),-- ['PC+AAL->PC']
	("10","000","00","000","000","000000","000","000","000","0000","00000","0000",'0') -- []
	);
end;
