/*
  Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/
*/

var testGenerator = testSteps();

function* testSteps()
{
  const name = "test_wasm_recompile.js";

  const objectStoreName = "Wasm";

  const wasmData = { key: 1, wasm: null };

  if (!isWasmSupported()) {
    finishTest();
    yield undefined;
  }

  getWasmBinary('(module (func $f (result i32) (i32.const 42)) (func (export "run") (result i32) (call $f)))');
  let binary = yield undefined;

  wasmData.wasm = getWasmModule(binary);

  info("Opening database");

  let request = indexedDB.open(name);
  request.onerror = errorHandler;
  request.onupgradeneeded = continueToNextStepSync;
  request.onsuccess = unexpectedSuccessHandler;
  yield undefined;

  // upgradeneeded
  request.onupgradeneeded = unexpectedSuccessHandler;
  request.onsuccess = continueToNextStepSync;

  info("Creating objectStore");

  let objectStore = request.result.createObjectStore(objectStoreName);
  objectStore.add(wasmData.wasm, wasmData.key);

  yield undefined;

  // success

  finishTest();
  yield undefined;
}
